/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.server;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.Lifecycle;
import com.threerings.crowd.Log;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.crowd.server.PlaceManager;
import com.threerings.crowd.server.PlaceManagerDelegate;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.InvocationException;
import com.threerings.presents.server.InvocationManager;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PlaceRegistry
implements Lifecycle.ShutdownComponent {
    @Inject
    protected Injector _injector;
    @Inject
    protected InvocationManager _invmgr;
    @Inject
    protected RootDObjectManager _omgr;
    @Inject
    protected BodyLocator _locator;
    protected IntMap<PlaceManager> _pmgrs = IntMaps.newHashIntMap();

    @Inject
    public PlaceRegistry(Lifecycle cycle) {
        cycle.addComponent((Lifecycle.BaseComponent)this);
    }

    public PlaceManager getPlaceManager(int placeOid) {
        return (PlaceManager)this._pmgrs.get(placeOid);
    }

    public PlaceManager createPlace(PlaceConfig config) throws InstantiationException, InvocationException {
        return this.createPlace(config, null, null);
    }

    public PlaceManager createPlace(PlaceConfig config, List<PlaceManagerDelegate> delegates) throws InstantiationException, InvocationException {
        return this.createPlace(config, delegates, null);
    }

    public PlaceManager createPlace(PlaceConfig config, PreStartupHook hook) throws InstantiationException, InvocationException {
        return this.createPlace(config, null, hook);
    }

    public Iterator<PlaceObject> enumeratePlaces() {
        final Iterator itr = this._pmgrs.values().iterator();
        return new Iterator<PlaceObject>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public PlaceObject next() {
                PlaceManager plmgr = (PlaceManager)itr.next();
                return plmgr == null ? null : plmgr.getPlaceObject();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<PlaceManager> enumeratePlaceManagers() {
        return this._pmgrs.values().iterator();
    }

    public void shutdown() {
        Iterator<PlaceManager> iter = this.enumeratePlaceManagers();
        while (iter.hasNext()) {
            PlaceManager pmgr = iter.next();
            try {
                pmgr.shutdown();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Place manager failed shutting down", new Object[]{"where", pmgr.where(), e});
            }
        }
    }

    protected PlaceManager createPlace(PlaceConfig config, List<PlaceManagerDelegate> delegates, PreStartupHook hook) throws InstantiationException, InvocationException {
        PlaceManager pmgr = null;
        try {
            pmgr = this.createPlaceManager(config);
            if (delegates != null) {
                for (PlaceManagerDelegate delegate : delegates) {
                    this._injector.injectMembers((Object)delegate);
                    pmgr.addDelegate(delegate);
                }
            }
            pmgr.init(this, this._invmgr, this._omgr, this.selectLocator(config), config);
        }
        catch (Exception e) {
            Log.log.warning((Object)e, new Object[0]);
            throw new InstantiationException("Error creating PlaceManager for " + config);
        }
        String errmsg = pmgr.checkPermissions();
        if (errmsg != null) {
            pmgr.permissionsFailed();
            throw new InvocationException(errmsg);
        }
        PlaceObject plobj = pmgr.createPlaceObject();
        this._omgr.registerObject(plobj);
        this._pmgrs.put(plobj.getOid(), (Object)pmgr);
        try {
            if (hook != null) {
                hook.invoke(pmgr);
            }
            pmgr.startup(plobj);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Error starting place manager", new Object[]{"obj", plobj, "pmgr", pmgr, e});
        }
        return pmgr;
    }

    protected PlaceManager createPlaceManager(PlaceConfig config) throws Exception {
        Class<?> clazz = Class.forName(config.getManagerClassName());
        return (PlaceManager)this._injector.getInstance(clazz);
    }

    protected BodyLocator selectLocator(PlaceConfig config) {
        return this._locator;
    }

    protected void unmapPlaceManager(PlaceManager pmgr) {
        int ploid = pmgr.getPlaceObject().getOid();
        if (this._pmgrs.remove(ploid) == null) {
            Log.log.warning((Object)"Requested to unmap unmapped place manager", new Object[]{"pmgr", pmgr});
        }
    }

    public static interface PreStartupHook {
        public void invoke(PlaceManager var1);
    }
}

