/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.server;

import com.google.inject.Inject;
import com.threerings.crowd.chat.server.ChatHistory;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.crowd.server.BodyManager;
import com.threerings.crowd.server.LocationManager;
import com.threerings.presents.server.PresentsSession;

public class CrowdSession
extends PresentsSession {
    @Inject
    protected BodyLocator _locator;
    @Inject
    protected BodyManager _bodyman;
    @Inject
    protected LocationManager _locman;
    @Inject
    protected ChatHistory _chatHistory;

    protected void sessionConnectionClosed() {
        BodyObject bobj;
        super.sessionConnectionClosed();
        if (this._clobj != null && (bobj = this._locator.forClient(this._clobj)) != null) {
            this._bodyman.updateOccupantStatus(bobj, (byte)2);
        }
    }

    protected void sessionWillResume() {
        super.sessionWillResume();
        BodyObject bobj = this._locator.forClient(this._clobj);
        if (bobj != null) {
            this._bodyman.updateOccupantStatus(bobj, (byte)0);
        }
    }

    protected void sessionDidEnd() {
        super.sessionDidEnd();
        BodyObject body = this._locator.forClient(this._clobj);
        if (body == null) {
            return;
        }
        this.clearLocation(body);
        this._bodyman.updateOccupantStatus(body, (byte)0);
        this._chatHistory.clear(body.getVisibleName());
    }

    protected void clearLocation(BodyObject bobj) {
        this._locman.leaveOccupiedPlace(bobj);
    }
}

