/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.data;

import com.threerings.crowd.chat.data.ChatCodes;
import com.threerings.crowd.chat.data.SpeakObject;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.data.Place;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.data.TokenRing;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.Permission;
import com.threerings.util.Name;

public class BodyObject
extends ClientObject
implements SpeakObject {
    public static final String LOCATION = "location";
    public static final String STATUS = "status";
    public static final String AWAY_MESSAGE = "awayMessage";
    public Place location;
    public byte status;
    public String awayMessage;
    protected static final TokenRing EMPTY_TOKENS = new TokenRing(0);

    public int getPlaceOid() {
        return this.location == null ? -1 : this.location.placeOid;
    }

    public TokenRing getTokens() {
        return EMPTY_TOKENS;
    }

    public Name getVisibleName() {
        return this.username;
    }

    public OccupantInfo createOccupantInfo(PlaceObject plobj) {
        return new OccupantInfo(this);
    }

    public void willEnterPlace(Place place, PlaceObject plobj) {
        this.setLocation(place);
    }

    public void didLeavePlace(PlaceObject plobj) {
        this.setLocation(null);
    }

    public void applyToListeners(SpeakObject.ListenerOp op) {
        op.apply(this.getVisibleName());
    }

    public ClientObject getClientObject() {
        return this;
    }

    public String who() {
        StringBuilder buf = new StringBuilder(this.username.toString());
        buf.append(" (");
        this.addWhoData(buf);
        return buf.append(")").toString();
    }

    public void setLocation(Place value) {
        Place ovalue = this.location;
        this.requestAttributeChange(LOCATION, value, ovalue);
        this.location = value;
    }

    public void setStatus(byte value) {
        byte ovalue = this.status;
        this.requestAttributeChange(STATUS, value, ovalue);
        this.status = value;
    }

    public void setAwayMessage(String value) {
        String ovalue = this.awayMessage;
        this.requestAttributeChange(AWAY_MESSAGE, value, ovalue);
        this.awayMessage = value;
    }

    protected void addWhoData(StringBuilder buf) {
        buf.append(this.getOid());
        if (this.status != 0) {
            buf.append(" ").append(this.getStatusTranslation());
        }
    }

    protected String getStatusTranslation() {
        return OccupantInfo.X_STATUS[this.status];
    }

    protected ClientObject.PermissionPolicy createPermissionPolicy() {
        return new CrowdPermissionPolicy();
    }

    protected class CrowdPermissionPolicy
    extends ClientObject.PermissionPolicy {
        protected CrowdPermissionPolicy() {
            super(BodyObject.this);
        }

        public String checkAccess(Permission perm, Object context) {
            if (perm == ChatCodes.BROADCAST_ACCESS) {
                return BodyObject.this.getTokens().isAdmin() ? null : "m.access_denied";
            }
            if (perm == ChatCodes.CHAT_ACCESS) {
                return null;
            }
            return super.checkAccess(perm, context);
        }
    }
}

