/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.client;

import com.samskivert.util.ObserverList;
import com.threerings.crowd.client.LocationObserver;
import com.threerings.crowd.client.OccupantObserver;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.presents.client.BasicDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.SetListener;
import com.threerings.util.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OccupantDirector
extends BasicDirector
implements LocationObserver,
SetListener<OccupantInfo> {
    protected ObserverList<OccupantObserver> _observers = ObserverList.newSafeInOrder();
    protected PlaceObject _place;

    public OccupantDirector(CrowdContext ctx) {
        super(ctx);
        ctx.getLocationDirector().addLocationObserver(this);
    }

    public void addOccupantObserver(OccupantObserver obs) {
        this._observers.add((Object)obs);
    }

    public void removeOccupantObserver(OccupantObserver obs) {
        this._observers.remove((Object)obs);
    }

    public OccupantInfo getOccupantInfo(int bodyOid) {
        return this._place == null ? null : this._place.occupantInfo.get(Integer.valueOf(bodyOid));
    }

    public OccupantInfo getOccupantInfo(Name username) {
        return this._place == null ? null : this._place.getOccupantInfo(username);
    }

    @Override
    public void clientDidLogoff(Client client) {
        if (this._place != null) {
            this._place.removeListener(this);
            this._place = null;
        }
    }

    @Override
    public boolean locationMayChange(int placeId) {
        return true;
    }

    @Override
    public void locationDidChange(PlaceObject place) {
        if (this._place != null) {
            this._place.removeListener(this);
        }
        this._place = place;
        if (this._place != null) {
            this._place.addListener(this);
        }
    }

    @Override
    public void locationChangeFailed(int placeId, String reason) {
    }

    @Override
    public void entryAdded(EntryAddedEvent<OccupantInfo> event) {
        if (!event.getName().equals("occupantInfo")) {
            return;
        }
        final OccupantInfo info = event.getEntry();
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<OccupantObserver>(){

            public boolean apply(OccupantObserver observer) {
                observer.occupantEntered(info);
                return true;
            }
        });
    }

    @Override
    public void entryUpdated(EntryUpdatedEvent<OccupantInfo> event) {
        if (!event.getName().equals("occupantInfo")) {
            return;
        }
        final OccupantInfo info = event.getEntry();
        final OccupantInfo oinfo = event.getOldEntry();
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<OccupantObserver>(){

            public boolean apply(OccupantObserver observer) {
                observer.occupantUpdated(oinfo, info);
                return true;
            }
        });
    }

    @Override
    public void entryRemoved(EntryRemovedEvent<OccupantInfo> event) {
        if (!event.getName().equals("occupantInfo")) {
            return;
        }
        final OccupantInfo oinfo = event.getOldEntry();
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<OccupantObserver>(){

            public boolean apply(OccupantObserver observer) {
                observer.occupantLeft(oinfo);
                return true;
            }
        });
    }
}

