/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.chat.client;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.ObserverList;
import com.samskivert.util.ResultListener;
import com.samskivert.util.StringUtil;
import com.threerings.crowd.Log;
import com.threerings.crowd.chat.client.ChatDisplay;
import com.threerings.crowd.chat.client.ChatFilter;
import com.threerings.crowd.chat.client.ChatService;
import com.threerings.crowd.chat.client.HistoryList;
import com.threerings.crowd.chat.client.SpeakService;
import com.threerings.crowd.chat.data.ChatCodes;
import com.threerings.crowd.chat.data.ChatMessage;
import com.threerings.crowd.chat.data.SystemMessage;
import com.threerings.crowd.chat.data.TellFeedbackMessage;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.chat.data.UserSystemMessage;
import com.threerings.crowd.client.LocationObserver;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.presents.client.BasicDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.MessageEvent;
import com.threerings.presents.dobj.MessageListener;
import com.threerings.util.MessageBundle;
import com.threerings.util.Name;
import com.threerings.util.TimeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatDirector
extends BasicDirector
implements ChatCodes,
LocationObserver,
MessageListener {
    protected CrowdContext _ctx;
    protected ChatService _cservice;
    protected String _bundle;
    protected PlaceObject _place;
    protected ClientObject _clobj;
    protected boolean _mogrifyChat = true;
    protected ObserverList<ChatDisplay> _displays = new ObserverList(1);
    protected ObserverList<ChatFilter> _filters = new ObserverList(1);
    protected HashIntMap<String> _auxes = new HashIntMap();
    protected ChatterValidator _chatterValidator;
    protected LinkedList<Name> _chatters = new LinkedList();
    protected ObserverList<ChatterObserver> _chatterObservers = new ObserverList(1);
    protected FilterMessageOp _filterMessageOp = new FilterMessageOp();
    protected DisplayMessageOp _displayMessageOp = new DisplayMessageOp();
    protected HistoryList _hlist;
    protected static HashMap<String, CommandHandler> _handlers = Maps.newHashMap();
    protected static ArrayList<String> _history = Lists.newArrayList();
    protected static boolean _showAliasesInUsage;
    protected static final int MAX_CHATTERS = 6;
    protected static final int MAX_COMMAND_HISTORY = 10;

    public ChatDirector(CrowdContext ctx, String bundle) {
        super(ctx);
        this._ctx = ctx;
        this._bundle = bundle;
        this._ctx.getLocationDirector().addLocationObserver(this);
        if (this._bundle == null || this._ctx.getMessageManager() == null) {
            Log.log.warning((Object)"Null bundle or message manager given to ChatDirector", new Object[0]);
            return;
        }
        this.registerCommandHandlers();
    }

    public void pushChatDisplay(ChatDisplay display) {
        this._displays.add(0, (Object)display);
    }

    public boolean addChatDisplay(ChatDisplay display) {
        return this._displays.add((Object)display);
    }

    public boolean removeChatDisplay(ChatDisplay display) {
        return this._displays.remove((Object)display);
    }

    public boolean addChatFilter(ChatFilter filter) {
        return this._filters.add((Object)filter);
    }

    public boolean removeChatFilter(ChatFilter filter) {
        return this._filters.remove((Object)filter);
    }

    public boolean addChatterObserver(ChatterObserver co) {
        boolean added = this._chatterObservers.add((Object)co);
        co.chattersUpdated(this._chatters.listIterator());
        return added;
    }

    public boolean removeChatterObserver(ChatterObserver co) {
        return this._chatterObservers.remove((Object)co);
    }

    public void setChatterValidator(ChatterValidator validator) {
        this._chatterValidator = validator;
    }

    public void setMogrifyChat(boolean mogrifyChat) {
        this._mogrifyChat = mogrifyChat;
    }

    public void registerCommandHandler(MessageBundle msg, String command, CommandHandler handler) {
        String[] stringArray;
        handler._usageKey = "m.usage_" + command;
        String key = "c." + command;
        if (msg.exists(key)) {
            stringArray = msg.get(key).split("\\s+");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = command;
        }
        for (String alias : handler._aliases = stringArray) {
            _handlers.put(alias, handler);
        }
    }

    public int getCommandHistorySize() {
        return _history.size();
    }

    public String getCommandHistory(int index) {
        return _history.get(index);
    }

    public void clearCommandHistory() {
        _history.clear();
    }

    public void clearDisplays() {
        this._displays.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ChatDisplay>(){

            public boolean apply(ChatDisplay observer) {
                observer.clear();
                return true;
            }
        });
    }

    public void displayInfo(String bundle, String message) {
        this.displaySystem(bundle, message, (byte)0, "placeChat");
    }

    public void displayInfo(String bundle, String message, String localtype) {
        this.displaySystem(bundle, message, (byte)0, localtype);
    }

    public void displayFeedback(String bundle, String message) {
        this.displaySystem(bundle, message, (byte)1, "placeChat");
    }

    public void displayAttention(String bundle, String message) {
        this.displaySystem(bundle, message, (byte)2, "placeChat");
    }

    public void dispatchMessage(ChatMessage message, String localType) {
        this.setClientInfo(message, localType);
        this.dispatchPreparedMessage(message);
    }

    public String requestChat(SpeakService speakSvc, String text, boolean record) {
        if (text.startsWith("/")) {
            String command = text.substring(1).toLowerCase();
            String[] hist = new String[1];
            String args = "";
            int sidx = text.indexOf(" ");
            if (sidx != -1) {
                command = text.substring(1, sidx).toLowerCase();
                args = text.substring(sidx + 1).trim();
            }
            Map<String, CommandHandler> possibleCommands = this.getCommandHandlers(command);
            switch (possibleCommands.size()) {
                case 0: {
                    StringTokenizer tok = new StringTokenizer(text);
                    return MessageBundle.tcompose("m.unknown_command", (Object)tok.nextToken());
                }
                case 1: {
                    Map.Entry<String, CommandHandler> entry = possibleCommands.entrySet().iterator().next();
                    String cmdName = entry.getKey();
                    CommandHandler cmd = entry.getValue();
                    String result = cmd.handleCommand(speakSvc, cmdName, args, hist);
                    if (!result.equals("success")) {
                        return result;
                    }
                    if (record) {
                        hist[0] = "/" + (hist[0] == null ? command : hist[0]);
                        this.addToHistory(hist[0]);
                    }
                    return result;
                }
            }
            StringBuilder buf = new StringBuilder();
            for (String pcmd : Sets.newTreeSet(possibleCommands.keySet())) {
                buf.append(" /").append(pcmd);
            }
            return MessageBundle.tcompose("m.unspecific_command", (Object)buf.toString());
        }
        String message = text.trim();
        if (StringUtil.isBlank((String)message)) {
            return "success";
        }
        return this.deliverChat(speakSvc, message, (byte)0);
    }

    public void requestSpeak(SpeakService speakService, String message, byte mode) {
        if (speakService == null) {
            if (this._place == null) {
                return;
            }
            speakService = this._place.speakService;
        }
        if ((message = this.filter(message, null, true)) == null) {
            return;
        }
        speakService.speak(message, mode);
    }

    public void requestBroadcast(String message) {
        if ((message = this.filter(message, null, true)) == null) {
            this.displayFeedback(this._bundle, MessageBundle.compose("m.broadcast_failed", (Object)"m.filtered"));
            return;
        }
        this._cservice.broadcast(message, new InvocationService.InvocationListener(){

            public void requestFailed(String reason) {
                reason = MessageBundle.compose("m.broadcast_failed", (Object)reason);
                ChatDirector.this.displayFeedback(ChatDirector.this._bundle, reason);
            }
        });
    }

    public <T extends Name> void requestTell(final T target, String msg, final ResultListener<T> rl) {
        final String message = this.filter(msg, target, true);
        if (message == null) {
            if (rl != null) {
                rl.requestFailed(null);
            }
            return;
        }
        ChatService.TellListener listener = new ChatService.TellListener(){

            public void tellSucceeded(long idletime, String awayMessage) {
                String msg;
                this.success();
                if (awayMessage != null && (awayMessage = ChatDirector.this.filter(awayMessage, target, false)) != null) {
                    msg = MessageBundle.tcompose("m.recipient_afk", (Object)target, (Object)awayMessage);
                    ChatDirector.this.displayFeedback(ChatDirector.this._bundle, msg);
                }
                if (idletime > 0L) {
                    msg = MessageBundle.compose("m.recipient_idle", MessageBundle.taint(target), TimeUtil.getTimeOrderString(idletime += ChatDirector.this._ctx.getConfig().getValue("narya.chat.idle_time", 180000L), (byte)2));
                    ChatDirector.this.displayFeedback(ChatDirector.this._bundle, msg);
                }
            }

            protected void success() {
                ChatDirector.this.dispatchMessage(new TellFeedbackMessage(target, message, false), "placeChat");
                ChatDirector.this.addChatter(target);
                if (rl != null) {
                    rl.requestCompleted((Object)target);
                }
            }

            public void requestFailed(String reason) {
                String msg = MessageBundle.compose("m.tell_failed", MessageBundle.taint(target), reason);
                TellFeedbackMessage tfm = new TellFeedbackMessage(target, msg, true);
                tfm.bundle = ChatDirector.this._bundle;
                ChatDirector.this.dispatchMessage(tfm, "placeChat");
                if (rl != null) {
                    rl.requestFailed(null);
                }
            }
        };
        this._cservice.tell(target, message, listener);
    }

    public void setAwayMessage(String message) {
        if (message != null && (message = this.filter(message, null, true)) == null) {
            message = "...";
        }
        this._cservice.away(message);
    }

    public void addAuxiliarySource(DObject source, String localtype) {
        source.addListener(this);
        this._auxes.put(source.getOid(), (Object)localtype);
    }

    public void removeAuxiliarySource(DObject source) {
        source.removeListener(this);
        this._auxes.remove(source.getOid());
    }

    public HistoryList getHistory() {
        if (this._hlist == null) {
            this._hlist = new HistoryList();
            this.addChatDisplay(this._hlist);
        }
        return this._hlist;
    }

    public String filter(String msg, Name otherUser, boolean outgoing) {
        this._filterMessageOp.setMessage(msg, otherUser, outgoing);
        this._filters.apply((ObserverList.ObserverOp)this._filterMessageOp);
        return this._filterMessageOp.getMessage();
    }

    public String mogrifyChat(String text) {
        return this.mogrifyChat(text, (byte)-1, false, true);
    }

    @Override
    public boolean locationMayChange(int placeId) {
        return true;
    }

    @Override
    public void locationDidChange(PlaceObject place) {
        if (this._place != null) {
            this._place.removeListener(this);
        }
        this._place = place;
        if (this._place != null) {
            this._place.addListener(this);
        }
    }

    @Override
    public void locationChangeFailed(int placeId, String reason) {
    }

    @Override
    public void messageReceived(MessageEvent event) {
        if ("crowd.chat".equals(event.getName())) {
            ChatMessage msg = (ChatMessage)event.getArgs()[0];
            String localtype = this.getLocalType(event.getTargetOid());
            this.processReceivedMessage(msg, localtype);
        }
    }

    @Override
    public void clientDidLogon(Client client) {
        super.clientDidLogon(client);
        this._clobj = client.getClientObject();
        this.addAuxiliarySource(this._clobj, "userChat");
    }

    @Override
    public void clientObjectDidChange(Client client) {
        super.clientObjectDidChange(client);
        this.removeAuxiliarySource(this._clobj);
        this._clobj = client.getClientObject();
        this.addAuxiliarySource(this._clobj, "userChat");
        this.clearDisplays();
    }

    @Override
    public void clientDidLogoff(Client client) {
        super.clientDidLogoff(client);
        if (this._clobj != null) {
            this.removeAuxiliarySource(this._clobj);
            this._clobj = null;
        }
        this._auxes.clear();
        this.clearDisplays();
        this._chatters.clear();
        this.notifyChatterObservers();
        this.locationDidChange(null);
        this._cservice = null;
    }

    protected void registerCommandHandlers() {
        MessageBundle msg = this._ctx.getMessageManager().getBundle(this._bundle);
        this.registerCommandHandler(msg, "help", new HelpHandler());
        this.registerCommandHandler(msg, "clear", new ClearHandler());
        this.registerCommandHandler(msg, "speak", new SpeakHandler());
        this.registerCommandHandler(msg, "emote", new EmoteHandler());
        this.registerCommandHandler(msg, "think", new ThinkHandler());
        this.registerCommandHandler(msg, "tell", new TellHandler());
        this.registerCommandHandler(msg, "broadcast", new BroadcastHandler());
    }

    protected void processReceivedMessage(ChatMessage msg, String localtype) {
        String autoResponse = null;
        Name speaker = null;
        Name speakerDisplay = null;
        int mode = -1;
        if (msg instanceof UserMessage) {
            UserMessage umsg = (UserMessage)msg;
            speaker = umsg.speaker;
            speakerDisplay = umsg.getSpeakerDisplayName();
            mode = umsg.mode;
        } else if (msg instanceof UserSystemMessage) {
            speakerDisplay = speaker = ((UserSystemMessage)msg).speaker;
        }
        this.setClientInfo(msg, localtype);
        if (speaker != null) {
            msg.message = this.filter(msg.message, speaker, false);
            if (msg.message == null) {
                return;
            }
            if ("userChat".equals(localtype) && mode == 0) {
                this.addChatter(speaker);
                BodyObject self = (BodyObject)this._ctx.getClient().getClientObject();
                if (!StringUtil.isBlank((String)self.awayMessage)) {
                    autoResponse = self.awayMessage;
                }
            }
        }
        this.dispatchMessage(msg, localtype);
        if (autoResponse != null) {
            String amsg = MessageBundle.tcompose("m.auto_responded", (Object)speakerDisplay, autoResponse);
            this.displayFeedback(this._bundle, amsg);
        }
    }

    protected void dispatchPreparedMessage(ChatMessage message) {
        this._displayMessageOp.setMessage(message);
        this._displays.apply((ObserverList.ObserverOp)this._displayMessageOp);
    }

    protected String checkCanChat(SpeakService speakSvc, String message, byte mode) {
        return null;
    }

    protected String deliverChat(SpeakService speakSvc, String message, byte mode) {
        if ((message = this.mogrifyChat(message, mode, true, mode != 2)).startsWith("/")) {
            return this.requestChat(speakSvc, message, false);
        }
        String errmsg = this.checkCanChat(speakSvc, message, mode);
        if (errmsg != null) {
            return errmsg;
        }
        this.requestSpeak(speakSvc, message, mode);
        return "success";
    }

    protected void addToHistory(String cmd) {
        _history.remove(cmd);
        _history.add(cmd);
        if (_history.size() > 10) {
            _history.remove(0);
        }
    }

    protected String mogrifyChat(String text, byte mode, boolean transformsAllowed, boolean capFirst) {
        int tlen = text.length();
        if (tlen == 0) {
            return text;
        }
        if (tlen > 7 && this.suppressTooManyCaps()) {
            int caps = 0;
            for (int ii = 0; ii < tlen; ++ii) {
                if (!Character.isUpperCase(text.charAt(ii)) || ++caps <= tlen / 2) continue;
                text = text.toLowerCase();
                break;
            }
        }
        StringBuffer buf = new StringBuffer(text);
        buf = this.mogrifyChat(buf, transformsAllowed, capFirst);
        return buf.toString();
    }

    protected StringBuffer mogrifyChat(StringBuffer buf, boolean transformsAllowed, boolean capFirst) {
        if (this._mogrifyChat) {
            buf = this.translatedReplacements("x.mogrifies", buf);
            if (transformsAllowed) {
                buf = this.translatedReplacements("x.transforms", buf);
            }
        }
        return buf;
    }

    protected StringBuffer translatedReplacements(String key, StringBuffer buf) {
        MessageBundle bundle = this._ctx.getMessageManager().getBundle(this._bundle);
        if (!bundle.exists(key)) {
            return buf;
        }
        StringTokenizer st = new StringTokenizer(bundle.get(key), "#");
        while (st.hasMoreTokens()) {
            String pattern = st.nextToken();
            String replace = st.nextToken();
            Matcher m = Pattern.compile(pattern, 2).matcher(buf);
            if (!m.find()) continue;
            buf = new StringBuffer();
            m.appendReplacement(buf, replace);
            while (m.find()) {
                m.appendReplacement(buf, replace);
            }
            m.appendTail(buf);
        }
        return buf;
    }

    protected boolean suppressTooManyCaps() {
        return true;
    }

    protected String checkLength(String msg) {
        return null;
    }

    protected Map<String, CommandHandler> getCommandHandlers(String command) {
        HashMap matches = Maps.newHashMap();
        BodyObject user = (BodyObject)this._ctx.getClient().getClientObject();
        for (Map.Entry<String, CommandHandler> entry : _handlers.entrySet()) {
            if (!this.isCommandPrefix(command, entry.getKey(), entry.getValue(), user)) continue;
            if (entry.getKey().equals(command)) {
                matches.clear();
                matches.put(entry.getKey(), entry.getValue());
                return matches;
            }
            String key = _showAliasesInUsage && command.equals("") ? entry.getValue()._aliases[0] : entry.getKey();
            matches.put(key, entry.getValue());
        }
        return matches;
    }

    protected boolean isCommandPrefix(String enteredCommand, String handlerCommand, CommandHandler handler, BodyObject user) {
        return handlerCommand.startsWith(enteredCommand) && handler.checkAccess(user);
    }

    protected void addChatter(Name name) {
        if (this._chatterValidator != null && !this._chatterValidator.isChatterValid(name)) {
            return;
        }
        boolean wasthere = this._chatters.remove(name);
        this._chatters.addFirst(name);
        if (!wasthere) {
            if (this._chatters.size() > 6) {
                this._chatters.removeLast();
            }
            this.notifyChatterObservers();
        }
    }

    protected void notifyChatterObservers() {
        this._chatterObservers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ChatterObserver>(){

            public boolean apply(ChatterObserver observer) {
                observer.chattersUpdated(ChatDirector.this._chatters.listIterator());
                return true;
            }
        });
    }

    protected void setClientInfo(ChatMessage msg, String localType) {
        if (msg.localtype == null) {
            msg.setClientInfo(this.xlate(msg.bundle, msg.message), localType);
        }
    }

    protected String xlate(String bundle, String message) {
        if (bundle != null && this._ctx.getMessageManager() != null) {
            MessageBundle msgb = this._ctx.getMessageManager().getBundle(bundle);
            if (msgb == null) {
                Log.log.warning((Object)"No message bundle available to translate message", new Object[]{"bundle", bundle, "message", message});
            } else {
                message = msgb.xlate(message);
            }
        }
        return message;
    }

    protected void displaySystem(String bundle, String message, byte attLevel, String localtype) {
        if (bundle == null) {
            bundle = this._bundle;
        }
        SystemMessage msg = new SystemMessage(message, bundle, attLevel);
        this.dispatchMessage(msg, localtype);
    }

    protected String getLocalType(int oid) {
        String type = (String)this._auxes.get(oid);
        return type == null ? "placeChat" : type;
    }

    @Override
    protected void registerServices(Client client) {
        client.addServiceGroup("crowd");
    }

    @Override
    protected void fetchServices(Client client) {
        this._cservice = client.requireService(ChatService.class);
    }

    protected class BroadcastHandler
    extends CommandHandler {
        protected BroadcastHandler() {
        }

        public String handleCommand(SpeakService speakSvc, String command, String args, String[] history) {
            if (StringUtil.isBlank((String)args)) {
                return this.getUsage(command);
            }
            String err = ChatDirector.this.checkLength(args = ChatDirector.this.mogrifyChat(args));
            if (err != null) {
                return err;
            }
            ChatDirector.this.requestBroadcast(args);
            history[0] = command + " ";
            return "success";
        }

        public boolean checkAccess(BodyObject user) {
            return user.checkAccess(ChatCodes.BROADCAST_ACCESS) == null;
        }
    }

    protected class TellHandler
    extends CommandHandler {
        protected TellHandler() {
        }

        public String handleCommand(SpeakService speakSvc, final String command, String args, String[] history) {
            String histEntry;
            if (StringUtil.isBlank((String)args)) {
                return this.getUsage(command);
            }
            final boolean useQuotes = args.startsWith("\"");
            String[] bits = this.parseTell(args);
            String handle = bits[0];
            String message = bits[1];
            if (StringUtil.isBlank((String)message)) {
                return this.getUsage(command);
            }
            BodyObject self = (BodyObject)ChatDirector.this._ctx.getClient().getClientObject();
            if (handle.equalsIgnoreCase(self.getVisibleName().toString())) {
                return "m.talk_self";
            }
            Name target = this.normalizeAsName(handle);
            String err = ChatDirector.this.checkLength(message = ChatDirector.this.mogrifyChat(message));
            if (err != null) {
                return err;
            }
            Iterator<String> iter = _history.iterator();
            while (iter.hasNext()) {
                String harg;
                String hist = iter.next();
                if (!hist.startsWith("/" + command) || StringUtil.isBlank((String)this.parseTell(harg = hist.substring(command.length() + 1).trim())[1])) continue;
                iter.remove();
            }
            history[0] = histEntry = command + " " + (useQuotes ? "\"" + target + "\"" : target.toString()) + " " + message;
            ChatDirector.this.requestTell(target, this.escapeMessage(message), new ResultListener<Name>(){

                public void requestCompleted(Name target) {
                    String newEntry = "/" + command + " " + (useQuotes ? "\"" + target + "\"" : String.valueOf(target)) + " ";
                    _history.remove(newEntry);
                    int dex = _history.lastIndexOf("/" + histEntry);
                    if (dex >= 0) {
                        _history.set(dex, newEntry);
                    } else {
                        _history.add(newEntry);
                    }
                }

                public void requestFailed(Exception cause) {
                }
            });
            return "success";
        }

        protected String[] parseTell(String args) {
            String handle;
            String message;
            if (args.startsWith("\"")) {
                int nextQuote = args.indexOf(34, 1);
                if (nextQuote == -1 || nextQuote == 1) {
                    message = null;
                    handle = null;
                } else {
                    handle = args.substring(1, nextQuote).trim();
                    message = args.substring(nextQuote + 1).trim();
                }
            } else {
                StringTokenizer st = new StringTokenizer(args);
                handle = st.nextToken();
                message = args.substring(handle.length()).trim();
            }
            return new String[]{handle, message};
        }

        protected Name normalizeAsName(String handle) {
            return new Name(handle);
        }

        protected String escapeMessage(String msg) {
            return msg;
        }
    }

    protected class ThinkHandler
    extends CommandHandler {
        protected ThinkHandler() {
        }

        public String handleCommand(SpeakService speakSvc, String command, String args, String[] history) {
            if (StringUtil.isBlank((String)args)) {
                return this.getUsage(command);
            }
            history[0] = command + " ";
            return ChatDirector.this.deliverChat(speakSvc, args, (byte)1);
        }
    }

    protected class EmoteHandler
    extends CommandHandler {
        protected EmoteHandler() {
        }

        public String handleCommand(SpeakService speakSvc, String command, String args, String[] history) {
            if (StringUtil.isBlank((String)args)) {
                return this.getUsage(command);
            }
            history[0] = command + " ";
            return ChatDirector.this.deliverChat(speakSvc, args, (byte)2);
        }
    }

    protected class SpeakHandler
    extends CommandHandler {
        protected SpeakHandler() {
        }

        public String handleCommand(SpeakService speakSvc, String command, String args, String[] history) {
            if (StringUtil.isBlank((String)args)) {
                return this.getUsage(command);
            }
            history[0] = command + " ";
            return ChatDirector.this.requestChat(null, args, true);
        }
    }

    protected class ClearHandler
    extends CommandHandler {
        protected ClearHandler() {
        }

        public String handleCommand(SpeakService speakSvc, String command, String args, String[] history) {
            ChatDirector.this.clearDisplays();
            return "success";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HelpHandler
    extends CommandHandler {
        protected HelpHandler() {
        }

        @Override
        public String getUsage(String command) {
            Map<String, CommandHandler> possibleCommands = ChatDirector.this.getCommandHandlers("");
            possibleCommands.remove(command);
            return this.getUsage(command, possibleCommands);
        }

        @Override
        public String handleCommand(SpeakService speakSvc, String command, String args, String[] history) {
            String hcmd = "";
            if (!StringUtil.isBlank((String)args)) {
                hcmd = args;
                int sidx = args.indexOf(" ");
                if (sidx != -1) {
                    hcmd = args.substring(0, sidx);
                }
            }
            if (hcmd.startsWith("/")) {
                hcmd = hcmd.substring(1);
            }
            Map<String, CommandHandler> possibleCommands = ChatDirector.this.getCommandHandlers(hcmd);
            if (_handlers.get(hcmd) == this || possibleCommands.isEmpty()) {
                return this.getUsage(command);
            }
            if (possibleCommands.size() > 1) {
                return this.getUsage(command, possibleCommands);
            }
            Map.Entry<String, CommandHandler> entry = possibleCommands.entrySet().iterator().next();
            ChatDirector.this.displayFeedback(null, entry.getValue().getUsage(entry.getKey()));
            return "success";
        }

        protected String getUsage(String command, Map<String, CommandHandler> possibleCommands) {
            Object[] commands = possibleCommands.keySet().toArray();
            Arrays.sort(commands);
            String commandList = "";
            for (Object element : commands) {
                commandList = commandList + " /" + element;
            }
            return MessageBundle.tcompose("m.usage_help", (Object)commandList, (Object)command);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DisplayMessageOp
    implements ObserverList.ObserverOp<ChatDisplay> {
        protected ChatMessage _message;
        protected boolean _displayed;

        protected DisplayMessageOp() {
        }

        public void setMessage(ChatMessage message) {
            this._message = message;
            this._displayed = false;
        }

        public boolean apply(ChatDisplay observer) {
            if (observer.displayMessage(this._message, this._displayed)) {
                this._displayed = true;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilterMessageOp
    implements ObserverList.ObserverOp<ChatFilter> {
        protected Name _otherUser;
        protected String _msg;
        protected boolean _out;

        protected FilterMessageOp() {
        }

        public void setMessage(String msg, Name otherUser, boolean outgoing) {
            this._msg = msg;
            this._otherUser = otherUser;
            this._out = outgoing;
        }

        public boolean apply(ChatFilter observer) {
            if (this._msg != null) {
                this._msg = observer.filter(this._msg, this._otherUser, this._out);
            }
            return true;
        }

        public String getMessage() {
            return this._msg;
        }
    }

    public static abstract class CommandHandler {
        protected String _usageKey;
        protected String[] _aliases;

        public String getUsage(String command) {
            return MessageBundle.tcompose(this._usageKey, (Object)(_showAliasesInUsage ? Joiner.on((char)'|').join((Object[])this._aliases) : command));
        }

        public abstract String handleCommand(SpeakService var1, String var2, String var3, String[] var4);

        public boolean checkAccess(BodyObject user) {
            return true;
        }
    }

    public static interface ChatterValidator {
        public boolean isChatterValid(Name var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ChatterObserver {
        public void chattersUpdated(Iterator<Name> var1);
    }
}

