/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.client;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.samskivert.swing.ObjectEditorTable;
import com.samskivert.swing.event.CommandEvent;
import com.samskivert.util.ComparableArrayList;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.SetListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSetEditor<E extends DSet.Entry>
extends JPanel
implements ActionListener {
    protected String _setName;
    protected Predicate<E> _entryFilter;
    protected Accessor<E> _accessor;
    protected ObjectEditorTable _table;
    protected ComparableArrayList<Comparable<Object>> _keys;
    protected Class<?> _entryClass;
    protected String[] _editableFields;
    protected ObjectEditorTable.FieldInterpreter _interp;
    protected String[] _displayFields;
    protected static final int MIN_HEIGHT = 200;

    public DSetEditor(DObject setter, String setName, Class<?> entryClass) {
        this(setter, setName, entryClass, null);
    }

    public DSetEditor(DObject setter, String setName, Class<?> entryClass, String[] editableFields) {
        this(setter, setName, entryClass, editableFields, null);
    }

    public DSetEditor(DObject setter, String setName, Class<?> entryClass, String[] editableFields, ObjectEditorTable.FieldInterpreter interp) {
        this(setter, setName, entryClass, editableFields, interp, null, null);
    }

    public DSetEditor(DObject setter, String setName, Class<?> entryClass, String[] editableFields, ObjectEditorTable.FieldInterpreter interp, String[] displayFields, Predicate<E> entryFilter) {
        super(new BorderLayout());
        this._setName = setName;
        this._entryFilter = entryFilter;
        this._entryClass = entryClass;
        this._editableFields = editableFields;
        this._interp = interp;
        this._displayFields = displayFields;
        this.setAccessor(new DObjectAccessor(setter, setName));
    }

    public void setAccessor(Accessor<E> accessor) {
        this.removeAll();
        this._accessor = accessor;
        this._table = new ObjectEditorTable(this._entryClass, this._editableFields, this._accessor.getInterp(this._interp), this._displayFields);
        this.add((Component)new JScrollPane((Component)this._table), "Center");
    }

    public JTable getTable() {
        return this._table;
    }

    public DSet.Entry getSelectedEntry() {
        return (DSet.Entry)this._table.getSelectedObject();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = Math.min(d.height, 200);
        return d;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._accessor.added();
        this._table.addActionListener((ActionListener)this);
    }

    @Override
    public void removeNotify() {
        this._accessor.removed();
        this._table.removeActionListener((ActionListener)this);
        super.removeNotify();
    }

    protected void addEntry(E entry) {
        if (this._entryFilter == null || this._entryFilter.apply(entry)) {
            int index = this._keys.insertSorted(DSetEditor.getKey(entry));
            this._table.insertDatum(entry, index);
        }
    }

    protected void removeKey(Comparable<?> key) {
        int index = this._keys.indexOf(key);
        if (index != -1) {
            this._keys.remove(index);
            this._table.removeDatum(index);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CommandEvent ce = (CommandEvent)event;
        this._accessor.updateEntry(this._setName, (DSet.Entry)ce.getArgument());
    }

    public void setData(ComparableArrayList<Comparable<Object>> keys, Collection<?> data) {
        this._keys = keys;
        this._table.setData(data);
    }

    public Predicate<E> getFilter() {
        return this._entryFilter;
    }

    public String getSetName() {
        return this._setName;
    }

    protected static Comparable<Object> getKey(DSet.Entry entry) {
        return entry.getKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DObjectAccessor<F extends E>
    implements AttributeChangeListener,
    SetListener<F>,
    Accessor<F> {
        protected DObject _obj;
        protected DSet<F> _set;
        protected String _setName;

        public DObjectAccessor(DObject obj, String setName) {
            this._obj = obj;
            this._setName = setName;
        }

        @Override
        public ObjectEditorTable.FieldInterpreter getInterp(ObjectEditorTable.FieldInterpreter interp) {
            return interp;
        }

        @Override
        public void added() {
            this._obj.addListener(this);
            this.refreshSet();
            this.refreshData();
        }

        @Override
        public void removed() {
            this._obj.removeListener(this);
        }

        public void refreshSet() {
            this._set = this._obj.getSet(this._setName);
        }

        @Override
        public void updateEntry(String setName, DSet.Entry entry) {
            this._obj.updateSet(setName, entry);
        }

        @Override
        public void entryAdded(EntryAddedEvent<F> event) {
            if (event.getName().equals(this._setName)) {
                DSetEditor.this.addEntry(event.getEntry());
            }
        }

        @Override
        public void entryRemoved(EntryRemovedEvent<F> event) {
            if (event.getName().equals(this._setName)) {
                DSetEditor.this.removeKey(event.getKey());
            }
        }

        protected void refreshData() {
            UnmodifiableIterator iter;
            TreeMap data = Maps.newTreeMap();
            UnmodifiableIterator unmodifiableIterator = iter = DSetEditor.this._entryFilter == null ? this.iterator() : Iterators.filter(this.iterator(), DSetEditor.this._entryFilter);
            while (iter.hasNext()) {
                DSet.Entry entry = (DSet.Entry)iter.next();
                data.put(entry.getKey(), entry);
            }
            ComparableArrayList keys = new ComparableArrayList();
            ArrayList values = Lists.newArrayList();
            for (Map.Entry entry : data.entrySet()) {
                Comparable key = (Comparable)entry.getKey();
                keys.add((Object)key);
                values.add(entry.getValue());
            }
            DSetEditor.this.setData((ComparableArrayList<Comparable<Object>>)keys, values);
        }

        @Override
        public void entryUpdated(EntryUpdatedEvent<F> event) {
            if (event.getName().equals(this._setName)) {
                F entry = event.getEntry();
                int index = DSetEditor.this._keys.indexOf(entry.getKey());
                if (index != -1) {
                    if (DSetEditor.this._entryFilter == null || DSetEditor.this._entryFilter.apply(entry)) {
                        DSetEditor.this._table.updateDatum(entry, index);
                    } else {
                        DSetEditor.this.removeKey(entry.getKey());
                    }
                } else {
                    DSetEditor.this.addEntry(entry);
                }
            }
        }

        @Override
        public void attributeChanged(AttributeChangedEvent event) {
            if (event.getName().equals(this._setName)) {
                this.refreshSet();
                this.refreshData();
            }
        }

        public Iterator<F> iterator() {
            return this._set.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Accessor<F extends DSet.Entry> {
        public void added();

        public void removed();

        public void updateEntry(String var1, DSet.Entry var2);

        public ObjectEditorTable.FieldInterpreter getInterp(ObjectEditorTable.FieldInterpreter var1);
    }
}

