/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.client;

import com.samskivert.swing.VGroupLayout;
import com.samskivert.util.QuickSort;
import com.threerings.admin.Log;
import com.threerings.admin.client.AdminService;
import com.threerings.admin.client.ObjectEditorPanel;
import com.threerings.presents.util.PresentsContext;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ConfigEditorPanel
extends JPanel
implements AdminService.ConfigInfoListener {
    protected PresentsContext _ctx;
    protected JTabbedPane _oeditors;
    protected String _defaultPane;

    public ConfigEditorPanel(PresentsContext ctx) {
        this(ctx, null);
    }

    public ConfigEditorPanel(PresentsContext ctx, String defaultPane) {
        this._ctx = ctx;
        this._defaultPane = defaultPane;
        this.setLayout((LayoutManager)new VGroupLayout(VGroupLayout.STRETCH, VGroupLayout.STRETCH, 5, VGroupLayout.CENTER));
        this._oeditors = new JTabbedPane(2);
        this.add(this._oeditors);
        this._oeditors.setTabLayoutPolicy(1);
        this.add((Component)new JLabel("Fields outline in red have been modified but not yet committed."), VGroupLayout.FIXED);
        this.add((Component)new JLabel("Press return in a modified field to commit the change."), VGroupLayout.FIXED);
    }

    public void addNotify() {
        super.addNotify();
        AdminService service = this._ctx.getClient().requireService(AdminService.class);
        service.getConfigInfo(this);
    }

    public void removeNotify() {
        super.removeNotify();
        int ccount = this._oeditors.getComponentCount();
        for (int ii = 0; ii < ccount; ++ii) {
            Component comp = this._oeditors.getComponent(ii);
            if (!(comp instanceof JScrollPane)) continue;
            JScrollPane scrolly = (JScrollPane)comp;
            ObjectEditorPanel opanel = (ObjectEditorPanel)((Object)scrolly.getViewport().getView());
            opanel.cleanup();
        }
        this._oeditors.removeAll();
    }

    public void gotConfigInfo(final String[] keys, int[] oids) {
        if (!this.isDisplayable()) {
            return;
        }
        Object[] indexes = new Integer[keys.length];
        for (int ii = 0; ii < indexes.length; ++ii) {
            indexes[ii] = ii;
        }
        QuickSort.sort((Object[])indexes, (Comparator)new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return keys[i1].compareTo(keys[i2]);
            }
        });
        for (Object ii : indexes) {
            ObjectEditorPanel panel = new ObjectEditorPanel(this._ctx, keys[(Integer)ii], oids[(Integer)ii]);
            JScrollPane scrolly = new JScrollPane((Component)((Object)panel));
            this._oeditors.addTab(keys[(Integer)ii], scrolly);
            if (!keys[(Integer)ii].equals(this._defaultPane)) continue;
            this._oeditors.setSelectedComponent(scrolly);
        }
    }

    public void requestFailed(String reason) {
        Log.log.warning((Object)"Failed to get config info", new Object[]{"reason", reason});
    }
}

