//
// $Id: InvocationRequestEvent.java 6776 2012-02-03 21:25:13Z mdb $
//
// Narya library - tools for developing networked games
// Copyright (C) 2002-2012 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/narya/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.presents.dobj;

import com.samskivert.util.StringUtil;

/**
 * Used to dispatch an invocation request from the client to the server.
 *
 * @see DObjectManager#postEvent
 */
public class InvocationRequestEvent extends DEvent
{
    /**
     * Constructs a new invocation request event on the specified target object with the supplied
     * code, method and arguments.
     *
     * @param targetOid the object id of the object on which the event is to be dispatched.
     * @param invCode the invocation provider identification code.
     * @param methodId the id of the method to be invoked.
     * @param args the arguments for the method. This array should contain only values of valid
     * distributed object types.
     */
    public InvocationRequestEvent (int targetOid, int invCode, int methodId, Object[] args)
    {
        super(targetOid);
        _invCode = invCode;
        _methodId = (byte)methodId;
        _args = args;
    }

    /**
     * Returns the invocation code associated with this request.
     */
    public int getInvCode ()
    {
        return _invCode;
    }

    /**
     * Returns the id of the method associated with this request.
     */
    public int getMethodId ()
    {
        return _methodId;
    }

    /**
     * Returns the arguments associated with this request.
     */
    public Object[] getArgs ()
    {
        return _args;
    }

    @Override
    public boolean applyToObject (DObject target)
        throws ObjectAccessException
    {
        // nothing to do here
        return true;
    }

    @Override
    protected void notifyListener (Object listener)
    {
        // nothing to do here
    }

    @Override
    protected void toString (StringBuilder buf)
    {
        buf.append("IREQ:");
        super.toString(buf);
        buf.append(", code=").append(_invCode);
        buf.append(", methodId=").append(_methodId);
        buf.append(", args=").append(StringUtil.toString(_args));
    }

    /** The code identifying which invocation provider to which this
     * request is directed. */
    protected int _invCode;

    /** The id of the method being invoked. */
    protected byte _methodId;

    /** The arguments to the method being invoked. */
    protected Object[] _args;
}
