//
// $Id$
//
// OOO GWT Utils - utilities for creating GWT applications
// Copyright (C) 2009-2010 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/ooo-gwt-utils/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.gwt.ui;

import com.google.gwt.user.client.ui.HTML;

import com.threerings.gwt.util.Value;

/**
 * Displays a dynamically changing value. Automatically handles regenerating its contents when the
 * value changes and registers and clears its listenership when it is added to and removed from the
 * DOM.
 */
public class ValueHTML<T> extends HTML
    implements Value.Listener<T>
{
    /**
     * Creates a value HTML with the supplied value and CSS styles. When this widget is added to
     * the DOM, its HTML will be generated by a call to {@link #getHTML} with the value's current
     * value. It will also add itself as a listener at that point and update its text whenever the
     * value changes.
     */
    public ValueHTML (Value<T> value, String... styles)
    {
        _value = value;
        Widgets.setStyleNames(this, styles);
    }

    // from Value.Listener<T>
    public void valueChanged (T value)
    {
        setHTML(getHTML(value));
    }

    @Override // from Widget
    public void onLoad ()
    {
        super.onLoad();
        _value.addListener(this);
        valueChanged(_value.get());
    }

    @Override // from Widget
    public void onUnload ()
    {
        super.onLoad();
        _value.removeListener(this);
    }

    /**
     * Called to generate our text when the value changes. The default implementation simply
     * converts the value to a string via {@link String#valueOf}.
     */
    protected String getHTML (T value)
    {
        return String.valueOf(value);
    }

    /** The value we're displaying. */
    protected Value<T> _value;
}
