/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.dexpatcher.util;

import com.tencent.tinker.android.dex.Annotation;
import com.tencent.tinker.android.dex.AnnotationSet;
import com.tencent.tinker.android.dex.AnnotationSetRefList;
import com.tencent.tinker.android.dex.AnnotationsDirectory;
import com.tencent.tinker.android.dex.ClassData;
import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Code;
import com.tencent.tinker.android.dex.DebugInfoItem;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dex.EncodedValue;
import com.tencent.tinker.android.dex.EncodedValueReader;
import com.tencent.tinker.android.dex.FieldId;
import com.tencent.tinker.android.dex.Leb128;
import com.tencent.tinker.android.dex.MethodId;
import com.tencent.tinker.android.dex.ProtoId;
import com.tencent.tinker.android.dex.SizeOf;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.TypeList;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.android.dex.util.ByteInput;
import com.tencent.tinker.android.dx.instruction.InstructionReader;
import com.tencent.tinker.android.dx.instruction.InstructionVisitor;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeInput;
import com.tencent.tinker.android.dx.util.Hex;
import com.tencent.tinker.android.dx.util.IndexMap;
import com.tencent.tinker.build.dexpatcher.util.OffsetToIndexConverter;
import com.tencent.tinker.build.dexpatcher.util.SmallDexClassInfoCollector;
import com.tencent.tinker.build.util.DexClassesComparator;
import com.tencent.tinker.commons.dexpatcher.DexPatcherLogger;
import com.tencent.tinker.commons.dexpatcher.struct.SmallPatchedDexItemFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SmallDexPatchGenerator {
    private static final String TAG = "SmallDexPatchGenerator";
    private final List<DexClassesComparator.DexGroup> oldDexGroups = new ArrayList<DexClassesComparator.DexGroup>();
    private final List<DexClassesComparator.DexGroup> patchedDexGroups = new ArrayList<DexClassesComparator.DexGroup>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedStringIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedTypeIdIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedTypeListIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedProtoIdIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedFieldIdIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedMethodIdIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedAnnotationIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedAnnotationSetIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedAnnotationSetRefListIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedAnnotationsDirectoryIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedEncodedArrayIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedDebugInfoIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedCodeIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedClassDataIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Set<Integer>> patchedDexToCollectedClassDefIndicesMap = new HashMap<Dex, Set<Integer>>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedStringIdOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedTypeIdOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedProtoIdOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedFieldIdOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedMethodIdOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedClassDefOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedMapListOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedTypeListOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedAnnotationSetRefListOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedAnnotationSetOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedClassDataOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedCodeOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedStringDataOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedDebugInfoOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedAnnotationOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedEncodedArrayOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedAnnotationsDirectoryOffsetMap = new HashMap<Dex, Integer>();
    private final Map<Dex, Integer> patchedDexToSmallPatchedDexSizeMap = new HashMap<Dex, Integer>();
    private final Set<String> loaderClassPatterns = new HashSet<String>();
    private final DexPatcherLogger logger = new DexPatcherLogger();

    public void addLoaderClassPattern(String pattern) {
        this.loaderClassPatterns.add(pattern);
    }

    public void setLoaderClassPatterns(Collection<String> patterns) {
        this.loaderClassPatterns.clear();
        this.loaderClassPatterns.addAll(patterns);
    }

    public void clearLoaderClassPatterns() {
        this.loaderClassPatterns.clear();
    }

    public void setLogger(DexPatcherLogger.IDexPatcherLogger logger) {
        this.logger.setLoggerImpl(logger);
    }

    public SmallDexPatchGenerator appendDexGroup(DexClassesComparator.DexGroup oldDexGroup, DexClassesComparator.DexGroup patchedDexGroup) {
        if (oldDexGroup == null) {
            throw new IllegalArgumentException("oldDexGroup is null.");
        }
        if (patchedDexGroup == null) {
            throw new IllegalArgumentException("patchedDexGroup is null.");
        }
        this.oldDexGroups.add(oldDexGroup);
        this.patchedDexGroups.add(patchedDexGroup);
        if (oldDexGroup.dexes.length != patchedDexGroup.dexes.length) {
            throw new IllegalArgumentException("dex count in oldDexGroup is not matched to dex count in patchedDexGroup.");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAndSaveTo(File out) throws IOException {
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(out));
            this.executeAndSaveTo(os);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void executeAndSaveTo(OutputStream os) throws IOException {
        int dexGroupCount = this.oldDexGroups.size();
        for (int i = 0; i < dexGroupCount; ++i) {
            DexClassesComparator.DexGroup oldDexGroup = this.oldDexGroups.get(i);
            DexClassesComparator.DexGroup patchedDexGroup = this.patchedDexGroups.get(i);
            this.collectItemIndicesFromDexGroup(oldDexGroup, patchedDexGroup);
            this.calculateSmallPatchedSectionOffsets(oldDexGroup, patchedDexGroup);
        }
        this.saveToStream(os);
    }

    private void calculateSmallPatchedSectionOffsets(DexClassesComparator.DexGroup oldDexGroup, DexClassesComparator.DexGroup patchedDexGroup) {
        if (oldDexGroup.dexes.length != patchedDexGroup.dexes.length) {
            throw new IllegalStateException("dex group contains different amount of dexes.");
        }
        int dexCount = oldDexGroup.dexes.length;
        for (int dexId = 0; dexId < dexCount; ++dexId) {
            int collectedClassDefsIndicesCount;
            int smallPatchedClassDefsSize;
            int collectedMethodIdsIndicesCount;
            int smallPatchedMethodIdsSize;
            int collectedFieldIdsIndicesCount;
            int smallPatchedFieldIdsSize;
            int collectedProtoIdsIndicesCount;
            int smallPatchedProtoIdsSize;
            int collectedTypeIndicesCount;
            int smallPatchedTypeIdsSize;
            Dex oldDex = oldDexGroup.dexes[dexId];
            Dex patchedDex = patchedDexGroup.dexes[dexId];
            String currOldDexSignStr = Hex.toHexString((byte[])oldDex.computeSignature(false));
            IndexMap fullToSmallPatchIndexMap = new IndexMap();
            int smallPatchedSectionCount = 2;
            int smallPatchedHeaderSize = 112;
            int collectedStringIndicesCount = this.getCollectedIndicesCountSafely(this.patchedDexToCollectedStringIndicesMap, patchedDex);
            int smallPatchedStringIdsSize = collectedStringIndicesCount * 4;
            if (smallPatchedHeaderSize > 0) {
                ++smallPatchedSectionCount;
            }
            if ((smallPatchedTypeIdsSize = (collectedTypeIndicesCount = this.getCollectedIndicesCountSafely(this.patchedDexToCollectedTypeIdIndicesMap, patchedDex)) * 4) > 0) {
                ++smallPatchedSectionCount;
            }
            if ((smallPatchedProtoIdsSize = (collectedProtoIdsIndicesCount = this.getCollectedIndicesCountSafely(this.patchedDexToCollectedProtoIdIndicesMap, patchedDex)) * 12) > 0) {
                ++smallPatchedSectionCount;
            }
            if ((smallPatchedFieldIdsSize = (collectedFieldIdsIndicesCount = this.getCollectedIndicesCountSafely(this.patchedDexToCollectedFieldIdIndicesMap, patchedDex)) * 8) > 0) {
                ++smallPatchedSectionCount;
            }
            if ((smallPatchedMethodIdsSize = (collectedMethodIdsIndicesCount = this.getCollectedIndicesCountSafely(this.patchedDexToCollectedMethodIdIndicesMap, patchedDex)) * 8) > 0) {
                ++smallPatchedSectionCount;
            }
            if ((smallPatchedClassDefsSize = (collectedClassDefsIndicesCount = this.getCollectedIndicesCountSafely(this.patchedDexToCollectedClassDefIndicesMap, patchedDex)) * 32) > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedIdSectionSize = smallPatchedStringIdsSize + smallPatchedTypeIdsSize + smallPatchedProtoIdsSize + smallPatchedFieldIdsSize + smallPatchedMethodIdsSize + smallPatchedClassDefsSize;
            int smallPatchedHeaderOffset = 0;
            int smallPatchedStringIdsOffset = smallPatchedHeaderOffset + smallPatchedHeaderSize;
            if (oldDex.getTableOfContents().stringIds.isElementFourByteAligned) {
                smallPatchedStringIdsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedStringIdsOffset);
            }
            this.patchedDexToSmallPatchedStringIdOffsetMap.put(patchedDex, smallPatchedStringIdsOffset);
            int smallPatchedStringDatasOffset = smallPatchedHeaderSize + smallPatchedIdSectionSize;
            if (oldDex.getTableOfContents().stringDatas.isElementFourByteAligned) {
                smallPatchedStringDatasOffset = SizeOf.roundToTimesOfFour((int)smallPatchedStringDatasOffset);
            }
            this.patchedDexToSmallPatchedStringDataOffsetMap.put(patchedDex, smallPatchedStringDatasOffset);
            int smallPatchedStringDataItemsSize = new SmallPatchSimulator(patchedDex, patchedDex.getTableOfContents().stringDatas, fullToSmallPatchIndexMap, this.patchedDexToCollectedStringIndicesMap.get(patchedDex)).simulate(smallPatchedStringDatasOffset);
            if (smallPatchedStringDataItemsSize > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedTypeIdsOffset = smallPatchedStringIdsOffset + smallPatchedStringIdsSize;
            if (oldDex.getTableOfContents().typeIds.isElementFourByteAligned) {
                smallPatchedTypeIdsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedTypeIdsOffset);
            }
            this.patchedDexToSmallPatchedTypeIdOffsetMap.put(patchedDex, smallPatchedTypeIdsOffset);
            int smallPatchedTypeListsOffset = smallPatchedHeaderSize + smallPatchedIdSectionSize + smallPatchedStringDataItemsSize;
            if (oldDex.getTableOfContents().typeLists.isElementFourByteAligned) {
                smallPatchedTypeListsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedTypeListsOffset);
            }
            this.patchedDexToSmallPatchedTypeListOffsetMap.put(patchedDex, smallPatchedTypeListsOffset);
            int smallPatchedTypeListsSize = new SmallPatchSimulator(patchedDex, patchedDex.getTableOfContents().typeLists, fullToSmallPatchIndexMap, this.patchedDexToCollectedTypeListIndicesMap.get(patchedDex)).simulate(smallPatchedTypeListsOffset);
            if (smallPatchedTypeListsSize > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedProtoIdsOffset = smallPatchedTypeIdsOffset + smallPatchedTypeIdsSize;
            if (oldDex.getTableOfContents().protoIds.isElementFourByteAligned) {
                smallPatchedProtoIdsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedProtoIdsOffset);
            }
            this.patchedDexToSmallPatchedProtoIdOffsetMap.put(patchedDex, smallPatchedProtoIdsOffset);
            int smallPatchedFieldIdsOffset = smallPatchedProtoIdsOffset + smallPatchedProtoIdsSize;
            if (oldDex.getTableOfContents().fieldIds.isElementFourByteAligned) {
                smallPatchedFieldIdsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedFieldIdsOffset);
            }
            this.patchedDexToSmallPatchedFieldIdOffsetMap.put(patchedDex, smallPatchedFieldIdsOffset);
            int smallPatchedMethodIdsOffset = smallPatchedFieldIdsOffset + smallPatchedFieldIdsSize;
            if (oldDex.getTableOfContents().methodIds.isElementFourByteAligned) {
                smallPatchedMethodIdsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedMethodIdsOffset);
            }
            this.patchedDexToSmallPatchedMethodIdOffsetMap.put(patchedDex, smallPatchedMethodIdsOffset);
            int smallPatchedAnnotationsOffset = smallPatchedTypeListsOffset + smallPatchedTypeListsSize;
            if (oldDex.getTableOfContents().annotations.isElementFourByteAligned) {
                smallPatchedAnnotationsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedAnnotationsOffset);
            }
            this.patchedDexToSmallPatchedAnnotationOffsetMap.put(patchedDex, smallPatchedAnnotationsOffset);
            int smallPatchedAnnotationsSize = new SmallPatchSimulator(patchedDex, patchedDex.getTableOfContents().annotations, fullToSmallPatchIndexMap, this.patchedDexToCollectedAnnotationIndicesMap.get(patchedDex)).simulate(smallPatchedAnnotationsOffset);
            if (smallPatchedAnnotationsSize > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedAnnotationSetsOffset = smallPatchedAnnotationsOffset + smallPatchedAnnotationsSize;
            if (oldDex.getTableOfContents().annotationSets.isElementFourByteAligned) {
                smallPatchedAnnotationSetsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedAnnotationSetsOffset);
            }
            this.patchedDexToSmallPatchedAnnotationSetOffsetMap.put(patchedDex, smallPatchedAnnotationSetsOffset);
            int smallPatchedAnnotationSetsSize = new SmallPatchSimulator(patchedDex, patchedDex.getTableOfContents().annotationSets, fullToSmallPatchIndexMap, this.patchedDexToCollectedAnnotationSetIndicesMap.get(patchedDex)).simulate(smallPatchedAnnotationSetsOffset);
            if (smallPatchedAnnotationSetsSize > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedAnnotationSetRefListsOffset = smallPatchedAnnotationSetsOffset + smallPatchedAnnotationSetsSize;
            if (oldDex.getTableOfContents().annotationSetRefLists.isElementFourByteAligned) {
                smallPatchedAnnotationSetRefListsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedAnnotationSetRefListsOffset);
            }
            this.patchedDexToSmallPatchedAnnotationSetRefListOffsetMap.put(patchedDex, smallPatchedAnnotationSetRefListsOffset);
            int smallPatchedAnnotationSetRefListsSize = new SmallPatchSimulator(patchedDex, patchedDex.getTableOfContents().annotationSetRefLists, fullToSmallPatchIndexMap, this.patchedDexToCollectedAnnotationSetRefListIndicesMap.get(patchedDex)).simulate(smallPatchedAnnotationSetRefListsOffset);
            if (smallPatchedAnnotationSetRefListsSize > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedAnnotationsDirectoriesOffset = smallPatchedAnnotationSetRefListsOffset + smallPatchedAnnotationSetRefListsSize;
            if (oldDex.getTableOfContents().annotationsDirectories.isElementFourByteAligned) {
                smallPatchedAnnotationsDirectoriesOffset = SizeOf.roundToTimesOfFour((int)smallPatchedAnnotationsDirectoriesOffset);
            }
            this.patchedDexToSmallPatchedAnnotationsDirectoryOffsetMap.put(patchedDex, smallPatchedAnnotationsDirectoriesOffset);
            int smallPatchedAnnotationsDirectoriesSize = new SmallPatchSimulator(patchedDex, patchedDex.getTableOfContents().annotationsDirectories, fullToSmallPatchIndexMap, this.patchedDexToCollectedAnnotationsDirectoryIndicesMap.get(patchedDex)).simulate(smallPatchedAnnotationsDirectoriesOffset);
            if (smallPatchedAnnotationsDirectoriesSize > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedDebugInfoItemsOffset = smallPatchedAnnotationsDirectoriesOffset + smallPatchedAnnotationsDirectoriesSize;
            if (oldDex.getTableOfContents().debugInfos.isElementFourByteAligned) {
                smallPatchedDebugInfoItemsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedDebugInfoItemsOffset);
            }
            this.patchedDexToSmallPatchedDebugInfoOffsetMap.put(patchedDex, smallPatchedDebugInfoItemsOffset);
            int smallPatchedDebugInfoItemsSize = new SmallPatchSimulator(patchedDex, patchedDex.getTableOfContents().debugInfos, fullToSmallPatchIndexMap, this.patchedDexToCollectedDebugInfoIndicesMap.get(patchedDex)).simulate(smallPatchedDebugInfoItemsOffset);
            if (smallPatchedDebugInfoItemsSize > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedCodesOffset = smallPatchedDebugInfoItemsOffset + smallPatchedDebugInfoItemsSize;
            if (oldDex.getTableOfContents().codes.isElementFourByteAligned) {
                smallPatchedCodesOffset = SizeOf.roundToTimesOfFour((int)smallPatchedCodesOffset);
            }
            this.patchedDexToSmallPatchedCodeOffsetMap.put(patchedDex, smallPatchedCodesOffset);
            int smallPatchedCodesSize = new SmallPatchSimulator(patchedDex, patchedDex.getTableOfContents().codes, fullToSmallPatchIndexMap, this.patchedDexToCollectedCodeIndicesMap.get(patchedDex)).simulate(smallPatchedCodesOffset);
            if (smallPatchedCodesSize > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedClassDatasOffset = smallPatchedCodesOffset + smallPatchedCodesSize;
            if (oldDex.getTableOfContents().classDatas.isElementFourByteAligned) {
                smallPatchedClassDatasOffset = SizeOf.roundToTimesOfFour((int)smallPatchedClassDatasOffset);
            }
            this.patchedDexToSmallPatchedClassDataOffsetMap.put(patchedDex, smallPatchedClassDatasOffset);
            int smallPatchedClassDatasSize = new SmallPatchSimulator(patchedDex, patchedDex.getTableOfContents().classDatas, fullToSmallPatchIndexMap, this.patchedDexToCollectedClassDataIndicesMap.get(patchedDex)).simulate(smallPatchedClassDatasOffset);
            if (smallPatchedClassDatasSize > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedEncodedArraysOffset = smallPatchedClassDatasOffset + smallPatchedClassDatasSize;
            if (oldDex.getTableOfContents().encodedArrays.isElementFourByteAligned) {
                smallPatchedEncodedArraysOffset = SizeOf.roundToTimesOfFour((int)smallPatchedEncodedArraysOffset);
            }
            this.patchedDexToSmallPatchedEncodedArrayOffsetMap.put(patchedDex, smallPatchedEncodedArraysOffset);
            int smallPatchedEncodedArraysSize = new SmallPatchSimulator(patchedDex, patchedDex.getTableOfContents().encodedArrays, fullToSmallPatchIndexMap, this.patchedDexToCollectedEncodedArrayIndicesMap.get(patchedDex)).simulate(smallPatchedEncodedArraysOffset);
            if (smallPatchedEncodedArraysSize > 0) {
                ++smallPatchedSectionCount;
            }
            int smallPatchedClassDefsOffset = smallPatchedMethodIdsOffset + smallPatchedMethodIdsSize;
            if (oldDex.getTableOfContents().classDefs.isElementFourByteAligned) {
                smallPatchedClassDefsOffset = SizeOf.roundToTimesOfFour((int)smallPatchedClassDefsOffset);
            }
            this.patchedDexToSmallPatchedClassDefOffsetMap.put(patchedDex, smallPatchedClassDefsOffset);
            int smallPatchedMapListOffset = smallPatchedEncodedArraysOffset + smallPatchedEncodedArraysSize;
            if (oldDex.getTableOfContents().mapList.isElementFourByteAligned) {
                smallPatchedMapListOffset = SizeOf.roundToTimesOfFour((int)smallPatchedMapListOffset);
            }
            this.patchedDexToSmallPatchedMapListOffsetMap.put(patchedDex, smallPatchedMapListOffset);
            int smallPatchedMapListSize = 4 + 12 * smallPatchedSectionCount;
            int smallPatchedDexSize = smallPatchedMapListOffset + smallPatchedMapListSize;
            this.patchedDexToSmallPatchedDexSizeMap.put(patchedDex, smallPatchedDexSize);
        }
    }

    private int getCollectedIndicesCountSafely(Map<Dex, Set<Integer>> collectedIndicesMap, Dex patchedDex) {
        Set<Integer> indices = collectedIndicesMap.get(patchedDex);
        if (indices == null) {
            return 0;
        }
        return indices.size();
    }

    private void saveToStream(OutputStream os) throws IOException {
        DexDataBuffer buffer = new DexDataBuffer();
        buffer.write(SmallPatchedDexItemFile.MAGIC);
        buffer.writeShort((short)1);
        buffer.writeInt(buffer.position() + 4);
        ArrayList<Dex> oldDexes = new ArrayList<Dex>();
        int oldDexGroupCount = this.oldDexGroups.size();
        for (int i = 0; i < oldDexGroupCount; ++i) {
            DexClassesComparator.DexGroup oldDexGroup = this.oldDexGroups.get(i);
            for (Dex oldDex : oldDexGroup.dexes) {
                oldDexes.add(oldDex);
            }
        }
        ArrayList<Dex> patchedDexes = new ArrayList<Dex>();
        int patchedDexGroupCount = this.patchedDexGroups.size();
        for (int i = 0; i < patchedDexGroupCount; ++i) {
            DexClassesComparator.DexGroup patchedDexGroup = this.patchedDexGroups.get(i);
            for (Dex patchedDex : patchedDexGroup.dexes) {
                patchedDexes.add(patchedDex);
            }
        }
        int oldDexSignCount = oldDexes.size();
        buffer.writeUleb128(oldDexSignCount);
        HashMap<String, Integer> oldDexSignToIdxInSignList = new HashMap<String, Integer>();
        for (int i = 0; i < oldDexSignCount; ++i) {
            byte[] signBytes = ((Dex)oldDexes.get(i)).computeSignature(false);
            String signStr = Hex.toHexString((byte[])signBytes);
            buffer.write(signBytes);
            oldDexSignToIdxInSignList.put(signStr, i);
        }
        for (Dex patchedDex : patchedDexes) {
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedStringIdOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedTypeIdOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedProtoIdOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedFieldIdOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedMethodIdOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedClassDefOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedStringDataOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedTypeListOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedAnnotationOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedAnnotationSetOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedAnnotationSetRefListOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedAnnotationsDirectoryOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedDebugInfoOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedCodeOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedClassDataOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedEncodedArrayOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedMapListOffsetMap);
            this.writeSmallPatchedSectionOffset(buffer, patchedDex, this.patchedDexToSmallPatchedDexSizeMap);
        }
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedStringIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedTypeIdIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedTypeListIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedProtoIdIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedFieldIdIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedMethodIdIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedAnnotationIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedAnnotationSetIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedAnnotationSetRefListIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedAnnotationsDirectoryIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedEncodedArrayIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedDebugInfoIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedCodeIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedClassDataIndicesMap);
        this.writeDataChunk(buffer, patchedDexes, this.patchedDexToCollectedClassDefIndicesMap);
        os.write(buffer.array());
        os.flush();
    }

    private void writeSmallPatchedSectionOffset(DexDataBuffer buffer, Dex patchedDex, Map<Dex, Integer> patchedDexToSmallPatchedSectionOffsetMap) {
        Integer offset = patchedDexToSmallPatchedSectionOffsetMap.get(patchedDex);
        if (offset == null) {
            throw new IllegalStateException("section offset is missing.");
        }
        buffer.writeInt(offset.intValue());
    }

    private void writeDataChunk(DexDataBuffer buffer, List<Dex> patchedDexList, Map<Dex, Set<Integer>> patchedDexToCollectedItemIndicesMap) {
        for (Dex patchedDex : patchedDexList) {
            Set<Integer> itemIndices = patchedDexToCollectedItemIndicesMap.get(patchedDex);
            if (itemIndices == null) {
                buffer.writeUleb128(0);
                continue;
            }
            int indexCount = itemIndices.size();
            Object[] itemIndexArr = new Integer[indexCount];
            itemIndices.toArray(itemIndexArr);
            Arrays.sort(itemIndexArr);
            buffer.writeUleb128(indexCount);
            int prevIndex = 0;
            for (int j = 0; j < indexCount; ++j) {
                buffer.writeSleb128((Integer)itemIndexArr[j] - prevIndex);
                prevIndex = (Integer)itemIndexArr[j];
            }
        }
    }

    private void collectItemIndicesFromDexGroup(DexClassesComparator.DexGroup oldDexGroup, DexClassesComparator.DexGroup patchedDexGroup) {
        SmallDexClassInfoCollector smallDexClassInfoCollector = new SmallDexClassInfoCollector();
        smallDexClassInfoCollector.setLoaderClassPatterns(this.loaderClassPatterns);
        smallDexClassInfoCollector.setLogger(this.logger.getLoggerImpl());
        Set<DexClassesComparator.DexClassInfo> patchedClassInfosForItemIndexCollecting = smallDexClassInfoCollector.doCollect(oldDexGroup, patchedDexGroup);
        HashMap<Dex, OffsetToIndexConverter> dexToOffsetToIndexConverterMap = new HashMap<Dex, OffsetToIndexConverter>();
        for (DexClassesComparator.DexClassInfo classInfo : patchedClassInfosForItemIndexCollecting) {
            Dex owner = classInfo.owner;
            OffsetToIndexConverter offsetToIndexConverter = (OffsetToIndexConverter)dexToOffsetToIndexConverterMap.get(owner);
            if (offsetToIndexConverter == null) {
                offsetToIndexConverter = new OffsetToIndexConverter(owner);
                dexToOffsetToIndexConverterMap.put(owner, offsetToIndexConverter);
            }
            this.collectItemIndicesFromClassInfo(classInfo, offsetToIndexConverter);
        }
    }

    private void collectItemIndicesFromClassInfo(DexClassesComparator.DexClassInfo classInfo, OffsetToIndexConverter offsetToIndexConverter) {
        Dex owner = classInfo.owner;
        this.putValueIntoSetMap(this.patchedDexToCollectedClassDefIndicesMap, owner, classInfo.classDefIndex);
        this.collectItemIndicesFromTypeIndex(owner, classInfo.classDef.typeIndex, offsetToIndexConverter);
        this.collectItemIndicesFromTypeIndex(owner, classInfo.classDef.supertypeIndex, offsetToIndexConverter);
        this.collectItemIndicesFromTypeList(owner, classInfo.classDef.interfacesOffset, offsetToIndexConverter);
        this.collectItemIndicesFromStringIndex(owner, classInfo.classDef.sourceFileIndex, offsetToIndexConverter);
        this.collectItemIndicesFromAnnotationsDirectory(owner, classInfo.classDef.annotationsOffset, offsetToIndexConverter);
        this.collectItemIndicesFromClassData(owner, classInfo.classDef.classDataOffset, offsetToIndexConverter);
        this.collectItemIndicesFromEncodedArray(owner, classInfo.classDef.staticValuesOffset, offsetToIndexConverter);
    }

    private void collectItemIndicesFromStringIndex(Dex owner, int stringIndex, OffsetToIndexConverter offsetToIndexConverter) {
        if (stringIndex == -1) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedStringIndicesMap, owner, stringIndex);
    }

    private void collectItemIndicesFromTypeList(Dex owner, int typeListOffset, OffsetToIndexConverter offsetToIndexConverter) {
        if (typeListOffset == 0) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedTypeListIndicesMap, owner, offsetToIndexConverter.getTypeListIndexByOffset(typeListOffset));
        TypeList typeList = owner.openSection(typeListOffset).readTypeList();
        for (short typeIndex : typeList.types) {
            this.collectItemIndicesFromTypeIndex(owner, typeIndex, offsetToIndexConverter);
        }
    }

    private void collectItemIndicesFromTypeIndex(Dex owner, int typeIndex, OffsetToIndexConverter offsetToIndexConverter) {
        if (typeIndex == -1) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedTypeIdIndicesMap, owner, typeIndex);
        this.collectItemIndicesFromStringIndex(owner, (Integer)owner.typeIds().get(typeIndex), offsetToIndexConverter);
    }

    private void collectItemIndicesFromFieldIndex(Dex owner, int fieldIndex, OffsetToIndexConverter offsetToIndexConverter) {
        if (fieldIndex == -1) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedFieldIdIndicesMap, owner, fieldIndex);
        FieldId fieldId = (FieldId)owner.fieldIds().get(fieldIndex);
        this.collectItemIndicesFromStringIndex(owner, fieldId.nameIndex, offsetToIndexConverter);
        this.collectItemIndicesFromTypeIndex(owner, fieldId.declaringClassIndex, offsetToIndexConverter);
        this.collectItemIndicesFromTypeIndex(owner, fieldId.typeIndex, offsetToIndexConverter);
    }

    private void collectItemIndicesFromMethodIndex(Dex owner, int methodIndex, OffsetToIndexConverter offsetToIndexConverter) {
        if (methodIndex == -1) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedMethodIdIndicesMap, owner, methodIndex);
        MethodId methodId = (MethodId)owner.methodIds().get(methodIndex);
        this.collectItemIndicesFromStringIndex(owner, methodId.nameIndex, offsetToIndexConverter);
        this.collectItemIndicesFromTypeIndex(owner, methodId.declaringClassIndex, offsetToIndexConverter);
        this.collectItemIndicesFromProtoIndex(owner, methodId.protoIndex, offsetToIndexConverter);
    }

    private void collectItemIndicesFromProtoIndex(Dex owner, int protoIndex, OffsetToIndexConverter offsetToIndexConverter) {
        if (protoIndex == -1) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedProtoIdIndicesMap, owner, protoIndex);
        ProtoId protoId = (ProtoId)owner.protoIds().get(protoIndex);
        this.collectItemIndicesFromStringIndex(owner, protoId.shortyIndex, offsetToIndexConverter);
        this.collectItemIndicesFromTypeIndex(owner, protoId.returnTypeIndex, offsetToIndexConverter);
        this.collectItemIndicesFromTypeList(owner, protoId.parametersOffset, offsetToIndexConverter);
    }

    private void collectItemIndicesFromAnnotationsDirectory(Dex owner, int annotationsDirectoryOffset, OffsetToIndexConverter offsetToIndexConverter) {
        if (annotationsDirectoryOffset == 0) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedAnnotationsDirectoryIndicesMap, owner, offsetToIndexConverter.getAnnotationsDirectoryIndexByOffset(annotationsDirectoryOffset));
        AnnotationsDirectory annotationsDirectory = owner.openSection(annotationsDirectoryOffset).readAnnotationsDirectory();
        this.collectItemIndicesFromAnnotationSet(owner, annotationsDirectory.classAnnotationsOffset, offsetToIndexConverter);
        for (int[] fieldAnnoPair : annotationsDirectory.fieldAnnotations) {
            this.collectItemIndicesFromFieldIndex(owner, fieldAnnoPair[0], offsetToIndexConverter);
            this.collectItemIndicesFromAnnotationSet(owner, fieldAnnoPair[1], offsetToIndexConverter);
        }
        for (int[] methodAnnoPair : annotationsDirectory.methodAnnotations) {
            this.collectItemIndicesFromMethodIndex(owner, methodAnnoPair[0], offsetToIndexConverter);
            this.collectItemIndicesFromAnnotationSet(owner, methodAnnoPair[1], offsetToIndexConverter);
        }
        for (int[] paramAnnoPair : annotationsDirectory.parameterAnnotations) {
            this.collectItemIndicesFromMethodIndex(owner, paramAnnoPair[0], offsetToIndexConverter);
            this.collectItemIndicesFromAnnotationSetRefList(owner, paramAnnoPair[1], offsetToIndexConverter);
        }
    }

    private void collectItemIndicesFromAnnotationSetRefList(Dex owner, int annotationSetRefListOffset, OffsetToIndexConverter offsetToIndexConverter) {
        if (annotationSetRefListOffset == 0) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedAnnotationSetRefListIndicesMap, owner, offsetToIndexConverter.getAnnotationSetRefListIndexByOffset(annotationSetRefListOffset));
        AnnotationSetRefList annotationSetRefList = owner.openSection(annotationSetRefListOffset).readAnnotationSetRefList();
        for (int annotationSetOffset : annotationSetRefList.annotationSetRefItems) {
            this.collectItemIndicesFromAnnotationSet(owner, annotationSetOffset, offsetToIndexConverter);
        }
    }

    private void collectItemIndicesFromAnnotationSet(Dex owner, int annotationSetOffset, OffsetToIndexConverter offsetToIndexConverter) {
        if (annotationSetOffset == 0) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedAnnotationSetIndicesMap, owner, offsetToIndexConverter.getAnnotationSetIndexByOffset(annotationSetOffset));
        AnnotationSet annotationSet = owner.openSection(annotationSetOffset).readAnnotationSet();
        for (int annotationOffset : annotationSet.annotationOffsets) {
            this.collectItemIndicesFromAnnotation(owner, annotationOffset, offsetToIndexConverter);
        }
    }

    private void collectItemIndicesFromAnnotation(Dex owner, int annotationOffset, OffsetToIndexConverter offsetToIndexConverter) {
        if (annotationOffset == 0) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedAnnotationIndicesMap, owner, offsetToIndexConverter.getAnnotationIndexByOffset(annotationOffset));
        Annotation annotation = owner.openSection(annotationOffset).readAnnotation();
        EncodedValueReader annotationReader = annotation.getReader();
        this.collectItemIndicesFromAnnotationReader(owner, annotationReader, offsetToIndexConverter);
    }

    private void collectItemIndicesFromAnnotationReader(Dex owner, EncodedValueReader annotationReader, OffsetToIndexConverter offsetToIndexConverter) {
        int fieldCount = annotationReader.readAnnotation();
        this.collectItemIndicesFromTypeIndex(owner, annotationReader.getAnnotationType(), offsetToIndexConverter);
        for (int i = 0; i < fieldCount; ++i) {
            int annotationNameIndex = annotationReader.readAnnotationName();
            this.collectItemIndicesFromStringIndex(owner, annotationNameIndex, offsetToIndexConverter);
            this.collectItemIndicesFromEncodedValueReader(owner, annotationReader, offsetToIndexConverter);
        }
    }

    private void collectItemIndicesFromEncodedArrayReader(Dex owner, EncodedValueReader arrayReader, OffsetToIndexConverter offsetToIndexConverter) {
        int size = arrayReader.readArray();
        for (int i = 0; i < size; ++i) {
            this.collectItemIndicesFromEncodedValueReader(owner, arrayReader, offsetToIndexConverter);
        }
    }

    private void collectItemIndicesFromEncodedValueReader(Dex owner, EncodedValueReader encodedValueReader, OffsetToIndexConverter offsetToIndexConverter) {
        switch (encodedValueReader.peek()) {
            case 0: {
                encodedValueReader.readByte();
                break;
            }
            case 2: {
                encodedValueReader.readShort();
                break;
            }
            case 4: {
                encodedValueReader.readInt();
                break;
            }
            case 6: {
                encodedValueReader.readLong();
                break;
            }
            case 3: {
                encodedValueReader.readChar();
                break;
            }
            case 16: {
                encodedValueReader.readFloat();
                break;
            }
            case 17: {
                encodedValueReader.readDouble();
                break;
            }
            case 23: {
                this.collectItemIndicesFromStringIndex(owner, encodedValueReader.readString(), offsetToIndexConverter);
                break;
            }
            case 24: {
                this.collectItemIndicesFromTypeIndex(owner, encodedValueReader.readType(), offsetToIndexConverter);
                break;
            }
            case 25: {
                this.collectItemIndicesFromFieldIndex(owner, encodedValueReader.readField(), offsetToIndexConverter);
                break;
            }
            case 27: {
                this.collectItemIndicesFromFieldIndex(owner, encodedValueReader.readEnum(), offsetToIndexConverter);
                break;
            }
            case 26: {
                this.collectItemIndicesFromMethodIndex(owner, encodedValueReader.readMethod(), offsetToIndexConverter);
                break;
            }
            case 28: {
                this.collectItemIndicesFromEncodedArrayReader(owner, encodedValueReader, offsetToIndexConverter);
                break;
            }
            case 29: {
                this.collectItemIndicesFromAnnotationReader(owner, encodedValueReader, offsetToIndexConverter);
                break;
            }
            case 30: {
                encodedValueReader.readNull();
                break;
            }
            case 31: {
                encodedValueReader.readBoolean();
                break;
            }
            default: {
                throw new DexException("Unexpected type: " + Integer.toHexString(encodedValueReader.peek()));
            }
        }
    }

    private void collectItemIndicesFromClassData(Dex owner, int classDataOffset, OffsetToIndexConverter offsetToIndexConverter) {
        if (classDataOffset == 0) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedClassDataIndicesMap, owner, offsetToIndexConverter.getClassDataIndexByOffset(classDataOffset));
        ClassData classData = owner.openSection(classDataOffset).readClassData();
        for (ClassData.Field field : classData.instanceFields) {
            this.collectItemIndicesFromFieldIndex(owner, field.fieldIndex, offsetToIndexConverter);
        }
        for (ClassData.Field field : classData.staticFields) {
            this.collectItemIndicesFromFieldIndex(owner, field.fieldIndex, offsetToIndexConverter);
        }
        for (ClassData.Field field : classData.directMethods) {
            this.collectItemIndicesFromMethodIndex(owner, field.methodIndex, offsetToIndexConverter);
            this.collectItemIndicesFromCode(owner, field.codeOffset, offsetToIndexConverter);
        }
        for (ClassData.Field field : classData.virtualMethods) {
            this.collectItemIndicesFromMethodIndex(owner, field.methodIndex, offsetToIndexConverter);
            this.collectItemIndicesFromCode(owner, field.codeOffset, offsetToIndexConverter);
        }
    }

    private void collectItemIndicesFromCode(Dex owner, int codeOffset, OffsetToIndexConverter offsetToIndexConverter) {
        if (codeOffset == 0) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedCodeIndicesMap, owner, offsetToIndexConverter.getCodeIndexByOffset(codeOffset));
        Code code = owner.openSection(codeOffset).readCode();
        this.collectItemIndicesFromDebugInfoItem(owner, code.debugInfoOffset, offsetToIndexConverter);
        InstructionReader ir = new InstructionReader(new ShortArrayCodeInput(code.instructions));
        try {
            ir.accept((InstructionVisitor)new IndicesCollectorInsnVisitor(owner, offsetToIndexConverter));
        }
        catch (EOFException e) {
            throw new IllegalStateException(e);
        }
        for (Code.CatchHandler catchHandler : code.catchHandlers) {
            for (int typeIndex : catchHandler.typeIndexes) {
                this.collectItemIndicesFromTypeIndex(owner, typeIndex, offsetToIndexConverter);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void collectItemIndicesFromDebugInfoItem(Dex owner, int debugInfoItemOffset, OffsetToIndexConverter offsetToIndexConverter) {
        if (debugInfoItemOffset == 0) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedDebugInfoIndicesMap, owner, offsetToIndexConverter.getDebugInfoItemIndexByOffset(debugInfoItemOffset));
        DebugInfoItem debugInfoItem = owner.openSection(debugInfoItemOffset).readDebugInfoItem();
        for (int stringIndex : debugInfoItem.parameterNames) {
            this.collectItemIndicesFromStringIndex(owner, stringIndex, offsetToIndexConverter);
        }
        final ByteArrayInputStream bais = new ByteArrayInputStream(debugInfoItem.infoSTM);
        ByteInput inAdapter = new ByteInput(){

            public byte readByte() {
                return (byte)(bais.read() & 0xFF);
            }
        };
        while (true) {
            int opcode = bais.read() & 0xFF;
            switch (opcode) {
                case 0: {
                    return;
                }
                case 1: {
                    int addrDiff = Leb128.readUnsignedLeb128((ByteInput)inAdapter);
                    break;
                }
                case 2: {
                    int lineDiff = Leb128.readSignedLeb128((ByteInput)inAdapter);
                    break;
                }
                case 3: 
                case 4: {
                    int registerNum = Leb128.readUnsignedLeb128((ByteInput)inAdapter);
                    int nameIndex = Leb128.readUnsignedLeb128p1((ByteInput)inAdapter);
                    this.collectItemIndicesFromStringIndex(owner, nameIndex, offsetToIndexConverter);
                    int typeIndex = Leb128.readUnsignedLeb128p1((ByteInput)inAdapter);
                    this.collectItemIndicesFromTypeIndex(owner, typeIndex, offsetToIndexConverter);
                    if (opcode != 4) break;
                    int sigIndex = Leb128.readUnsignedLeb128p1((ByteInput)inAdapter);
                    this.collectItemIndicesFromStringIndex(owner, sigIndex, offsetToIndexConverter);
                    break;
                }
                case 5: 
                case 6: {
                    int registerNum = Leb128.readUnsignedLeb128((ByteInput)inAdapter);
                    break;
                }
                case 9: {
                    int nameIndex = Leb128.readUnsignedLeb128p1((ByteInput)inAdapter);
                    this.collectItemIndicesFromStringIndex(owner, nameIndex, offsetToIndexConverter);
                }
            }
        }
    }

    private void collectItemIndicesFromEncodedArray(Dex owner, int encodedArrayOffset, OffsetToIndexConverter offsetToIndexConverter) {
        if (encodedArrayOffset == 0) {
            return;
        }
        this.putValueIntoSetMap(this.patchedDexToCollectedEncodedArrayIndicesMap, owner, offsetToIndexConverter.getEncodedArrayIndexByOffset(encodedArrayOffset));
        EncodedValue arrayVal = owner.openSection(encodedArrayOffset).readEncodedArray();
        EncodedValueReader arrayReader = new EncodedValueReader(arrayVal, 28);
        this.collectItemIndicesFromEncodedArrayReader(owner, arrayReader, offsetToIndexConverter);
    }

    private <K, V> void putValueIntoSetMap(Map<K, Set<V>> map, K key, V value) {
        Set<V> valueSet = map.get(key);
        if (valueSet == null) {
            valueSet = new HashSet<V>();
            map.put(key, valueSet);
        }
        valueSet.add(value);
    }

    private class IndicesCollectorInsnVisitor
    extends InstructionVisitor {
        private final Dex ownerDex;
        private final OffsetToIndexConverter offsetToIndexConverter;

        IndicesCollectorInsnVisitor(Dex ownerDex, OffsetToIndexConverter offsetToIndexConverter) {
            super(null);
            this.ownerDex = ownerDex;
            this.offsetToIndexConverter = offsetToIndexConverter;
        }

        public void visitZeroRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal) {
            this.processIndexByType(index, indexType);
        }

        public void visitOneRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a) {
            this.processIndexByType(index, indexType);
        }

        public void visitTwoRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b) {
            this.processIndexByType(index, indexType);
        }

        public void visitThreeRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c) {
            this.processIndexByType(index, indexType);
        }

        public void visitFourRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d) {
            this.processIndexByType(index, indexType);
        }

        public void visitFiveRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d, int e) {
            this.processIndexByType(index, indexType);
        }

        public void visitRegisterRangeInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int registerCount) {
            this.processIndexByType(index, indexType);
        }

        private void processIndexByType(int index, int indexType) {
            switch (indexType) {
                case 3: {
                    SmallDexPatchGenerator.this.collectItemIndicesFromStringIndex(this.ownerDex, index, this.offsetToIndexConverter);
                    break;
                }
                case 2: {
                    SmallDexPatchGenerator.this.collectItemIndicesFromTypeIndex(this.ownerDex, index, this.offsetToIndexConverter);
                    break;
                }
                case 5: {
                    SmallDexPatchGenerator.this.collectItemIndicesFromFieldIndex(this.ownerDex, index, this.offsetToIndexConverter);
                    break;
                }
                case 4: {
                    SmallDexPatchGenerator.this.collectItemIndicesFromMethodIndex(this.ownerDex, index, this.offsetToIndexConverter);
                }
            }
        }
    }

    private class SmallPatchSimulator<T extends Comparable<T>> {
        private final TableOfContents.Section tocSec;
        private final Dex.Section patchedSection;
        private final int patchedItemCount;
        private final IndexMap fullToSmallPatchMap;
        private final Set<Integer> collectedIndices;

        SmallPatchSimulator(Dex patchedDex, TableOfContents.Section tocSec, IndexMap fullToSmallPatchMap, Set<Integer> collectedIndices) {
            if (tocSec.exists()) {
                this.tocSec = tocSec;
                this.patchedSection = patchedDex.openSection(tocSec);
                this.patchedItemCount = tocSec.size;
                this.fullToSmallPatchMap = fullToSmallPatchMap;
                this.collectedIndices = collectedIndices;
            } else {
                this.tocSec = null;
                this.patchedSection = null;
                this.patchedItemCount = 0;
                this.fullToSmallPatchMap = null;
                this.collectedIndices = null;
            }
        }

        private int getItemIndexOrOffset(T item, int index) {
            if (item instanceof TableOfContents.Section.Item) {
                return ((TableOfContents.Section.Item)item).off;
            }
            return index;
        }

        private T nextItem(DexDataBuffer buffer) {
            switch (this.tocSec.type) {
                case 2: {
                    return (T)Integer.valueOf(buffer.readInt());
                }
                case 3: {
                    return (T)buffer.readProtoId();
                }
                case 4: {
                    return (T)buffer.readFieldId();
                }
                case 5: {
                    return (T)buffer.readMethodId();
                }
                case 6: {
                    return (T)buffer.readClassDef();
                }
                case 8194: {
                    return (T)buffer.readStringData();
                }
                case 4097: {
                    return (T)buffer.readTypeList();
                }
                case 8196: {
                    return (T)buffer.readAnnotation();
                }
                case 4099: {
                    return (T)buffer.readAnnotationSet();
                }
                case 4098: {
                    return (T)buffer.readAnnotationSetRefList();
                }
                case 8198: {
                    return (T)buffer.readAnnotationsDirectory();
                }
                case 8195: {
                    return (T)buffer.readDebugInfoItem();
                }
                case 8193: {
                    return (T)buffer.readCode();
                }
                case 8197: {
                    return (T)buffer.readEncodedArray();
                }
                case 8192: {
                    return (T)buffer.readClassData();
                }
            }
            throw new IllegalStateException("unknown section type: " + this.tocSec.type);
        }

        private int getItemSize(T item) {
            if (item instanceof TableOfContents.Section.Item) {
                return ((TableOfContents.Section.Item)item).byteCountInDex();
            }
            if (item instanceof Integer) {
                return 4;
            }
            throw new IllegalStateException("unexpected item type: " + item.getClass().getName());
        }

        private T adjustItem(IndexMap indexMap, T item) {
            switch (this.tocSec.type) {
                case 2: {
                    return (T)Integer.valueOf(indexMap.adjustStringIndex(((Integer)item).intValue()));
                }
                case 3: {
                    return (T)indexMap.adjust((ProtoId)item);
                }
                case 4: {
                    return (T)indexMap.adjust((FieldId)item);
                }
                case 5: {
                    return (T)indexMap.adjust((MethodId)item);
                }
                case 6: {
                    return (T)indexMap.adjust((ClassDef)item);
                }
                case 8194: {
                    return item;
                }
                case 4097: {
                    return (T)indexMap.adjust((TypeList)item);
                }
                case 8196: {
                    return (T)indexMap.adjust((Annotation)item);
                }
                case 4099: {
                    return (T)indexMap.adjust((AnnotationSet)item);
                }
                case 4098: {
                    return (T)indexMap.adjust((AnnotationSetRefList)item);
                }
                case 8198: {
                    return (T)indexMap.adjust((AnnotationsDirectory)item);
                }
                case 8195: {
                    return (T)indexMap.adjust((DebugInfoItem)item);
                }
                case 8193: {
                    return (T)indexMap.adjust((Code)item);
                }
                case 8197: {
                    return (T)indexMap.adjust((EncodedValue)item);
                }
                case 8192: {
                    return (T)indexMap.adjust((ClassData)item);
                }
            }
            throw new IllegalStateException("unknown section type: " + this.tocSec.type);
        }

        private void updateIndexOrOffset(IndexMap indexMap, int oldIndex, int oldOffset, int newIndex, int newOffset) {
            switch (this.tocSec.type) {
                case 2: {
                    indexMap.mapTypeIds(oldIndex, newIndex);
                    break;
                }
                case 3: {
                    indexMap.mapProtoIds(oldIndex, newIndex);
                    break;
                }
                case 4: {
                    indexMap.mapFieldIds(oldIndex, newIndex);
                    break;
                }
                case 5: {
                    indexMap.mapMethodIds(oldIndex, newIndex);
                    break;
                }
                case 6: {
                    break;
                }
                case 8194: {
                    indexMap.mapStringIds(oldIndex, newIndex);
                    break;
                }
                case 4097: {
                    indexMap.mapTypeListOffset(oldOffset, newOffset);
                    break;
                }
                case 8196: {
                    indexMap.mapAnnotationOffset(oldOffset, newOffset);
                    break;
                }
                case 4099: {
                    indexMap.mapAnnotationSetOffset(oldOffset, newOffset);
                    break;
                }
                case 4098: {
                    indexMap.mapAnnotationSetRefListOffset(oldOffset, newOffset);
                    break;
                }
                case 8198: {
                    indexMap.mapAnnotationsDirectoryOffset(oldOffset, newOffset);
                    break;
                }
                case 8195: {
                    indexMap.mapDebugInfoItemOffset(oldOffset, newOffset);
                    break;
                }
                case 8193: {
                    indexMap.mapCodeOffset(oldOffset, newOffset);
                    break;
                }
                case 8197: {
                    indexMap.mapStaticValuesOffset(oldOffset, newOffset);
                    break;
                }
                case 8192: {
                    indexMap.mapClassDataOffset(oldOffset, newOffset);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown section type: " + this.tocSec.type);
                }
            }
        }

        public int simulate(int smallPatchBaseOffset) {
            if (this.patchedSection == null) {
                return 0;
            }
            if (this.collectedIndices == null || this.collectedIndices.isEmpty()) {
                return 0;
            }
            int smallPatchedIndex = 0;
            int smallPatchOffset = smallPatchBaseOffset;
            for (int fullPatchedItemIndex = 0; fullPatchedItemIndex < this.patchedItemCount; ++fullPatchedItemIndex) {
                T fullPatchedItemInSmallPatch = this.adjustItem(this.fullToSmallPatchMap, this.nextItem((DexDataBuffer)this.patchedSection));
                if (!this.collectedIndices.contains(fullPatchedItemIndex)) continue;
                if (this.tocSec.isElementFourByteAligned) {
                    smallPatchOffset = SizeOf.roundToTimesOfFour((int)smallPatchOffset);
                }
                int fullPatchedOffset = this.getItemIndexOrOffset(fullPatchedItemInSmallPatch, fullPatchedItemIndex);
                if (fullPatchedItemIndex != smallPatchedIndex || fullPatchedOffset != smallPatchOffset) {
                    this.updateIndexOrOffset(this.fullToSmallPatchMap, fullPatchedItemIndex, fullPatchedOffset, smallPatchedIndex, smallPatchOffset);
                }
                ++smallPatchedIndex;
                smallPatchOffset += this.getItemSize(fullPatchedItemInSmallPatch);
            }
            return smallPatchOffset - smallPatchBaseOffset;
        }
    }
}

