/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.dexpatcher.util;

import com.tencent.tinker.android.dex.ClassData;
import com.tencent.tinker.android.dex.Code;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dx.instruction.InstructionReader;
import com.tencent.tinker.android.dx.instruction.InstructionVisitor;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeInput;
import com.tencent.tinker.build.dexpatcher.util.RefToRefAffectedClassInsnVisitor;
import com.tencent.tinker.build.util.DexClassesComparator;
import com.tencent.tinker.commons.dexpatcher.DexPatcherLogger;
import java.io.EOFException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SmallDexClassInfoCollector {
    private static final String TAG = "SmallDexClassInfoCollector";
    private static final DexPatcherLogger logger = new DexPatcherLogger();
    private final Set<String> loaderClassPatterns = new HashSet<String>();

    public SmallDexClassInfoCollector setLoaderClassPatterns(Collection<String> loaderClassPatterns) {
        this.loaderClassPatterns.clear();
        this.loaderClassPatterns.addAll(loaderClassPatterns);
        return this;
    }

    public SmallDexClassInfoCollector addLoaderClassPattern(String loaderClassPattern) {
        this.loaderClassPatterns.add(loaderClassPattern);
        return this;
    }

    public SmallDexClassInfoCollector clearLoaderClassPattern() {
        this.loaderClassPatterns.clear();
        return this;
    }

    public SmallDexClassInfoCollector setLogger(DexPatcherLogger.IDexPatcherLogger loggerImpl) {
        logger.setLoggerImpl(loggerImpl);
        return this;
    }

    public Set<DexClassesComparator.DexClassInfo> doCollect(DexClassesComparator.DexGroup oldDexGroup, DexClassesComparator.DexGroup newDexGroup) {
        DexClassesComparator dexClassesCmp = new DexClassesComparator("*");
        dexClassesCmp.setCompareMode(1);
        dexClassesCmp.setIgnoredRemovedClassDescPattern(this.loaderClassPatterns);
        dexClassesCmp.startCheck(oldDexGroup, newDexGroup);
        Set<String> refAffectedClassDescs = dexClassesCmp.getChangedClassDescToInfosMap().keySet();
        Set<DexClassesComparator.DexClassInfo> classInfosInNewDexGroup = newDexGroup.getClassInfosInDexesWithDuplicateCheck();
        HashSet<DexClassesComparator.DexClassInfo> classInfosOfSmallDex = new HashSet<DexClassesComparator.DexClassInfo>();
        for (DexClassesComparator.DexClassInfo dexClassInfo : classInfosInNewDexGroup) {
            if (dexClassInfo.classDef.classDataOffset == 0) continue;
            ClassData patchedClassData = dexClassInfo.owner.readClassData(dexClassInfo.classDef);
            boolean shouldAdd = this.isClassMethodReferenceToRefAffectedClass(dexClassInfo.owner, patchedClassData.directMethods, refAffectedClassDescs);
            if (!shouldAdd) {
                shouldAdd = this.isClassMethodReferenceToRefAffectedClass(dexClassInfo.owner, patchedClassData.virtualMethods, refAffectedClassDescs);
            }
            if (!shouldAdd) continue;
            logger.i(TAG, "Add class %s to small dex.", new Object[]{dexClassInfo.classDesc});
            classInfosOfSmallDex.add(dexClassInfo);
        }
        dexClassesCmp.setCompareMode(0);
        dexClassesCmp.startCheck(oldDexGroup, newDexGroup);
        List<DexClassesComparator.DexClassInfo> addedClassInfos = dexClassesCmp.getAddedClassInfos();
        for (DexClassesComparator.DexClassInfo addClassInfo : addedClassInfos) {
            logger.i(TAG, "Add class %s to small dex.", new Object[]{addClassInfo.classDesc});
            classInfosOfSmallDex.add(addClassInfo);
        }
        Collection<DexClassesComparator.DexClassInfo[]> collection = dexClassesCmp.getChangedClassDescToInfosMap().values();
        for (DexClassesComparator.DexClassInfo[] changedOldPatchedClassInfo : collection) {
            logger.i(TAG, "Add class %s to small dex.", new Object[]{changedOldPatchedClassInfo[1].classDesc});
            classInfosOfSmallDex.add(changedOldPatchedClassInfo[1]);
        }
        return classInfosOfSmallDex;
    }

    private boolean isClassMethodReferenceToRefAffectedClass(Dex owner, ClassData.Method[] methods, Collection<String> affectedClassDescs) {
        if (affectedClassDescs.isEmpty() || methods == null || methods.length == 0) {
            return false;
        }
        for (ClassData.Method method : methods) {
            if (method.codeOffset == 0) continue;
            Code code = owner.readCode(method);
            RefToRefAffectedClassInsnVisitor refInsnVisitor = new RefToRefAffectedClassInsnVisitor(owner, method, affectedClassDescs, logger);
            InstructionReader insnReader = new InstructionReader(new ShortArrayCodeInput(code.instructions));
            try {
                insnReader.accept((InstructionVisitor)refInsnVisitor);
                if (!refInsnVisitor.isMethodReferencedToRefAffectedClass) continue;
                return true;
            }
            catch (EOFException e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }
}

