/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.dexpatcher.algorithms.diff;

import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.SizeOf;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.android.dex.util.CompareUtils;
import com.tencent.tinker.android.dx.util.IndexMap;
import com.tencent.tinker.commons.dexpatcher.struct.PatchOperation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class DexSectionDiffAlgorithm<T extends Comparable<T>> {
    private static final AbstractMap.SimpleEntry[] EMPTY_ENTRY_ARRAY = new AbstractMap.SimpleEntry[0];
    protected final Dex oldDex;
    protected final Dex newDex;
    private final IndexMap oldToNewIndexMap;
    private final IndexMap oldToPatchedIndexMap;
    private final IndexMap newToPatchedIndexMap;
    private final IndexMap selfIndexMapForSkip;
    private final List<PatchOperation<T>> patchOperationList;
    private final Map<Integer, PatchOperation<T>> indexToDelOperationMap = new HashMap<Integer, PatchOperation<T>>();
    private final Map<Integer, PatchOperation<T>> indexToAddOperationMap = new HashMap<Integer, PatchOperation<T>>();
    private final Map<Integer, PatchOperation<T>> indexToReplaceOperationMap = new HashMap<Integer, PatchOperation<T>>();
    private final Map<Integer, Integer> oldIndexToNewIndexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> oldOffsetToNewOffsetMap = new HashMap<Integer, Integer>();
    private int patchedSectionSize;
    private Comparator<AbstractMap.SimpleEntry<Integer, T>> comparatorForItemDiff = new Comparator<AbstractMap.SimpleEntry<Integer, T>>(){

        @Override
        public int compare(AbstractMap.SimpleEntry<Integer, T> o1, AbstractMap.SimpleEntry<Integer, T> o2) {
            return ((Comparable)o1.getValue()).compareTo(o2.getValue());
        }
    };
    private Comparator<PatchOperation<T>> comparatorForPatchOperationOpt = new Comparator<PatchOperation<T>>(){

        @Override
        public int compare(PatchOperation<T> o1, PatchOperation<T> o2) {
            int o2OrderId;
            int o1OrderId;
            if (o1.index != o2.index) {
                return CompareUtils.sCompare((int)o1.index, (int)o2.index);
            }
            switch (o1.op) {
                case 0: {
                    o1OrderId = 0;
                    break;
                }
                case 1: {
                    o1OrderId = 1;
                    break;
                }
                case 2: {
                    o1OrderId = 2;
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected patch operation code: " + o1.op);
                }
            }
            switch (o2.op) {
                case 0: {
                    o2OrderId = 0;
                    break;
                }
                case 1: {
                    o2OrderId = 1;
                    break;
                }
                case 2: {
                    o2OrderId = 2;
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected patch operation code: " + o2.op);
                }
            }
            return CompareUtils.sCompare((int)o1OrderId, (int)o2OrderId);
        }
    };
    private AbstractMap.SimpleEntry<Integer, T>[] adjustedOldIndexedItemsWithOrigOrder = null;
    private int oldItemCount = 0;
    private int newItemCount = 0;

    public DexSectionDiffAlgorithm(Dex oldDex, Dex newDex, IndexMap oldToNewIndexMap, IndexMap oldToPatchedIndexMap, IndexMap newToPatchedIndexMap, IndexMap selfIndexMapForSkip) {
        this.oldDex = oldDex;
        this.newDex = newDex;
        this.oldToNewIndexMap = oldToNewIndexMap;
        this.oldToPatchedIndexMap = oldToPatchedIndexMap;
        this.newToPatchedIndexMap = newToPatchedIndexMap;
        this.selfIndexMapForSkip = selfIndexMapForSkip;
        this.patchOperationList = new ArrayList<PatchOperation<T>>();
        this.patchedSectionSize = 0;
    }

    public List<PatchOperation<T>> getPatchOperationList() {
        return this.patchOperationList;
    }

    public int getPatchedSectionSize() {
        return this.patchedSectionSize;
    }

    protected abstract TableOfContents.Section getTocSection(Dex var1);

    protected abstract T nextItem(DexDataBuffer var1);

    protected abstract int getItemSize(T var1);

    protected T adjustItem(IndexMap indexMap, T item) {
        return item;
    }

    protected boolean shouldSkipInNewDex(T newItem) {
        return false;
    }

    protected void updateIndexOrOffset(IndexMap indexMap, int oldIndex, int oldOffset, int newIndex, int newOffset) {
    }

    protected void markDeletedIndexOrOffset(IndexMap indexMap, int deletedIndex, int deletedOffset) {
    }

    private int getItemOffsetOrIndex(int index, T item) {
        if (item instanceof TableOfContents.Section.Item) {
            return ((TableOfContents.Section.Item)item).off;
        }
        return index;
    }

    private AbstractMap.SimpleEntry<Integer, T>[] collectSectionItems(Dex dex, boolean isOldDex) {
        TableOfContents.Section tocSec = this.getTocSection(dex);
        if (!tocSec.exists()) {
            return EMPTY_ENTRY_ARRAY;
        }
        Dex.Section dexSec = dex.openSection(tocSec);
        int itemCount = tocSec.size;
        ArrayList<AbstractMap.SimpleEntry<Integer, T>> result = new ArrayList<AbstractMap.SimpleEntry<Integer, T>>(itemCount);
        if (isOldDex) {
            for (int i = 0; i < itemCount; ++i) {
                T nextItem = this.nextItem((DexDataBuffer)dexSec);
                T adjustedItem = this.adjustItem(this.oldToPatchedIndexMap, nextItem);
                result.add(new AbstractMap.SimpleEntry<Integer, T>(i, adjustedItem));
            }
        } else {
            for (int i = 0; i < itemCount; ++i) {
                int indexAfterSkip;
                Object nextItem = this.nextItem((DexDataBuffer)dexSec);
                int indexBeforeSkip = i;
                int offsetBeforeSkip = this.getItemOffsetOrIndex(indexBeforeSkip, nextItem);
                for (indexAfterSkip = indexBeforeSkip; indexAfterSkip < itemCount && this.shouldSkipInNewDex(nextItem); ++indexAfterSkip) {
                    nextItem = indexAfterSkip + 1 >= itemCount ? null : this.nextItem((DexDataBuffer)dexSec);
                }
                if (nextItem != null) {
                    int offsetAfterSkip = this.getItemOffsetOrIndex(indexAfterSkip, nextItem);
                    T adjustedItem = this.adjustItem(this.newToPatchedIndexMap, this.adjustItem(this.selfIndexMapForSkip, nextItem));
                    int currentOutIndex = result.size();
                    result.add(new AbstractMap.SimpleEntry<Integer, T>(currentOutIndex, adjustedItem));
                    this.updateIndexOrOffset(this.selfIndexMapForSkip, indexBeforeSkip, offsetBeforeSkip, indexAfterSkip, offsetAfterSkip);
                }
                i = indexAfterSkip;
            }
        }
        return result.toArray(new AbstractMap.SimpleEntry[0]);
    }

    public void execute() {
        this.patchOperationList.clear();
        this.adjustedOldIndexedItemsWithOrigOrder = this.collectSectionItems(this.oldDex, true);
        this.oldItemCount = this.adjustedOldIndexedItemsWithOrigOrder.length;
        AbstractMap.SimpleEntry[] adjustedOldIndexedItems = new AbstractMap.SimpleEntry[this.oldItemCount];
        System.arraycopy(this.adjustedOldIndexedItemsWithOrigOrder, 0, adjustedOldIndexedItems, 0, this.oldItemCount);
        Arrays.sort(adjustedOldIndexedItems, this.comparatorForItemDiff);
        AbstractMap.SimpleEntry<Integer, T>[] adjustedNewIndexedItems = this.collectSectionItems(this.newDex, false);
        this.newItemCount = adjustedNewIndexedItems.length;
        Arrays.sort(adjustedNewIndexedItems, this.comparatorForItemDiff);
        int oldCursor = 0;
        int newCursor = 0;
        while (oldCursor < this.oldItemCount || newCursor < this.newItemCount) {
            AbstractMap.SimpleEntry oldIndexedItem;
            if (oldCursor >= this.oldItemCount) {
                while (newCursor < this.newItemCount) {
                    AbstractMap.SimpleEntry<Integer, T> newIndexedItem = adjustedNewIndexedItems[newCursor++];
                    this.patchOperationList.add(new PatchOperation(1, newIndexedItem.getKey().intValue(), newIndexedItem.getValue()));
                }
                continue;
            }
            if (newCursor >= this.newItemCount) {
                while (oldCursor < this.oldItemCount) {
                    oldIndexedItem = adjustedOldIndexedItems[oldCursor++];
                    int deletedIndex = (Integer)oldIndexedItem.getKey();
                    int deletedOffset = this.getItemOffsetOrIndex(deletedIndex, (Comparable)oldIndexedItem.getValue());
                    this.patchOperationList.add(new PatchOperation(0, deletedIndex));
                    this.markDeletedIndexOrOffset(this.oldToPatchedIndexMap, deletedIndex, deletedOffset);
                }
                continue;
            }
            oldIndexedItem = adjustedOldIndexedItems[oldCursor];
            AbstractMap.SimpleEntry<Integer, T> newIndexedItem = adjustedNewIndexedItems[newCursor];
            int cmpRes = ((Comparable)oldIndexedItem.getValue()).compareTo(newIndexedItem.getValue());
            if (cmpRes < 0) {
                int deletedIndex = (Integer)oldIndexedItem.getKey();
                int deletedOffset = this.getItemOffsetOrIndex(deletedIndex, (Comparable)oldIndexedItem.getValue());
                this.patchOperationList.add(new PatchOperation(0, deletedIndex));
                this.markDeletedIndexOrOffset(this.oldToPatchedIndexMap, deletedIndex, deletedOffset);
                ++oldCursor;
                continue;
            }
            if (cmpRes > 0) {
                this.patchOperationList.add(new PatchOperation(1, newIndexedItem.getKey().intValue(), newIndexedItem.getValue()));
                ++newCursor;
                continue;
            }
            int oldIndex = (Integer)oldIndexedItem.getKey();
            int newIndex = newIndexedItem.getKey();
            int oldOffset = this.getItemOffsetOrIndex((Integer)oldIndexedItem.getKey(), (Comparable)oldIndexedItem.getValue());
            int newOffset = this.getItemOffsetOrIndex(newIndexedItem.getKey(), (Comparable)newIndexedItem.getValue());
            if (oldIndex != newIndex) {
                this.oldIndexToNewIndexMap.put(oldIndex, newIndex);
            }
            if (oldOffset != newOffset) {
                this.oldOffsetToNewOffsetMap.put(oldOffset, newOffset);
            }
            ++oldCursor;
            ++newCursor;
        }
        Collections.sort(this.patchOperationList, this.comparatorForPatchOperationOpt);
        Iterator<PatchOperation<T>> patchOperationIt = this.patchOperationList.iterator();
        PatchOperation<T> prevPatchOperation = null;
        while (patchOperationIt.hasNext()) {
            PatchOperation<T> patchOperation = patchOperationIt.next();
            if (prevPatchOperation != null && prevPatchOperation.op == 0 && patchOperation.op == 1) {
                if (prevPatchOperation.index == patchOperation.index) {
                    prevPatchOperation.op = 2;
                    prevPatchOperation.newItem = patchOperation.newItem;
                    patchOperationIt.remove();
                    prevPatchOperation = null;
                    continue;
                }
                prevPatchOperation = patchOperation;
                continue;
            }
            prevPatchOperation = patchOperation;
        }
        for (PatchOperation<T> patchOperation : this.patchOperationList) {
            switch (patchOperation.op) {
                case 0: {
                    this.indexToDelOperationMap.put(patchOperation.index, patchOperation);
                    break;
                }
                case 1: {
                    this.indexToAddOperationMap.put(patchOperation.index, patchOperation);
                    break;
                }
                case 2: {
                    this.indexToReplaceOperationMap.put(patchOperation.index, patchOperation);
                }
            }
        }
    }

    public void simulatePatchOperation(int baseOffset) {
        boolean isNeedToMakeAlign = this.getTocSection((Dex)this.oldDex).isElementFourByteAligned;
        int oldIndex = 0;
        int patchedIndex = 0;
        int patchedOffset = baseOffset;
        while (oldIndex < this.oldItemCount || patchedIndex < this.newItemCount) {
            int itemSize;
            PatchOperation<T> patchOperation;
            if (this.indexToAddOperationMap.containsKey(patchedIndex)) {
                patchOperation = this.indexToAddOperationMap.get(patchedIndex);
                if (isNeedToMakeAlign) {
                    patchedOffset = SizeOf.roundToTimesOfFour((int)patchedOffset);
                }
                Comparable newItem = (Comparable)patchOperation.newItem;
                itemSize = this.getItemSize(newItem);
                this.updateIndexOrOffset(this.newToPatchedIndexMap, 0, this.getItemOffsetOrIndex(patchOperation.index, newItem), 0, patchedOffset);
                ++patchedIndex;
                patchedOffset += itemSize;
                continue;
            }
            if (this.indexToReplaceOperationMap.containsKey(patchedIndex)) {
                patchOperation = this.indexToReplaceOperationMap.get(patchedIndex);
                if (isNeedToMakeAlign) {
                    patchedOffset = SizeOf.roundToTimesOfFour((int)patchedOffset);
                }
                Comparable newItem = (Comparable)patchOperation.newItem;
                itemSize = this.getItemSize(newItem);
                this.updateIndexOrOffset(this.newToPatchedIndexMap, 0, this.getItemOffsetOrIndex(patchOperation.index, newItem), 0, patchedOffset);
                ++patchedIndex;
                patchedOffset += itemSize;
                continue;
            }
            if (this.indexToDelOperationMap.containsKey(oldIndex)) {
                ++oldIndex;
                continue;
            }
            if (this.indexToReplaceOperationMap.containsKey(oldIndex)) {
                ++oldIndex;
                continue;
            }
            if (oldIndex >= this.oldItemCount) continue;
            if (isNeedToMakeAlign) {
                patchedOffset = SizeOf.roundToTimesOfFour((int)patchedOffset);
            }
            Comparable oldItem = (Comparable)this.adjustedOldIndexedItemsWithOrigOrder[oldIndex].getValue();
            int itemSize2 = this.getItemSize(oldItem);
            int oldOffset = this.getItemOffsetOrIndex(oldIndex, oldItem);
            this.updateIndexOrOffset(this.oldToPatchedIndexMap, oldIndex, oldOffset, patchedIndex, patchedOffset);
            int newIndex = oldIndex;
            if (this.oldIndexToNewIndexMap.containsKey(oldIndex)) {
                newIndex = this.oldIndexToNewIndexMap.get(oldIndex);
            }
            int newOffset = oldOffset;
            if (this.oldOffsetToNewOffsetMap.containsKey(oldOffset)) {
                newOffset = this.oldOffsetToNewOffsetMap.get(oldOffset);
            }
            this.updateIndexOrOffset(this.newToPatchedIndexMap, newIndex, newOffset, patchedIndex, patchedOffset);
            ++oldIndex;
            ++patchedIndex;
            patchedOffset += itemSize2;
        }
        this.patchedSectionSize = SizeOf.roundToTimesOfFour((int)(patchedOffset - baseOffset));
    }
}

