/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.build.decoder.DexDiffDecoder;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.TinkerPatchException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class UniqueDexDiffDecoder
extends DexDiffDecoder {
    private ArrayList<String> addedDexFiles = new ArrayList();

    public UniqueDexDiffDecoder(Configuration config, String metaPath, String logPath) throws IOException {
        super(config, metaPath, logPath);
    }

    @Override
    public boolean patch(File oldFile, File newFile) throws IOException, TinkerPatchException {
        boolean added = super.patch(oldFile, newFile);
        if (added) {
            String name = newFile.getName();
            if (this.addedDexFiles.contains(name)) {
                throw new TinkerPatchException("illegal dex name, dex name should be unique, dex:" + name);
            }
            this.addedDexFiles.add(name);
        }
        return added;
    }
}

