/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.decoder.BsDiffDecoder;
import com.tencent.tinker.build.decoder.ManifestDecoder;
import com.tencent.tinker.build.decoder.ResDiffDecoder;
import com.tencent.tinker.build.decoder.UniqueDexDiffDecoder;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.FileOperation;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.MD5;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;

public class ApkDecoder
extends BaseDecoder {
    private final File mOldApkDir;
    private final File mNewApkDir;
    private final ManifestDecoder manifestDecoder;
    private final UniqueDexDiffDecoder dexPatchDecoder;
    private final BsDiffDecoder soPatchDecoder;
    private final ResDiffDecoder resPatchDecoder;
    ArrayList<File> resDuplicateFiles;

    public ApkDecoder(Configuration config) throws IOException {
        super(config);
        this.mNewApkDir = config.mTempUnzipNewDir;
        this.mOldApkDir = config.mTempUnzipOldDir;
        this.manifestDecoder = new ManifestDecoder(config);
        String prePath = "assets" + File.separator;
        this.dexPatchDecoder = new UniqueDexDiffDecoder(config, prePath + "dex_meta.txt", "dex_log.txt");
        this.soPatchDecoder = new BsDiffDecoder(config, prePath + "so_meta.txt", "so_log.txt");
        this.resPatchDecoder = new ResDiffDecoder(config, prePath + "res_meta.txt", "res_log.txt");
        this.resDuplicateFiles = new ArrayList();
    }

    private void unzipApkFile(File file, File destFile) throws TinkerPatchException, IOException {
        String apkName = file.getName();
        if (!apkName.endsWith(".apk")) {
            throw new TinkerPatchException(String.format("input apk file path must end with .apk, yours %s\n", apkName));
        }
        String destPath = destFile.getAbsolutePath();
        Logger.d("UnZipping apk to %s", destPath);
        FileOperation.unZipAPk(file.getAbsoluteFile().getAbsolutePath(), destPath);
    }

    private void unzipApkFiles(File oldFile, File newFile) throws IOException, TinkerPatchException {
        this.unzipApkFile(oldFile, this.mOldApkDir);
        this.unzipApkFile(newFile, this.mNewApkDir);
    }

    private void writeToLogFile(File oldFile, File newFile) throws IOException {
        String line1 = "old apk: " + oldFile.getName() + ", size=" + FileOperation.getFileSizes(oldFile) + ", md5=" + MD5.getMD5(oldFile);
        String line2 = "new apk: " + newFile.getName() + ", size=" + FileOperation.getFileSizes(newFile) + ", md5=" + MD5.getMD5(newFile);
        Logger.d("Analyze old and new apk files:");
        Logger.d(line1);
        Logger.d(line2);
        Logger.d("");
    }

    @Override
    public void onAllPatchesStart() throws IOException, TinkerPatchException {
        this.manifestDecoder.onAllPatchesStart();
        this.dexPatchDecoder.onAllPatchesStart();
        this.soPatchDecoder.onAllPatchesStart();
        this.resPatchDecoder.onAllPatchesStart();
    }

    @Override
    public boolean patch(File oldFile, File newFile) throws Exception {
        this.writeToLogFile(oldFile, newFile);
        this.manifestDecoder.patch(oldFile, newFile);
        this.unzipApkFiles(oldFile, newFile);
        Files.walkFileTree(this.mNewApkDir.toPath(), new ApkFilesVisitor(this.config, this.mNewApkDir.toPath(), this.mOldApkDir.toPath(), this.dexPatchDecoder, this.soPatchDecoder, this.resPatchDecoder));
        for (File duplicateRes : this.resDuplicateFiles) {
            Logger.e("Warning: res file %s is also match at dex or library pattern, we treat it as unchanged in the new resource_out.zip", this.getRelativeStringByOldDir(duplicateRes));
        }
        this.soPatchDecoder.onAllPatchesEnd();
        this.dexPatchDecoder.onAllPatchesEnd();
        this.manifestDecoder.onAllPatchesEnd();
        this.resPatchDecoder.onAllPatchesEnd();
        this.dexPatchDecoder.clean();
        this.soPatchDecoder.clean();
        this.resPatchDecoder.clean();
        return true;
    }

    @Override
    public void onAllPatchesEnd() throws IOException, TinkerPatchException {
    }

    class ApkFilesVisitor
    extends SimpleFileVisitor<Path> {
        BaseDecoder dexDecoder;
        BaseDecoder soDecoder;
        BaseDecoder resDecoder;
        Configuration config;
        Path newApkPath;
        Path oldApkPath;

        ApkFilesVisitor(Configuration config, Path newPath, Path oldPath, BaseDecoder dex, BaseDecoder so, BaseDecoder resDecoder) {
            this.config = config;
            this.dexDecoder = dex;
            this.soDecoder = so;
            this.resDecoder = resDecoder;
            this.newApkPath = newPath;
            this.oldApkPath = oldPath;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String patternKey;
            Path relativePath = this.newApkPath.relativize(file);
            Path oldPath = this.oldApkPath.resolve(relativePath);
            File oldFile = null;
            if (oldPath.toFile().exists()) {
                oldFile = oldPath.toFile();
            }
            if (Utils.checkFileInPattern(this.config.mDexFilePattern, patternKey = relativePath.toString().replace("\\", "/"))) {
                if (Utils.checkFileInPattern(this.config.mResFilePattern, patternKey) && oldFile != null) {
                    ApkDecoder.this.resDuplicateFiles.add(oldFile);
                }
                try {
                    this.dexDecoder.patch(oldFile, file.toFile());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return FileVisitResult.CONTINUE;
            }
            if (Utils.checkFileInPattern(this.config.mSoFilePattern, patternKey)) {
                if (Utils.checkFileInPattern(this.config.mResFilePattern, patternKey) && oldFile != null) {
                    ApkDecoder.this.resDuplicateFiles.add(oldFile);
                }
                try {
                    this.soDecoder.patch(oldFile, file.toFile());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return FileVisitResult.CONTINUE;
            }
            if (Utils.checkFileInPattern(this.config.mResFilePattern, patternKey)) {
                try {
                    this.resDecoder.patch(oldFile, file.toFile());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

