/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.auxiliaryclass;

import com.tencent.tinker.build.auxiliaryclass.AuxiliaryClassInjectAdapter;
import com.tencent.tinker.commons.ziputil.Streams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class AuxiliaryClassInjector {
    public static final String AUXILIARY_CLASSNAME = "dalvik.system.PathClassLoader";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processClass(File classIn, File classOut) throws IOException {
        BufferedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = new BufferedInputStream(new FileInputStream(classIn));
            os = new BufferedOutputStream(new FileOutputStream(classOut));
            AuxiliaryClassInjector.processClass(is, os);
        }
        catch (Throwable throwable) {
            AuxiliaryClassInjector.closeQuietly(os);
            AuxiliaryClassInjector.closeQuietly(is);
            throw throwable;
        }
        AuxiliaryClassInjector.closeQuietly(os);
        AuxiliaryClassInjector.closeQuietly(is);
    }

    public static void processJar(File jarIn, File jarOut, ProcessJarCallback cb) throws IOException {
        try {
            AuxiliaryClassInjector.processJarHelper(jarIn, jarOut, cb, Charset.forName("UTF-8"), Charset.forName("UTF-8"));
        }
        catch (IllegalArgumentException e) {
            if ("MALFORMED".equals(e.getMessage())) {
                AuxiliaryClassInjector.processJarHelper(jarIn, jarOut, cb, Charset.forName("GBK"), Charset.forName("UTF-8"));
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJarHelper(File jarIn, File jarOut, ProcessJarCallback cb, Charset charsetIn, Charset charsetOut) throws IOException {
        ZipInputStream zis = null;
        ZipOutputStream zos = null;
        try {
            zis = new ZipInputStream((InputStream)new BufferedInputStream(new FileInputStream(jarIn)), charsetIn);
            zos = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(jarOut)), charsetOut);
            ZipEntry entryIn = null;
            while ((entryIn = zis.getNextEntry()) != null) {
                String entryName = entryIn.getName();
                ZipEntry entryOut = new ZipEntry(entryName);
                zos.putNextEntry(entryOut);
                if (!entryIn.isDirectory()) {
                    if (entryName.endsWith(".class")) {
                        if (cb == null || cb.onProcessClassEntry(entryName)) {
                            AuxiliaryClassInjector.processClass(zis, zos);
                        } else {
                            Streams.copy((InputStream)zis, (OutputStream)zos);
                        }
                    } else {
                        Streams.copy((InputStream)zis, (OutputStream)zos);
                    }
                }
                zos.closeEntry();
            }
        }
        catch (Throwable throwable) {
            AuxiliaryClassInjector.closeQuietly(zos);
            AuxiliaryClassInjector.closeQuietly(zis);
            throw throwable;
        }
        AuxiliaryClassInjector.closeQuietly(zos);
        AuxiliaryClassInjector.closeQuietly(zis);
    }

    private static void processClass(InputStream classIn, OutputStream classOut) throws IOException {
        ClassReader cr = new ClassReader(classIn);
        ClassWriter cw = new ClassWriter(0);
        AuxiliaryClassInjectAdapter aia = new AuxiliaryClassInjectAdapter(AUXILIARY_CLASSNAME, cw);
        cr.accept((ClassVisitor)aia, 0);
        classOut.write(cw.toByteArray());
        classOut.flush();
    }

    private static void closeQuietly(Closeable target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface ProcessJarCallback {
        public boolean onProcessClassEntry(String var1);
    }
}

