/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.auxiliaryclass;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class AuxiliaryClassInjectAdapter
extends ClassVisitor {
    private final String auxiliaryClassDesc;
    private boolean isClInitExists;
    private boolean isInitExists;
    private boolean isTargetClass;
    private boolean isInjected;

    public AuxiliaryClassInjectAdapter(String auxiliaryClassName, ClassWriter cw) {
        super(327680, (ClassVisitor)cw);
        this.auxiliaryClassDesc = this.fastClassNameToDesc(auxiliaryClassName);
    }

    private String fastClassNameToDesc(String className) {
        if (className.startsWith("L") && className.endsWith(";")) {
            return className;
        }
        if ("boolean".equals(className)) {
            return "Z";
        }
        if ("byte".equals(className)) {
            return "B";
        }
        if ("char".equals(className)) {
            return "C";
        }
        if ("short".equals(className)) {
            return "S";
        }
        if ("int".equals(className)) {
            return "I";
        }
        if ("long".equals(className)) {
            return "J";
        }
        if ("float".equals(className)) {
            return "F";
        }
        if ("double".equals(className)) {
            return "D";
        }
        className = className.replace('.', '/');
        return "L" + className + ";";
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.isClInitExists = false;
        this.isInitExists = false;
        this.isTargetClass = (access & 0x200) == 0;
        this.isInjected = false;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv != null && this.isTargetClass && !this.isInjected) {
            if ("<clinit>".equals(name)) {
                this.isClInitExists = true;
                this.isInjected = true;
                mv = new InjectImplMethodVisitor(mv);
            } else if ("<init>".equals(name)) {
                this.isInitExists = true;
                this.isInjected = true;
                mv = new InjectImplMethodVisitor(mv);
            }
        }
        return mv;
    }

    public void visitEnd() {
        if (!this.isClInitExists && !this.isInitExists) {
            MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            mv.visitLdcInsn((Object)Type.getType((String)this.auxiliaryClassDesc));
            mv.visitVarInsn(58, 0);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    private class InjectImplMethodVisitor
    extends MethodVisitor {
        InjectImplMethodVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                super.visitLdcInsn((Object)Type.getType((String)AuxiliaryClassInjectAdapter.this.auxiliaryClassDesc));
                super.visitVarInsn(58, 0);
            }
            super.visitInsn(opcode);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            if (maxStack < 1) {
                maxStack = 1;
            }
            if (maxLocals < 1) {
                maxLocals = 1;
            }
            super.visitMaxs(maxStack, maxLocals);
        }
    }
}

