/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.aapt;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RDotTxtEntry
implements Comparable<RDotTxtEntry> {
    private static final Pattern TEXT_SYMBOLS_LINE = Pattern.compile("(\\S+) (\\S+) (\\S+) (.+)");
    public static final Function<String, RDotTxtEntry> TO_ENTRY = new Function<String, RDotTxtEntry>(){

        public RDotTxtEntry apply(String input) {
            Optional<RDotTxtEntry> entry = RDotTxtEntry.parse(input);
            Preconditions.checkNotNull((Object)entry.isPresent(), (String)"Could not parse R.txt entry: '%s'", (Object[])new Object[]{input});
            return (RDotTxtEntry)entry.get();
        }
    };
    public final IdType idType;
    public final RType type;
    public final String name;
    public String idValue;

    public RDotTxtEntry(IdType idType, RType type, String name, String idValue) {
        this.idType = (IdType)((Object)Preconditions.checkNotNull((Object)((Object)idType)));
        this.type = (RType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.idValue = (String)Preconditions.checkNotNull((Object)idValue);
    }

    public static Optional<RDotTxtEntry> parse(String rDotTxtLine) {
        Matcher matcher = TEXT_SYMBOLS_LINE.matcher(rDotTxtLine);
        if (!matcher.matches()) {
            return Optional.absent();
        }
        IdType idType = IdType.from(matcher.group(1));
        RType type = RType.valueOf(matcher.group(2).toUpperCase());
        String name = matcher.group(3);
        String idValue = matcher.group(4);
        return Optional.of((Object)new RDotTxtEntry(idType, type, name, idValue));
    }

    public RDotTxtEntry copyWithNewIdValue(String newIdValue) {
        return new RDotTxtEntry(this.idType, this.type, this.name, newIdValue);
    }

    @Override
    public int compareTo(RDotTxtEntry that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.type), (Comparable)((Object)that.type)).compare((Comparable)((Object)this.name), (Comparable)((Object)that.name)).result();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RDotTxtEntry)) {
            return false;
        }
        RDotTxtEntry that = (RDotTxtEntry)obj;
        return Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.type, this.name});
    }

    public String toString() {
        return Objects.toStringHelper(RDotTxtEntry.class).add("idType", (Object)this.idType).add("type", (Object)this.type).add("name", (Object)this.name).add("idValue", (Object)this.idValue).toString();
    }

    public static enum IdType {
        INT,
        INT_ARRAY;


        public static IdType from(String raw) {
            if (raw.equals("int")) {
                return INT;
            }
            if (raw.equals("int[]")) {
                return INT_ARRAY;
            }
            throw new IllegalArgumentException(String.format("'%s' is not a valid ID type.", raw));
        }

        public String toString() {
            if (this.equals((Object)INT)) {
                return "int";
            }
            return "int[]";
        }
    }

    public static enum RType {
        ANIM,
        ANIMATOR,
        ARRAY,
        ATTR,
        BOOL,
        COLOR,
        DIMEN,
        DRAWABLE,
        FRACTION,
        ID,
        INTEGER,
        INTERPOLATOR,
        LAYOUT,
        MENU,
        MIPMAP,
        PLURALS,
        RAW,
        STRING,
        STYLE,
        STYLEABLE,
        TRANSITION,
        XML;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

