/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.ziputil;

import com.tencent.tinker.commons.ziputil.Arrays;
import com.tencent.tinker.commons.ziputil.StandardCharsets;
import com.tencent.tinker.commons.ziputil.TinkerZipEntry;
import com.tencent.tinker.commons.ziputil.ZipConstants;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.zip.ZipException;

public class TinkerZipOutputStream
extends FilterOutputStream
implements ZipConstants {
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    public static final byte[] BYTE = new byte[0];
    static final int TIME_CONST = 40691;
    static final int MOD_DATE_CONST = 18698;
    private static final int ZIP_VERSION_2_0 = 20;
    private static final byte[] ZIP64_PLACEHOLDER_BYTES = new byte[]{-1, -1, -1, -1};
    private final HashSet<String> entries = new HashSet();
    private final boolean forceZip64;
    private byte[] commentBytes = BYTE;
    private int defaultCompressionMethod = 8;
    private ByteArrayOutputStream cDir = new ByteArrayOutputStream();
    private TinkerZipEntry currentEntry;
    private long offset = 0L;
    private byte[] nameBytes;
    private byte[] entryCommentBytes;
    private boolean archiveNeedsZip64EocdRecord;
    private boolean currentEntryNeedsZip64;

    public TinkerZipOutputStream(OutputStream os) {
        this(os, false);
    }

    public TinkerZipOutputStream(OutputStream os, boolean forceZip64) {
        super(os);
        this.forceZip64 = forceZip64;
    }

    static long writeLongAsUint32(OutputStream os, long i) throws IOException {
        os.write((int)(i & 0xFFL));
        os.write((int)(i >> 8) & 0xFF);
        os.write((int)(i >> 16) & 0xFF);
        os.write((int)(i >> 24) & 0xFF);
        return i;
    }

    static long writeLongAsUint64(OutputStream os, long i) throws IOException {
        int i1 = (int)i;
        os.write(i1 & 0xFF);
        os.write(i1 >> 8 & 0xFF);
        os.write(i1 >> 16 & 0xFF);
        os.write(i1 >> 24 & 0xFF);
        int i2 = (int)(i >> 32);
        os.write(i2 & 0xFF);
        os.write(i2 >> 8 & 0xFF);
        os.write(i2 >> 16 & 0xFF);
        os.write(i2 >> 24 & 0xFF);
        return i;
    }

    static int writeIntAsUint16(OutputStream os, int i) throws IOException {
        os.write(i & 0xFF);
        os.write(i >> 8 & 0xFF);
        return i;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.finish();
            this.out.close();
            this.out = null;
        }
    }

    public void closeEntry() throws IOException {
        this.checkOpen();
        if (this.currentEntry == null) {
            return;
        }
        long curOffset = 30L;
        if (this.currentEntry.getMethod() != 0) {
            curOffset += 16L;
            TinkerZipOutputStream.writeLongAsUint32(this.out, 134695760L);
            TinkerZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.crc);
            TinkerZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.compressedSize);
            TinkerZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.size);
        }
        int flags = this.currentEntry.getMethod() == 0 ? 0 : 8;
        flags |= 0x800;
        TinkerZipOutputStream.writeLongAsUint32(this.cDir, 33639248L);
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, 20);
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, 20);
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, flags);
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, this.currentEntry.getMethod());
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, this.currentEntry.time);
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, this.currentEntry.modDate);
        TinkerZipOutputStream.writeLongAsUint32(this.cDir, this.currentEntry.crc);
        curOffset = this.currentEntry.getMethod() == 8 ? (curOffset += this.currentEntry.getCompressedSize()) : (curOffset += this.currentEntry.getSize());
        TinkerZipOutputStream.writeLongAsUint32(this.cDir, this.currentEntry.getCompressedSize());
        TinkerZipOutputStream.writeLongAsUint32(this.cDir, this.currentEntry.getSize());
        curOffset += (long)TinkerZipOutputStream.writeIntAsUint16(this.cDir, this.nameBytes.length);
        if (this.currentEntry.extra != null) {
            curOffset += (long)TinkerZipOutputStream.writeIntAsUint16(this.cDir, this.currentEntry.extra.length);
        } else {
            TinkerZipOutputStream.writeIntAsUint16(this.cDir, 0);
        }
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, this.entryCommentBytes.length);
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, 0);
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, 0);
        TinkerZipOutputStream.writeLongAsUint32(this.cDir, 0L);
        TinkerZipOutputStream.writeLongAsUint32(this.cDir, this.currentEntry.localHeaderRelOffset);
        this.cDir.write(this.nameBytes);
        this.nameBytes = null;
        if (this.currentEntry.extra != null) {
            this.cDir.write(this.currentEntry.extra);
        }
        this.offset += curOffset;
        if (this.entryCommentBytes.length > 0) {
            this.cDir.write(this.entryCommentBytes);
            this.entryCommentBytes = BYTE;
        }
        this.currentEntry = null;
    }

    public void finish() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream is closed");
        }
        if (this.cDir == null) {
            return;
        }
        if (this.entries.isEmpty()) {
            throw new ZipException("No entries");
        }
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        int cdirEntriesSize = this.cDir.size();
        TinkerZipOutputStream.writeLongAsUint32(this.cDir, 101010256L);
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, 0);
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, 0);
        if (this.archiveNeedsZip64EocdRecord) {
            TinkerZipOutputStream.writeIntAsUint16(this.cDir, 65535);
            TinkerZipOutputStream.writeIntAsUint16(this.cDir, 65535);
            TinkerZipOutputStream.writeLongAsUint32(this.cDir, -1L);
            TinkerZipOutputStream.writeLongAsUint32(this.cDir, -1L);
        } else {
            TinkerZipOutputStream.writeIntAsUint16(this.cDir, this.entries.size());
            TinkerZipOutputStream.writeIntAsUint16(this.cDir, this.entries.size());
            TinkerZipOutputStream.writeLongAsUint32(this.cDir, cdirEntriesSize);
            TinkerZipOutputStream.writeLongAsUint32(this.cDir, this.offset);
        }
        TinkerZipOutputStream.writeIntAsUint16(this.cDir, this.commentBytes.length);
        if (this.commentBytes.length > 0) {
            this.cDir.write(this.commentBytes);
        }
        this.cDir.writeTo(this.out);
        this.cDir = null;
    }

    public void putNextEntry(TinkerZipEntry ze) throws IOException {
        int method;
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        if ((method = ze.getMethod()) == -1) {
            method = this.defaultCompressionMethod;
        }
        if (method == 0) {
            if (ze.getCompressedSize() == -1L) {
                ze.setCompressedSize(ze.getSize());
            } else if (ze.getSize() == -1L) {
                ze.setSize(ze.getCompressedSize());
            }
            if (ze.getCrc() == -1L) {
                throw new ZipException("STORED entry missing CRC");
            }
            if (ze.getSize() == -1L) {
                throw new ZipException("STORED entry missing size");
            }
            if (ze.size != ze.compressedSize) {
                throw new ZipException("STORED entry size/compressed size mismatch");
            }
        }
        this.checkOpen();
        ze.comment = null;
        ze.extra = null;
        ze.time = 40691;
        ze.modDate = 18698;
        this.nameBytes = ze.name.getBytes(StandardCharsets.UTF_8);
        this.checkSizeIsWithinShort("Name", this.nameBytes);
        this.entryCommentBytes = BYTE;
        if (ze.comment != null) {
            this.entryCommentBytes = ze.comment.getBytes(StandardCharsets.UTF_8);
            this.checkSizeIsWithinShort("Comment", this.entryCommentBytes);
        }
        ze.setMethod(method);
        this.currentEntry = ze;
        this.currentEntry.localHeaderRelOffset = this.offset;
        this.entries.add(this.currentEntry.name);
        int flags = method == 0 ? 0 : 8;
        TinkerZipOutputStream.writeLongAsUint32(this.out, 67324752L);
        TinkerZipOutputStream.writeIntAsUint16(this.out, 20);
        TinkerZipOutputStream.writeIntAsUint16(this.out, flags |= 0x800);
        TinkerZipOutputStream.writeIntAsUint16(this.out, method);
        TinkerZipOutputStream.writeIntAsUint16(this.out, this.currentEntry.time);
        TinkerZipOutputStream.writeIntAsUint16(this.out, this.currentEntry.modDate);
        if (method == 0) {
            TinkerZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.crc);
            TinkerZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.size);
            TinkerZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.size);
        } else {
            TinkerZipOutputStream.writeLongAsUint32(this.out, 0L);
            TinkerZipOutputStream.writeLongAsUint32(this.out, 0L);
            TinkerZipOutputStream.writeLongAsUint32(this.out, 0L);
        }
        TinkerZipOutputStream.writeIntAsUint16(this.out, this.nameBytes.length);
        if (this.currentEntry.extra != null) {
            TinkerZipOutputStream.writeIntAsUint16(this.out, this.currentEntry.extra.length);
        } else {
            TinkerZipOutputStream.writeIntAsUint16(this.out, 0);
        }
        this.out.write(this.nameBytes);
        if (this.currentEntry.extra != null) {
            this.out.write(this.currentEntry.extra);
        }
    }

    public void setComment(String comment) {
        if (comment == null) {
            this.commentBytes = BYTE;
            return;
        }
        byte[] newCommentBytes = comment.getBytes(StandardCharsets.UTF_8);
        this.checkSizeIsWithinShort("Comment", newCommentBytes);
        this.commentBytes = newCommentBytes;
    }

    @Override
    public void write(byte[] buffer, int offset, int byteCount) throws IOException {
        Arrays.checkOffsetAndCount(buffer.length, offset, byteCount);
        if (this.currentEntry == null) {
            throw new ZipException("No active entry");
        }
        if (this.currentEntry.getMethod() == 0) {
            this.out.write(buffer, offset, byteCount);
        } else {
            this.out.write(buffer, offset, byteCount);
        }
    }

    private void checkOpen() throws IOException {
        if (this.cDir == null) {
            throw new IOException("Stream is closed");
        }
    }

    private void checkSizeIsWithinShort(String property, byte[] bytes) {
        if (bytes.length > 65535) {
            throw new IllegalArgumentException(property + " too long in UTF-8:" + bytes.length + " bytes");
        }
    }
}

