/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.algorithms.patch;

import com.tencent.tinker.android.dex.Annotation;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.android.dx.util.IndexMap;
import com.tencent.tinker.commons.dexpatcher.algorithms.patch.DexSectionPatchAlgorithm;
import com.tencent.tinker.commons.dexpatcher.struct.DexPatchFile;
import com.tencent.tinker.commons.dexpatcher.struct.SmallPatchedDexItemFile;

public class AnnotationSectionPatchAlgorithm
extends DexSectionPatchAlgorithm<Annotation> {
    private TableOfContents.Section patchedAnnotationTocSec = null;
    private Dex.Section patchedAnnotationSec = null;

    public AnnotationSectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, Dex patchedDex, IndexMap oldToFullPatchedIndexMap, IndexMap fullPatchedToSmallPatchedIndexMap, final SmallPatchedDexItemFile extraInfoFile) {
        this(patchFile, oldDex, patchedDex, oldToFullPatchedIndexMap, fullPatchedToSmallPatchedIndexMap, new DexSectionPatchAlgorithm.SmallPatchedDexItemChooser(){

            @Override
            public boolean isPatchedItemInSmallPatchedDex(String oldDexSign, int patchedItemIndex) {
                return extraInfoFile.isAnnotationInSmallPatchedDex(oldDexSign, patchedItemIndex);
            }
        });
    }

    public AnnotationSectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, Dex patchedDex, IndexMap oldToFullPatchedIndexMap, IndexMap fullPatchedToSmallPatchedIndexMap, DexSectionPatchAlgorithm.SmallPatchedDexItemChooser spdItemChooser) {
        super(patchFile, oldDex, oldToFullPatchedIndexMap, fullPatchedToSmallPatchedIndexMap, spdItemChooser);
        if (patchedDex != null) {
            this.patchedAnnotationTocSec = patchedDex.getTableOfContents().annotations;
            this.patchedAnnotationSec = patchedDex.openSection(this.patchedAnnotationTocSec);
        }
    }

    @Override
    protected TableOfContents.Section getTocSection(Dex dex) {
        return dex.getTableOfContents().annotations;
    }

    @Override
    protected Annotation nextItem(DexDataBuffer section) {
        return section.readAnnotation();
    }

    @Override
    protected int getItemSize(Annotation item) {
        return item.byteCountInDex();
    }

    @Override
    protected int getFullPatchSectionBase() {
        if (this.patchFile != null) {
            return this.patchFile.getPatchedAnnotationSectionOffset();
        }
        return this.getTocSection((Dex)this.oldDex).off;
    }

    @Override
    protected Annotation adjustItem(IndexMap indexMap, Annotation item) {
        return indexMap.adjust(item);
    }

    @Override
    protected int writePatchedItem(Annotation patchedItem) {
        ++this.patchedAnnotationTocSec.size;
        return this.patchedAnnotationSec.writeAnnotation(patchedItem);
    }

    @Override
    protected void updateIndexOrOffset(IndexMap indexMap, int oldIndex, int oldOffset, int newIndex, int newOffset) {
        if (oldOffset != newOffset) {
            indexMap.mapAnnotationOffset(oldOffset, newOffset);
        }
    }

    @Override
    protected void markDeletedIndexOrOffset(IndexMap indexMap, int deletedIndex, int deletedOffset) {
        indexMap.markAnnotationDeleted(deletedOffset);
    }
}

