/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.algorithms.patch;

import com.tencent.tinker.android.dex.AnnotationsDirectory;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.android.dx.util.IndexMap;
import com.tencent.tinker.commons.dexpatcher.algorithms.patch.DexSectionPatchAlgorithm;
import com.tencent.tinker.commons.dexpatcher.struct.DexPatchFile;
import com.tencent.tinker.commons.dexpatcher.struct.SmallPatchedDexItemFile;

public class AnnotationsDirectorySectionPatchAlgorithm
extends DexSectionPatchAlgorithm<AnnotationsDirectory> {
    private TableOfContents.Section patchedAnnotationsDirectoryTocSec = null;
    private Dex.Section patchedAnnotationsDirectorySec = null;

    public AnnotationsDirectorySectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, Dex patchedDex, IndexMap oldToFullPatchedIndexMap, IndexMap fullPatchedToSmallPatchedIndexMap, final SmallPatchedDexItemFile extraInfoFile) {
        this(patchFile, oldDex, patchedDex, oldToFullPatchedIndexMap, fullPatchedToSmallPatchedIndexMap, new DexSectionPatchAlgorithm.SmallPatchedDexItemChooser(){

            @Override
            public boolean isPatchedItemInSmallPatchedDex(String oldDexSign, int patchedItemIndex) {
                return extraInfoFile.isAnnotationsDirectoryInSmallPatchedDex(oldDexSign, patchedItemIndex);
            }
        });
    }

    public AnnotationsDirectorySectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, Dex patchedDex, IndexMap oldToFullPatchedIndexMap, IndexMap fullPatchedToSmallPatchedIndexMap, DexSectionPatchAlgorithm.SmallPatchedDexItemChooser spdItemChooser) {
        super(patchFile, oldDex, oldToFullPatchedIndexMap, fullPatchedToSmallPatchedIndexMap, spdItemChooser);
        if (patchedDex != null) {
            this.patchedAnnotationsDirectoryTocSec = patchedDex.getTableOfContents().annotationsDirectories;
            this.patchedAnnotationsDirectorySec = patchedDex.openSection(this.patchedAnnotationsDirectoryTocSec);
        }
    }

    @Override
    protected TableOfContents.Section getTocSection(Dex dex) {
        return dex.getTableOfContents().annotationsDirectories;
    }

    @Override
    protected AnnotationsDirectory nextItem(DexDataBuffer section) {
        return section.readAnnotationsDirectory();
    }

    @Override
    protected int getItemSize(AnnotationsDirectory item) {
        return item.byteCountInDex();
    }

    @Override
    protected int getFullPatchSectionBase() {
        if (this.patchFile != null) {
            return this.patchFile.getPatchedAnnotationsDirectorySectionOffset();
        }
        return this.getTocSection((Dex)this.oldDex).off;
    }

    @Override
    protected AnnotationsDirectory adjustItem(IndexMap indexMap, AnnotationsDirectory item) {
        return indexMap.adjust(item);
    }

    @Override
    protected int writePatchedItem(AnnotationsDirectory patchedItem) {
        ++this.patchedAnnotationsDirectoryTocSec.size;
        return this.patchedAnnotationsDirectorySec.writeAnnotationsDirectory(patchedItem);
    }

    @Override
    protected void updateIndexOrOffset(IndexMap indexMap, int oldIndex, int oldOffset, int newIndex, int newOffset) {
        if (oldOffset != newOffset) {
            indexMap.mapAnnotationsDirectoryOffset(oldOffset, newOffset);
        }
    }

    @Override
    protected void markDeletedIndexOrOffset(IndexMap indexMap, int deletedIndex, int deletedOffset) {
        indexMap.markAnnotationsDirectoryDeleted(deletedOffset);
    }
}

