/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.bsdiff;

import com.tencent.tinker.bsdiff.BSUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class BSDiff {
    private static final byte[] MAGIC_BYTES = new byte[]{77, 105, 99, 114, 111, 77, 115, 103};

    private static void split(int[] arrayI, int[] arrayV, int start, int len, int h) {
        int tmp;
        int i;
        if (len < 16) {
            int j;
            for (int k = start; k < start + len; k += j) {
                j = 1;
                int x = arrayV[arrayI[k] + h];
                int i2 = 1;
                while (k + i2 < start + len) {
                    if (arrayV[arrayI[k + i2] + h] < x) {
                        x = arrayV[arrayI[k + i2] + h];
                        j = 0;
                    }
                    if (arrayV[arrayI[k + i2] + h] == x) {
                        int tmp2 = arrayI[k + j];
                        arrayI[k + j] = arrayI[k + i2];
                        arrayI[k + i2] = tmp2;
                        ++j;
                    }
                    ++i2;
                }
                for (i2 = 0; i2 < j; ++i2) {
                    arrayV[arrayI[k + i2]] = k + j - 1;
                }
                if (j != 1) continue;
                arrayI[k] = -1;
            }
            return;
        }
        int x = arrayV[arrayI[start + len / 2] + h];
        int jj = 0;
        int kk = 0;
        for (i = start; i < start + len; ++i) {
            if (arrayV[arrayI[i] + h] < x) {
                ++jj;
            }
            if (arrayV[arrayI[i] + h] != x) continue;
            ++kk;
        }
        kk += (jj += start);
        i = start;
        int j = 0;
        int k = 0;
        while (i < jj) {
            if (arrayV[arrayI[i] + h] < x) {
                ++i;
                continue;
            }
            if (arrayV[arrayI[i] + h] == x) {
                tmp = arrayI[i];
                arrayI[i] = arrayI[jj + j];
                arrayI[jj + j] = tmp;
                ++j;
                continue;
            }
            tmp = arrayI[i];
            arrayI[i] = arrayI[kk + k];
            arrayI[kk + k] = tmp;
            ++k;
        }
        while (jj + j < kk) {
            if (arrayV[arrayI[jj + j] + h] == x) {
                ++j;
                continue;
            }
            tmp = arrayI[jj + j];
            arrayI[jj + j] = arrayI[kk + k];
            arrayI[kk + k] = tmp;
            ++k;
        }
        if (jj > start) {
            BSDiff.split(arrayI, arrayV, start, jj - start, h);
        }
        for (i = 0; i < kk - jj; ++i) {
            arrayV[arrayI[jj + i]] = kk - 1;
        }
        if (jj == kk - 1) {
            arrayI[jj] = -1;
        }
        if (start + len > kk) {
            BSDiff.split(arrayI, arrayV, kk, start + len - kk, h);
        }
    }

    private static void qsufsort(int[] arrayI, int[] arrayV, byte[] oldBuf, int oldsize) {
        int i;
        int[] buckets = new int[256];
        for (i = 0; i < oldsize; ++i) {
            int n = oldBuf[i] & 0xFF;
            buckets[n] = buckets[n] + 1;
        }
        for (i = 1; i < 256; ++i) {
            int n = i;
            buckets[n] = buckets[n] + buckets[i - 1];
        }
        for (i = 255; i > 0; --i) {
            buckets[i] = buckets[i - 1];
        }
        buckets[0] = 0;
        i = 0;
        while (i < oldsize) {
            int n = oldBuf[i] & 0xFF;
            int n2 = buckets[n] + 1;
            buckets[n] = n2;
            arrayI[n2] = i++;
        }
        arrayI[0] = oldsize;
        for (i = 0; i < oldsize; ++i) {
            arrayV[i] = buckets[oldBuf[i] & 0xFF];
        }
        arrayV[oldsize] = 0;
        for (i = 1; i < 256; ++i) {
            if (buckets[i] != buckets[i - 1] + 1) continue;
            arrayI[buckets[i]] = -1;
        }
        arrayI[0] = -1;
        int h = 1;
        while (arrayI[0] != -(oldsize + 1)) {
            int len = 0;
            int i2 = 0;
            while (i2 < oldsize + 1) {
                if (arrayI[i2] < 0) {
                    len -= arrayI[i2];
                    i2 -= arrayI[i2];
                    continue;
                }
                if (len != 0) {
                    arrayI[i2 - len] = -len;
                }
                len = arrayV[arrayI[i2]] + 1 - i2;
                BSDiff.split(arrayI, arrayV, i2, len, h);
                i2 += len;
                len = 0;
            }
            if (len != 0) {
                arrayI[i2 - len] = -len;
            }
            h += h;
        }
        for (i = 0; i < oldsize + 1; ++i) {
            arrayI[arrayV[i]] = i;
        }
    }

    private static int search(int[] arrayI, byte[] oldBuf, int oldSize, byte[] newBuf, int newSize, int newBufOffset, int start, int end, IntByRef pos) {
        if (end - start < 2) {
            int y;
            int x = BSDiff.matchlen(oldBuf, oldSize, arrayI[start], newBuf, newSize, newBufOffset);
            if (x > (y = BSDiff.matchlen(oldBuf, oldSize, arrayI[end], newBuf, newSize, newBufOffset))) {
                pos.value = arrayI[start];
                return x;
            }
            pos.value = arrayI[end];
            return y;
        }
        int x = start + (end - start) / 2;
        if (BSDiff.memcmp(oldBuf, oldSize, arrayI[x], newBuf, newSize, newBufOffset) < 0) {
            return BSDiff.search(arrayI, oldBuf, oldSize, newBuf, newSize, newBufOffset, x, end, pos);
        }
        return BSDiff.search(arrayI, oldBuf, oldSize, newBuf, newSize, newBufOffset, start, x, pos);
    }

    private static int matchlen(byte[] oldBuf, int oldSize, int oldOffset, byte[] newBuf, int newSize, int newOffset) {
        int end = Math.min(oldSize - oldOffset, newSize - newOffset);
        for (int i = 0; i < end; ++i) {
            if (oldBuf[oldOffset + i] == newBuf[newOffset + i]) continue;
            return i;
        }
        return end;
    }

    private static int memcmp(byte[] s1, int s1Size, int s1offset, byte[] s2, int s2Size, int s2offset) {
        int n = s1Size - s1offset;
        if (n > s2Size - s2offset) {
            n = s2Size - s2offset;
        }
        for (int i = 0; i < n; ++i) {
            if (s1[i + s1offset] == s2[i + s2offset]) continue;
            return s1[i + s1offset] < s2[i + s2offset] ? -1 : 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bsdiff(File oldFile, File newFile, File diffFile) throws IOException {
        BufferedInputStream oldInputStream = new BufferedInputStream(new FileInputStream(oldFile));
        BufferedInputStream newInputStream = new BufferedInputStream(new FileInputStream(newFile));
        try (FileOutputStream diffOutputStream = new FileOutputStream(diffFile);){
            byte[] diffBytes = BSDiff.bsdiff(oldInputStream, (int)oldFile.length(), newInputStream, (int)newFile.length());
            ((OutputStream)diffOutputStream).write(diffBytes);
        }
    }

    public static byte[] bsdiff(InputStream oldInputStream, int oldsize, InputStream newInputStream, int newsize) throws IOException {
        byte[] oldBuf = new byte[oldsize];
        BSUtil.readFromStream(oldInputStream, oldBuf, 0, oldsize);
        oldInputStream.close();
        byte[] newBuf = new byte[newsize];
        BSUtil.readFromStream(newInputStream, newBuf, 0, newsize);
        newInputStream.close();
        return BSDiff.bsdiff(oldBuf, oldsize, newBuf, newsize);
    }

    public static byte[] bsdiff(byte[] oldBuf, int oldsize, byte[] newBuf, int newsize) throws IOException {
        int[] arrayI = new int[oldsize + 1];
        BSDiff.qsufsort(arrayI, new int[oldsize + 1], oldBuf, oldsize);
        int diffBLockLen = 0;
        byte[] diffBlock = new byte[newsize];
        int extraBlockLen = 0;
        byte[] extraBlock = new byte[newsize];
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream diffOut = new DataOutputStream(byteOut);
        diffOut.write(MAGIC_BYTES);
        diffOut.writeLong(-1L);
        diffOut.writeLong(-1L);
        diffOut.writeLong(newsize);
        diffOut.flush();
        GZIPOutputStream bzip2Out = new GZIPOutputStream(diffOut);
        DataOutputStream dataOut = new DataOutputStream(bzip2Out);
        int scan = 0;
        int matchLen = 0;
        int lastscan = 0;
        int lastpos = 0;
        int lastoffset = 0;
        IntByRef pos = new IntByRef();
        while (scan < newsize) {
            int oldscore = 0;
            int scsc = scan += matchLen;
            while (scan < newsize) {
                matchLen = BSDiff.search(arrayI, oldBuf, oldsize, newBuf, newsize, scan, 0, oldsize, pos);
                while (scsc < scan + matchLen) {
                    if (scsc + lastoffset < oldsize && oldBuf[scsc + lastoffset] == newBuf[scsc]) {
                        ++oldscore;
                    }
                    ++scsc;
                }
                if (matchLen == oldscore && matchLen != 0 || matchLen > oldscore + 8) break;
                if (scan + lastoffset < oldsize && oldBuf[scan + lastoffset] == newBuf[scan]) {
                    --oldscore;
                }
                ++scan;
            }
            if (matchLen == oldscore && scan != newsize) continue;
            int equalNum = 0;
            int sf = 0;
            int lenFromOld = 0;
            int i = 0;
            while (lastscan + i < scan && lastpos + i < oldsize) {
                if (oldBuf[lastpos + i] == newBuf[lastscan + i]) {
                    ++equalNum;
                }
                if (equalNum * 2 - ++i <= sf * 2 - lenFromOld) continue;
                sf = equalNum;
                lenFromOld = i;
            }
            int lenb = 0;
            if (scan < newsize) {
                equalNum = 0;
                int sb = 0;
                for (i = 1; scan >= lastscan + i && pos.value >= i; ++i) {
                    if (oldBuf[pos.value - i] == newBuf[scan - i]) {
                        ++equalNum;
                    }
                    if (equalNum * 2 - i <= sb * 2 - lenb) continue;
                    sb = equalNum;
                    lenb = i;
                }
            }
            if (lastscan + lenFromOld > scan - lenb) {
                int overlap = lastscan + lenFromOld - (scan - lenb);
                equalNum = 0;
                int ss = 0;
                int lens = 0;
                for (i = 0; i < overlap; ++i) {
                    if (newBuf[lastscan + lenFromOld - overlap + i] == oldBuf[lastpos + lenFromOld - overlap + i]) {
                        ++equalNum;
                    }
                    if (newBuf[scan - lenb + i] == oldBuf[pos.value - lenb + i]) {
                        --equalNum;
                    }
                    if (equalNum <= ss) continue;
                    ss = equalNum;
                    lens = i + 1;
                }
                lenFromOld += lens - overlap;
                lenb -= lens;
            }
            for (i = 0; i < lenFromOld; ++i) {
                diffBlock[diffBLockLen + i] = (byte)(newBuf[lastscan + i] - oldBuf[lastpos + i]);
            }
            for (i = 0; i < scan - lenb - (lastscan + lenFromOld); ++i) {
                extraBlock[extraBlockLen + i] = newBuf[lastscan + lenFromOld + i];
            }
            diffBLockLen += lenFromOld;
            extraBlockLen += scan - lenb - (lastscan + lenFromOld);
            dataOut.writeInt(lenFromOld);
            dataOut.writeInt(scan - lenb - (lastscan + lenFromOld));
            dataOut.writeInt(pos.value - lenb - (lastpos + lenFromOld));
            lastscan = scan - lenb;
            lastpos = pos.value - lenb;
            lastoffset = pos.value - scan;
        }
        dataOut.flush();
        bzip2Out.finish();
        int ctrlBlockLen = diffOut.size() - 32;
        bzip2Out = new GZIPOutputStream(diffOut);
        bzip2Out.write(diffBlock, 0, diffBLockLen);
        bzip2Out.finish();
        bzip2Out.flush();
        int diffBlockLen = diffOut.size() - ctrlBlockLen - 32;
        bzip2Out = new GZIPOutputStream(diffOut);
        bzip2Out.write(extraBlock, 0, extraBlockLen);
        bzip2Out.finish();
        bzip2Out.flush();
        diffOut.close();
        ByteArrayOutputStream byteHeaderOut = new ByteArrayOutputStream(32);
        DataOutputStream headerOut = new DataOutputStream(byteHeaderOut);
        headerOut.write(MAGIC_BYTES);
        headerOut.writeLong(ctrlBlockLen);
        headerOut.writeLong(diffBlockLen);
        headerOut.writeLong(newsize);
        headerOut.close();
        byte[] diffBytes = byteOut.toByteArray();
        byte[] headerBytes = byteHeaderOut.toByteArray();
        System.arraycopy(headerBytes, 0, diffBytes, 0, headerBytes.length);
        return diffBytes;
    }

    private static class IntByRef {
        private int value;

        private IntByRef() {
        }
    }
}

