/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dx.util;

import com.tencent.tinker.android.dex.Annotation;
import com.tencent.tinker.android.dex.AnnotationSet;
import com.tencent.tinker.android.dex.AnnotationSetRefList;
import com.tencent.tinker.android.dex.AnnotationsDirectory;
import com.tencent.tinker.android.dex.ClassData;
import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Code;
import com.tencent.tinker.android.dex.DebugInfoItem;
import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dex.EncodedValue;
import com.tencent.tinker.android.dex.EncodedValueCodec;
import com.tencent.tinker.android.dex.EncodedValueReader;
import com.tencent.tinker.android.dex.FieldId;
import com.tencent.tinker.android.dex.Leb128;
import com.tencent.tinker.android.dex.MethodId;
import com.tencent.tinker.android.dex.ProtoId;
import com.tencent.tinker.android.dex.TypeList;
import com.tencent.tinker.android.dex.util.ByteInput;
import com.tencent.tinker.android.dex.util.ByteOutput;
import com.tencent.tinker.android.dx.util.InstructionTransformer;
import com.tencent.tinker.android.utils.SparseIntArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.BitSet;

public class IndexMap {
    private final SparseIntArray stringIdsMap = new SparseIntArray();
    private final SparseIntArray typeIdsMap = new SparseIntArray();
    private final SparseIntArray protoIdsMap = new SparseIntArray();
    private final SparseIntArray fieldIdsMap = new SparseIntArray();
    private final SparseIntArray methodIdsMap = new SparseIntArray();
    private final SparseIntArray typeListOffsetsMap = new SparseIntArray();
    private final SparseIntArray annotationOffsetsMap = new SparseIntArray();
    private final SparseIntArray annotationSetOffsetsMap = new SparseIntArray();
    private final SparseIntArray annotationSetRefListOffsetsMap = new SparseIntArray();
    private final SparseIntArray annotationsDirectoryOffsetsMap = new SparseIntArray();
    private final SparseIntArray staticValuesOffsetsMap = new SparseIntArray();
    private final SparseIntArray classDataOffsetsMap = new SparseIntArray();
    private final SparseIntArray debugInfoItemOffsetsMap = new SparseIntArray();
    private final SparseIntArray codeOffsetsMap = new SparseIntArray();
    private final BitSet deletedStringIds = new BitSet();
    private final BitSet deletedTypeIds = new BitSet();
    private final BitSet deletedProtoIds = new BitSet();
    private final BitSet deletedFieldIds = new BitSet();
    private final BitSet deletedMethodIds = new BitSet();
    private final BitSet deletedTypeListOffsets = new BitSet();
    private final BitSet deletedAnnotationOffsets = new BitSet();
    private final BitSet deletedAnnotationSetOffsets = new BitSet();
    private final BitSet deletedAnnotationSetRefListOffsets = new BitSet();
    private final BitSet deletedAnnotationsDirectoryOffsets = new BitSet();
    private final BitSet deletedStaticValuesOffsets = new BitSet();
    private final BitSet deletedClassDataOffsets = new BitSet();
    private final BitSet deletedDebugInfoItemOffsets = new BitSet();
    private final BitSet deletedCodeOffsets = new BitSet();

    public void mapStringIds(int oldIndex, int newIndex) {
        this.stringIdsMap.put(oldIndex, newIndex);
    }

    public void markStringIdDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedStringIds.set(index);
    }

    public void mapTypeIds(int oldIndex, int newIndex) {
        this.typeIdsMap.put(oldIndex, newIndex);
    }

    public void markTypeIdDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedTypeIds.set(index);
    }

    public void mapProtoIds(int oldIndex, int newIndex) {
        this.protoIdsMap.put(oldIndex, newIndex);
    }

    public void markProtoIdDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedProtoIds.set(index);
    }

    public void mapFieldIds(int oldIndex, int newIndex) {
        this.fieldIdsMap.put(oldIndex, newIndex);
    }

    public void markFieldIdDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedFieldIds.set(index);
    }

    public void mapMethodIds(int oldIndex, int newIndex) {
        this.methodIdsMap.put(oldIndex, newIndex);
    }

    public void markMethodIdDeleted(int index) {
        if (index < 0) {
            return;
        }
        this.deletedMethodIds.set(index);
    }

    public void mapTypeListOffset(int oldOffset, int newOffset) {
        this.typeListOffsetsMap.put(oldOffset, newOffset);
    }

    public void markTypeListDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedTypeListOffsets.set(offset);
    }

    public void mapAnnotationOffset(int oldOffset, int newOffset) {
        this.annotationOffsetsMap.put(oldOffset, newOffset);
    }

    public void markAnnotationDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedAnnotationOffsets.set(offset);
    }

    public void mapAnnotationSetOffset(int oldOffset, int newOffset) {
        this.annotationSetOffsetsMap.put(oldOffset, newOffset);
    }

    public void markAnnotationSetDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedAnnotationSetOffsets.set(offset);
    }

    public void mapAnnotationSetRefListOffset(int oldOffset, int newOffset) {
        this.annotationSetRefListOffsetsMap.put(oldOffset, newOffset);
    }

    public void markAnnotationSetRefListDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedAnnotationSetRefListOffsets.set(offset);
    }

    public void mapAnnotationsDirectoryOffset(int oldOffset, int newOffset) {
        this.annotationsDirectoryOffsetsMap.put(oldOffset, newOffset);
    }

    public void markAnnotationsDirectoryDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedAnnotationsDirectoryOffsets.set(offset);
    }

    public void mapStaticValuesOffset(int oldOffset, int newOffset) {
        this.staticValuesOffsetsMap.put(oldOffset, newOffset);
    }

    public void markStaticValuesDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedStaticValuesOffsets.set(offset);
    }

    public void mapClassDataOffset(int oldOffset, int newOffset) {
        this.classDataOffsetsMap.put(oldOffset, newOffset);
    }

    public void markClassDataDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedClassDataOffsets.set(offset);
    }

    public void mapDebugInfoItemOffset(int oldOffset, int newOffset) {
        this.debugInfoItemOffsetsMap.put(oldOffset, newOffset);
    }

    public void markDebugInfoItemDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedDebugInfoItemOffsets.set(offset);
    }

    public void mapCodeOffset(int oldOffset, int newOffset) {
        this.codeOffsetsMap.put(oldOffset, newOffset);
    }

    public void markCodeDeleted(int offset) {
        if (offset < 0) {
            return;
        }
        this.deletedCodeOffsets.set(offset);
    }

    public int adjustStringIndex(int stringIndex) {
        int index = this.stringIdsMap.indexOfKey(stringIndex);
        if (index < 0) {
            return stringIndex >= 0 && this.deletedStringIds.get(stringIndex) ? -1 : stringIndex;
        }
        return this.stringIdsMap.valueAt(index);
    }

    public int adjustTypeIdIndex(int typeIdIndex) {
        int index = this.typeIdsMap.indexOfKey(typeIdIndex);
        if (index < 0) {
            return typeIdIndex >= 0 && this.deletedTypeIds.get(typeIdIndex) ? -1 : typeIdIndex;
        }
        return this.typeIdsMap.valueAt(index);
    }

    public int adjustProtoIdIndex(int protoIndex) {
        int index = this.protoIdsMap.indexOfKey(protoIndex);
        if (index < 0) {
            return protoIndex >= 0 && this.deletedProtoIds.get(protoIndex) ? -1 : protoIndex;
        }
        return this.protoIdsMap.valueAt(index);
    }

    public int adjustFieldIdIndex(int fieldIndex) {
        int index = this.fieldIdsMap.indexOfKey(fieldIndex);
        if (index < 0) {
            return fieldIndex >= 0 && this.deletedFieldIds.get(fieldIndex) ? -1 : fieldIndex;
        }
        return this.fieldIdsMap.valueAt(index);
    }

    public int adjustMethodIdIndex(int methodIndex) {
        int index = this.methodIdsMap.indexOfKey(methodIndex);
        if (index < 0) {
            return methodIndex >= 0 && this.deletedMethodIds.get(methodIndex) ? -1 : methodIndex;
        }
        return this.methodIdsMap.valueAt(index);
    }

    public int adjustTypeListOffset(int typeListOffset) {
        int index = this.typeListOffsetsMap.indexOfKey(typeListOffset);
        if (index < 0) {
            return typeListOffset >= 0 && this.deletedTypeListOffsets.get(typeListOffset) ? -1 : typeListOffset;
        }
        return this.typeListOffsetsMap.valueAt(index);
    }

    public int adjustAnnotationOffset(int annotationOffset) {
        int index = this.annotationOffsetsMap.indexOfKey(annotationOffset);
        if (index < 0) {
            return annotationOffset >= 0 && this.deletedAnnotationOffsets.get(annotationOffset) ? -1 : annotationOffset;
        }
        return this.annotationOffsetsMap.valueAt(index);
    }

    public int adjustAnnotationSetOffset(int annotationSetOffset) {
        int index = this.annotationSetOffsetsMap.indexOfKey(annotationSetOffset);
        if (index < 0) {
            return annotationSetOffset >= 0 && this.deletedAnnotationSetOffsets.get(annotationSetOffset) ? -1 : annotationSetOffset;
        }
        return this.annotationSetOffsetsMap.valueAt(index);
    }

    public int adjustAnnotationSetRefListOffset(int annotationSetRefListOffset) {
        int index = this.annotationSetRefListOffsetsMap.indexOfKey(annotationSetRefListOffset);
        if (index < 0) {
            return annotationSetRefListOffset >= 0 && this.deletedAnnotationSetRefListOffsets.get(annotationSetRefListOffset) ? -1 : annotationSetRefListOffset;
        }
        return this.annotationSetRefListOffsetsMap.valueAt(index);
    }

    public int adjustAnnotationsDirectoryOffset(int annotationsDirectoryOffset) {
        int index = this.annotationsDirectoryOffsetsMap.indexOfKey(annotationsDirectoryOffset);
        if (index < 0) {
            return annotationsDirectoryOffset >= 0 && this.deletedAnnotationsDirectoryOffsets.get(annotationsDirectoryOffset) ? -1 : annotationsDirectoryOffset;
        }
        return this.annotationsDirectoryOffsetsMap.valueAt(index);
    }

    public int adjustStaticValuesOffset(int staticValuesOffset) {
        int index = this.staticValuesOffsetsMap.indexOfKey(staticValuesOffset);
        if (index < 0) {
            return staticValuesOffset >= 0 && this.deletedStaticValuesOffsets.get(staticValuesOffset) ? -1 : staticValuesOffset;
        }
        return this.staticValuesOffsetsMap.valueAt(index);
    }

    public int adjustClassDataOffset(int classDataOffset) {
        int index = this.classDataOffsetsMap.indexOfKey(classDataOffset);
        if (index < 0) {
            return classDataOffset >= 0 && this.deletedClassDataOffsets.get(classDataOffset) ? -1 : classDataOffset;
        }
        return this.classDataOffsetsMap.valueAt(index);
    }

    public int adjustDebugInfoItemOffset(int debugInfoItemOffset) {
        int index = this.debugInfoItemOffsetsMap.indexOfKey(debugInfoItemOffset);
        if (index < 0) {
            return debugInfoItemOffset >= 0 && this.deletedDebugInfoItemOffsets.get(debugInfoItemOffset) ? -1 : debugInfoItemOffset;
        }
        return this.debugInfoItemOffsetsMap.valueAt(index);
    }

    public int adjustCodeOffset(int codeOffset) {
        int index = this.codeOffsetsMap.indexOfKey(codeOffset);
        if (index < 0) {
            return codeOffset >= 0 && this.deletedCodeOffsets.get(codeOffset) ? -1 : codeOffset;
        }
        return this.codeOffsetsMap.valueAt(index);
    }

    public TypeList adjust(TypeList typeList) {
        if (typeList == TypeList.EMPTY) {
            return typeList;
        }
        short[] types = new short[typeList.types.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = (short)this.adjustTypeIdIndex(typeList.types[i]);
        }
        return new TypeList(typeList.off, types);
    }

    public MethodId adjust(MethodId methodId) {
        int adjustedDeclaringClassIndex = this.adjustTypeIdIndex(methodId.declaringClassIndex);
        int adjustedProtoIndex = this.adjustProtoIdIndex(methodId.protoIndex);
        int adjustedNameIndex = this.adjustStringIndex(methodId.nameIndex);
        return new MethodId(methodId.off, adjustedDeclaringClassIndex, adjustedProtoIndex, adjustedNameIndex);
    }

    public FieldId adjust(FieldId fieldId) {
        int adjustedDeclaringClassIndex = this.adjustTypeIdIndex(fieldId.declaringClassIndex);
        int adjustedTypeIndex = this.adjustTypeIdIndex(fieldId.typeIndex);
        int adjustedNameIndex = this.adjustStringIndex(fieldId.nameIndex);
        return new FieldId(fieldId.off, adjustedDeclaringClassIndex, adjustedTypeIndex, adjustedNameIndex);
    }

    public ProtoId adjust(ProtoId protoId) {
        int adjustedShortyIndex = this.adjustStringIndex(protoId.shortyIndex);
        int adjustedReturnTypeIndex = this.adjustTypeIdIndex(protoId.returnTypeIndex);
        int adjustedParametersOffset = this.adjustTypeListOffset(protoId.parametersOffset);
        return new ProtoId(protoId.off, adjustedShortyIndex, adjustedReturnTypeIndex, adjustedParametersOffset);
    }

    public ClassDef adjust(ClassDef classDef) {
        int adjustedTypeIndex = this.adjustTypeIdIndex(classDef.typeIndex);
        int adjustedSupertypeIndex = this.adjustTypeIdIndex(classDef.supertypeIndex);
        int adjustedInterfacesOffset = this.adjustTypeListOffset(classDef.interfacesOffset);
        int adjustedSourceFileIndex = this.adjustStringIndex(classDef.sourceFileIndex);
        int adjustedAnnotationsOffset = this.adjustAnnotationsDirectoryOffset(classDef.annotationsOffset);
        int adjustedClassDataOffset = this.adjustClassDataOffset(classDef.classDataOffset);
        int adjustedStaticValuesOffset = this.adjustStaticValuesOffset(classDef.staticValuesOffset);
        return new ClassDef(classDef.off, adjustedTypeIndex, classDef.accessFlags, adjustedSupertypeIndex, adjustedInterfacesOffset, adjustedSourceFileIndex, adjustedAnnotationsOffset, adjustedClassDataOffset, adjustedStaticValuesOffset);
    }

    public ClassData adjust(ClassData classData) {
        ClassData.Field[] adjustedStaticFields = this.adjustFields(classData.staticFields);
        ClassData.Field[] adjustedInstanceFields = this.adjustFields(classData.instanceFields);
        ClassData.Method[] adjustedDirectMethods = this.adjustMethods(classData.directMethods);
        ClassData.Method[] adjustedVirtualMethods = this.adjustMethods(classData.virtualMethods);
        return new ClassData(classData.off, adjustedStaticFields, adjustedInstanceFields, adjustedDirectMethods, adjustedVirtualMethods);
    }

    public Code adjust(Code code) {
        int adjustedDebugInfoOffset = this.adjustDebugInfoItemOffset(code.debugInfoOffset);
        short[] adjustedInstructions = this.adjustInstructions(code.instructions);
        Code.CatchHandler[] adjustedCatchHandlers = this.adjustCatchHandlers(code.catchHandlers);
        return new Code(code.off, code.registersSize, code.insSize, code.outsSize, adjustedDebugInfoOffset, adjustedInstructions, code.tries, adjustedCatchHandlers);
    }

    private short[] adjustInstructions(short[] instructions) {
        if (instructions == null || instructions.length == 0) {
            return instructions;
        }
        InstructionTransformer insTrans = new InstructionTransformer(this);
        return insTrans.transform(instructions);
    }

    private Code.CatchHandler[] adjustCatchHandlers(Code.CatchHandler[] catchHandlers) {
        if (catchHandlers == null || catchHandlers.length == 0) {
            return catchHandlers;
        }
        Code.CatchHandler[] adjustedCatchHandlers = new Code.CatchHandler[catchHandlers.length];
        for (int i = 0; i < catchHandlers.length; ++i) {
            Code.CatchHandler catchHandler = catchHandlers[i];
            int typeIndexesCount = catchHandler.typeIndexes.length;
            int[] adjustedTypeIndexes = new int[typeIndexesCount];
            for (int j = 0; j < typeIndexesCount; ++j) {
                adjustedTypeIndexes[j] = this.adjustTypeIdIndex(catchHandler.typeIndexes[j]);
            }
            adjustedCatchHandlers[i] = new Code.CatchHandler(adjustedTypeIndexes, catchHandler.addresses, catchHandler.catchAllAddress, catchHandler.offset);
        }
        return adjustedCatchHandlers;
    }

    private ClassData.Field[] adjustFields(ClassData.Field[] fields) {
        ClassData.Field[] adjustedFields = new ClassData.Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ClassData.Field field = fields[i];
            int adjustedFieldIndex = this.adjustFieldIdIndex(field.fieldIndex);
            adjustedFields[i] = new ClassData.Field(adjustedFieldIndex, field.accessFlags);
        }
        return adjustedFields;
    }

    private ClassData.Method[] adjustMethods(ClassData.Method[] methods) {
        ClassData.Method[] adjustedMethods = new ClassData.Method[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            ClassData.Method method = methods[i];
            int adjustedMethodIndex = this.adjustMethodIdIndex(method.methodIndex);
            int adjustedCodeOffset = this.adjustCodeOffset(method.codeOffset);
            adjustedMethods[i] = new ClassData.Method(adjustedMethodIndex, method.accessFlags, adjustedCodeOffset);
        }
        return adjustedMethods;
    }

    public DebugInfoItem adjust(DebugInfoItem debugInfoItem) {
        int[] parameterNames = this.adjustParameterNames(debugInfoItem.parameterNames);
        byte[] infoSTM = this.adjustDebugInfoItemSTM(debugInfoItem.infoSTM);
        return new DebugInfoItem(debugInfoItem.off, debugInfoItem.lineStart, parameterNames, infoSTM);
    }

    private int[] adjustParameterNames(int[] parameterNames) {
        int size = parameterNames.length;
        int[] adjustedParameterNames = new int[size];
        for (int i = 0; i < size; ++i) {
            adjustedParameterNames[i] = this.adjustStringIndex(parameterNames[i]);
        }
        return adjustedParameterNames;
    }

    /*
     * Enabled aggressive block sorting
     */
    private byte[] adjustDebugInfoItemSTM(byte[] infoSTM) {
        ByteArrayOutputStream baos;
        ByteArrayInputStream bais;
        final ByteArrayInputStream baisRef = bais = new ByteArrayInputStream(infoSTM);
        ByteInput inAdapter = new ByteInput(){

            @Override
            public byte readByte() {
                return (byte)(baisRef.read() & 0xFF);
            }
        };
        final ByteArrayOutputStream baosRef = baos = new ByteArrayOutputStream(infoSTM.length + 512);
        ByteOutput outAdapter = new ByteOutput(){

            @Override
            public void writeByte(int i) {
                baosRef.write(i);
            }
        };
        while (true) {
            int opcode = bais.read() & 0xFF;
            baos.write(opcode);
            switch (opcode) {
                case 0: {
                    return baos.toByteArray();
                }
                case 1: {
                    int addrDiff = Leb128.readUnsignedLeb128(inAdapter);
                    Leb128.writeUnsignedLeb128(outAdapter, addrDiff);
                    break;
                }
                case 2: {
                    int lineDiff = Leb128.readSignedLeb128(inAdapter);
                    Leb128.writeSignedLeb128(outAdapter, lineDiff);
                    break;
                }
                case 3: 
                case 4: {
                    int registerNum = Leb128.readUnsignedLeb128(inAdapter);
                    Leb128.writeUnsignedLeb128(outAdapter, registerNum);
                    int nameIndex = this.adjustStringIndex(Leb128.readUnsignedLeb128p1(inAdapter));
                    Leb128.writeUnsignedLeb128p1(outAdapter, nameIndex);
                    int typeIndex = this.adjustTypeIdIndex(Leb128.readUnsignedLeb128p1(inAdapter));
                    Leb128.writeUnsignedLeb128p1(outAdapter, typeIndex);
                    if (opcode != 4) break;
                    int sigIndex = this.adjustStringIndex(Leb128.readUnsignedLeb128p1(inAdapter));
                    Leb128.writeUnsignedLeb128p1(outAdapter, sigIndex);
                    break;
                }
                case 5: 
                case 6: {
                    int registerNum = Leb128.readUnsignedLeb128(inAdapter);
                    Leb128.writeUnsignedLeb128(outAdapter, registerNum);
                    break;
                }
                case 9: {
                    int nameIndex = this.adjustStringIndex(Leb128.readUnsignedLeb128p1(inAdapter));
                    Leb128.writeUnsignedLeb128p1(outAdapter, nameIndex);
                }
            }
        }
    }

    public EncodedValue adjust(EncodedValue encodedArray) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(encodedArray.data.length);
        new EncodedValueTransformer(new ByteOutput(){

            @Override
            public void writeByte(int i) {
                baos.write(i);
            }
        }).transformArray(new EncodedValueReader(encodedArray, 28));
        return new EncodedValue(encodedArray.off, baos.toByteArray());
    }

    public Annotation adjust(Annotation annotation) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(annotation.encodedAnnotation.data.length);
        new EncodedValueTransformer(new ByteOutput(){

            @Override
            public void writeByte(int i) {
                baos.write(i);
            }
        }).transformAnnotation(annotation.getReader());
        return new Annotation(annotation.off, annotation.visibility, new EncodedValue(annotation.encodedAnnotation.off, baos.toByteArray()));
    }

    public AnnotationSet adjust(AnnotationSet annotationSet) {
        int size = annotationSet.annotationOffsets.length;
        int[] adjustedAnnotationOffsets = new int[size];
        for (int i = 0; i < size; ++i) {
            adjustedAnnotationOffsets[i] = this.adjustAnnotationOffset(annotationSet.annotationOffsets[i]);
        }
        return new AnnotationSet(annotationSet.off, adjustedAnnotationOffsets);
    }

    public AnnotationSetRefList adjust(AnnotationSetRefList annotationSetRefList) {
        int size = annotationSetRefList.annotationSetRefItems.length;
        int[] adjustedAnnotationSetRefItems = new int[size];
        for (int i = 0; i < size; ++i) {
            adjustedAnnotationSetRefItems[i] = this.adjustAnnotationSetOffset(annotationSetRefList.annotationSetRefItems[i]);
        }
        return new AnnotationSetRefList(annotationSetRefList.off, adjustedAnnotationSetRefItems);
    }

    public AnnotationsDirectory adjust(AnnotationsDirectory annotationsDirectory) {
        int adjustedClassAnnotationsOffset = this.adjustAnnotationSetOffset(annotationsDirectory.classAnnotationsOffset);
        int[][] adjustedFieldAnnotations = new int[annotationsDirectory.fieldAnnotations.length][2];
        for (int i = 0; i < adjustedFieldAnnotations.length; ++i) {
            adjustedFieldAnnotations[i][0] = this.adjustFieldIdIndex(annotationsDirectory.fieldAnnotations[i][0]);
            adjustedFieldAnnotations[i][1] = this.adjustAnnotationSetOffset(annotationsDirectory.fieldAnnotations[i][1]);
        }
        int[][] adjustedMethodAnnotations = new int[annotationsDirectory.methodAnnotations.length][2];
        for (int i = 0; i < adjustedMethodAnnotations.length; ++i) {
            adjustedMethodAnnotations[i][0] = this.adjustMethodIdIndex(annotationsDirectory.methodAnnotations[i][0]);
            adjustedMethodAnnotations[i][1] = this.adjustAnnotationSetOffset(annotationsDirectory.methodAnnotations[i][1]);
        }
        int[][] adjustedParameterAnnotations = new int[annotationsDirectory.parameterAnnotations.length][2];
        for (int i = 0; i < adjustedParameterAnnotations.length; ++i) {
            adjustedParameterAnnotations[i][0] = this.adjustMethodIdIndex(annotationsDirectory.parameterAnnotations[i][0]);
            adjustedParameterAnnotations[i][1] = this.adjustAnnotationSetRefListOffset(annotationsDirectory.parameterAnnotations[i][1]);
        }
        return new AnnotationsDirectory(annotationsDirectory.off, adjustedClassAnnotationsOffset, adjustedFieldAnnotations, adjustedMethodAnnotations, adjustedParameterAnnotations);
    }

    private final class EncodedValueTransformer {
        private final ByteOutput out;

        EncodedValueTransformer(ByteOutput out) {
            this.out = out;
        }

        public void transform(EncodedValueReader reader) {
            switch (reader.peek()) {
                case 0: {
                    EncodedValueCodec.writeSignedIntegralValue(this.out, 0, reader.readByte());
                    break;
                }
                case 2: {
                    EncodedValueCodec.writeSignedIntegralValue(this.out, 2, reader.readShort());
                    break;
                }
                case 4: {
                    EncodedValueCodec.writeSignedIntegralValue(this.out, 4, reader.readInt());
                    break;
                }
                case 6: {
                    EncodedValueCodec.writeSignedIntegralValue(this.out, 6, reader.readLong());
                    break;
                }
                case 3: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 3, reader.readChar());
                    break;
                }
                case 16: {
                    long longBits = (long)Float.floatToIntBits(reader.readFloat()) << 32;
                    EncodedValueCodec.writeRightZeroExtendedValue(this.out, 16, longBits);
                    break;
                }
                case 17: {
                    EncodedValueCodec.writeRightZeroExtendedValue(this.out, 17, Double.doubleToLongBits(reader.readDouble()));
                    break;
                }
                case 23: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 23, IndexMap.this.adjustStringIndex(reader.readString()));
                    break;
                }
                case 24: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 24, IndexMap.this.adjustTypeIdIndex(reader.readType()));
                    break;
                }
                case 25: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 25, IndexMap.this.adjustFieldIdIndex(reader.readField()));
                    break;
                }
                case 27: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 27, IndexMap.this.adjustFieldIdIndex(reader.readEnum()));
                    break;
                }
                case 26: {
                    EncodedValueCodec.writeUnsignedIntegralValue(this.out, 26, IndexMap.this.adjustMethodIdIndex(reader.readMethod()));
                    break;
                }
                case 28: {
                    this.writeTypeAndArg(28, 0);
                    this.transformArray(reader);
                    break;
                }
                case 29: {
                    this.writeTypeAndArg(29, 0);
                    this.transformAnnotation(reader);
                    break;
                }
                case 30: {
                    reader.readNull();
                    this.writeTypeAndArg(30, 0);
                    break;
                }
                case 31: {
                    boolean value = reader.readBoolean();
                    this.writeTypeAndArg(31, value ? 1 : 0);
                    break;
                }
                default: {
                    throw new DexException("Unexpected type: " + Integer.toHexString(reader.peek()));
                }
            }
        }

        private void transformAnnotation(EncodedValueReader reader) {
            int fieldCount = reader.readAnnotation();
            Leb128.writeUnsignedLeb128(this.out, IndexMap.this.adjustTypeIdIndex(reader.getAnnotationType()));
            Leb128.writeUnsignedLeb128(this.out, fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                Leb128.writeUnsignedLeb128(this.out, IndexMap.this.adjustStringIndex(reader.readAnnotationName()));
                this.transform(reader);
            }
        }

        private void transformArray(EncodedValueReader reader) {
            int size = reader.readArray();
            Leb128.writeUnsignedLeb128(this.out, size);
            for (int i = 0; i < size; ++i) {
                this.transform(reader);
            }
        }

        private void writeTypeAndArg(int type, int arg) {
            this.out.writeByte(arg << 5 | type);
        }
    }
}

