/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.operator;

import com.google.common.collect.Lists;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.FragmentVisitor;
import com.samskivert.util.Tuple;
import java.util.Collection;
import java.util.List;

public class Case<T>
implements SQLExpression<T> {
    protected List<Tuple<SQLExpression<?>, SQLExpression<?>>> _whenExps = Lists.newArrayList();
    protected SQLExpression<?> _elseExp;

    public Case(SQLExpression<?> ... exps) {
        int i = 0;
        while (i + 1 < exps.length) {
            this._whenExps.add(Tuple.newTuple(exps[i], exps[i + 1]));
            i += 2;
        }
        this._elseExp = i < exps.length ? exps[i] : null;
    }

    public List<Tuple<SQLExpression<?>, SQLExpression<?>>> getWhenExps() {
        return this._whenExps;
    }

    public SQLExpression<?> getElseExp() {
        return this._elseExp;
    }

    @Override
    public Object accept(FragmentVisitor<?> builder) {
        return builder.visit(this);
    }

    @Override
    public void addClasses(Collection<Class<? extends PersistentRecord>> classSet) {
        for (Tuple<SQLExpression<?>, SQLExpression<?>> tuple : this._whenExps) {
            ((SQLExpression)tuple.left).addClasses(classSet);
            ((SQLExpression)tuple.right).addClasses(classSet);
        }
        if (this._elseExp != null) {
            this._elseExp.addClasses(classSet);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Case(");
        for (Tuple<SQLExpression<?>, SQLExpression<?>> tuple : this._whenExps) {
            builder.append(((SQLExpression)tuple.left).toString()).append("->");
            builder.append(((SQLExpression)tuple.right).toString()).append(",");
        }
        if (this._elseExp != null) {
            builder.append(this._elseExp.toString()).append(")");
        }
        return builder.toString();
    }
}

