/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.depot.CacheAdapter;
import com.samskivert.depot.CacheInvalidator;
import com.samskivert.depot.CacheKey;
import com.samskivert.depot.Key;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.Stats;
import com.samskivert.depot.impl.KeyCacheKey;
import com.samskivert.depot.impl.Operation;
import com.samskivert.depot.impl.QueryResult;
import com.samskivert.jdbc.DatabaseLiaison;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class Modifier
implements Operation<Integer> {
    protected CacheInvalidator _invalidator;

    public Modifier() {
        this(null);
    }

    public Modifier(CacheInvalidator invalidator) {
        this._invalidator = invalidator;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Integer invoke(PersistenceContext ctx, Connection conn, DatabaseLiaison liaison) throws SQLException {
        if (this._invalidator != null) {
            this._invalidator.invalidate(ctx);
        }
        return this.invoke(conn, liaison);
    }

    @Override
    public void updateStats(Stats stats) {
    }

    protected abstract int invoke(Connection var1, DatabaseLiaison var2) throws SQLException;

    public static abstract class CachingModifier<T extends PersistentRecord>
    extends Modifier {
        protected CacheKey _key;
        protected T _result;

        protected CachingModifier(T result, Key<T> key, CacheInvalidator invalidator) {
            super(invalidator);
            this._result = result;
            this._key = key == null ? null : new KeyCacheKey(key);
        }

        protected void updateKey(Key<T> key) {
            if (key != null) {
                this._key = new KeyCacheKey(key);
            }
        }

        @Override
        public Integer invoke(PersistenceContext ctx, Connection conn, DatabaseLiaison liaison) throws SQLException {
            Integer rows = super.invoke(ctx, conn, liaison);
            if (this._key != null && this._result != null) {
                ctx.cacheStore(CacheAdapter.CacheCategory.RECORD, this._key, ((QueryResult)this._result).clone());
            }
            return rows;
        }
    }

    public static abstract class Simple
    extends Modifier {
        public Simple() {
            super(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
            Statement stmt = conn.createStatement();
            try {
                int n = stmt.executeUpdate(this.createQuery(liaison));
                return n;
            }
            finally {
                stmt.close();
            }
        }

        protected abstract String createQuery(DatabaseLiaison var1);
    }
}

