/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.collect.Lists;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.Key;
import com.samskivert.depot.Log;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.Stats;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.SelectClause;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.Fetcher;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.jdbc.DatabaseLiaison;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class FindAllKeysQuery<T extends PersistentRecord>
extends Fetcher<List<Key<T>>> {
    protected boolean _forUpdate;
    protected SQLBuilder _builder;
    protected DepotMarshaller<T> _marsh;
    protected SelectClause _select;

    public FindAllKeysQuery(PersistenceContext ctx, Class<T> type, boolean forUpdate, Iterable<? extends QueryClause> clauses) throws DatabaseException {
        this._forUpdate = forUpdate;
        this._marsh = ctx.getMarshaller(type);
        this._select = new SelectClause(type, this._marsh.getPrimaryKeyFields(), clauses);
        this._builder = ctx.getSQLBuilder(DepotTypes.getDepotTypes(ctx, this._select));
        this._builder.newQuery(this._select);
    }

    @Override
    public boolean isReadOnly() {
        return !this._forUpdate;
    }

    @Override
    public List<Key<T>> getCachedResult(PersistenceContext ctx) {
        return null;
    }

    @Override
    public List<Key<T>> invoke(PersistenceContext ctx, Connection conn, DatabaseLiaison liaison) throws SQLException {
        ArrayList keys = Lists.newArrayList();
        PreparedStatement stmt = this._builder.prepare(conn);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            keys.add(this._marsh.makePrimaryKey(rs));
        }
        if (PersistenceContext.CACHE_DEBUG) {
            Log.log.info((Object)("Loaded " + this._marsh.getTableName()), new Object[]{"count", keys.size()});
        }
        return keys;
    }

    @Override
    public void updateStats(Stats stats) {
        stats.noteQuery(this._marsh.getPersistentClass(), 0, 1, 0, 0, 0);
    }
}

