/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.ValidatingCacheInvalidator;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.DepotUtil;
import com.samskivert.depot.impl.FragmentVisitor;
import com.samskivert.util.StringUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

public class Key<T extends PersistentRecord>
extends WhereClause
implements ValidatingCacheInvalidator {
    protected final Class<T> _pClass;
    protected final Comparable<?>[] _values;

    public static <T extends PersistentRecord, V extends Comparable<V>> Key<T> newKey(Class<T> pClass, ColumnExp<V> ix, V val) {
        return new Key<T>(pClass, new ColumnExp[]{ix}, new Comparable[]{val});
    }

    public static <T extends PersistentRecord, V1 extends Comparable<V1>, V2 extends Comparable<V2>> Key<T> newKey(Class<T> pClass, ColumnExp<V1> ix1, V1 val1, ColumnExp<V2> ix2, V2 val2) {
        return new Key<T>(pClass, new ColumnExp[]{ix1, ix2}, new Comparable[]{val1, val2});
    }

    public static <T extends PersistentRecord, V1 extends Comparable<V1>, V2 extends Comparable<V2>, V3 extends Comparable<V3>> Key<T> newKey(Class<T> pClass, ColumnExp<V1> ix1, V1 val1, ColumnExp<V2> ix2, V2 val2, ColumnExp<V3> ix3, V3 val3) {
        return new Key<T>(pClass, new ColumnExp[]{ix1, ix2, ix3}, new Comparable[]{val1, val2, val3});
    }

    public static <T extends PersistentRecord> Function<Key<T>, Integer> toInt() {
        return Key.extract(0);
    }

    public static <T extends PersistentRecord, E> Function<Key<T>, E> extract(final int index) {
        return new Function<Key<T>, E>(){

            public E apply(Key<T> key) {
                Comparable<?> value = key.getValues()[index];
                return value;
            }
        };
    }

    public Key(Class<T> pClass, ColumnExp<?>[] fields, Comparable<?>[] values) {
        this(pClass, Key.toCanonicalOrder(pClass, fields, values));
    }

    public Key(Class<T> pClass, Comparable<?>[] values) {
        this._pClass = pClass;
        this._values = values;
    }

    public Class<T> getPersistentClass() {
        return this._pClass;
    }

    public Comparable<?>[] getValues() {
        return this._values;
    }

    @Override
    public SQLExpression<?> getWhereExpression() {
        return new Expression(this._pClass, this._values);
    }

    @Override
    public void addClasses(Collection<Class<? extends PersistentRecord>> classSet) {
        classSet.add(this._pClass);
    }

    @Override
    public Object accept(FragmentVisitor<?> builder) {
        return builder.visit(this);
    }

    @Override
    public void validateFlushType(Class<?> pClass) {
        Preconditions.checkArgument((boolean)pClass.equals(this._pClass), (String)"Class mismatch between persistent record and cache invalidator [record=%s, invtype=%s].", (Object[])new Object[]{pClass.getSimpleName(), this._pClass.getSimpleName()});
    }

    @Override
    public void invalidate(PersistenceContext ctx) {
        ctx.cacheInvalidate(this);
    }

    public void toShortString(StringBuilder builder) {
        ColumnExp<?>[] keyFields = DepotUtil.getKeyFields(this._pClass);
        for (int ii = 0; ii < keyFields.length; ++ii) {
            if (ii > 0) {
                builder.append(":");
            }
            builder.append(keyFields[ii].name).append("=").append(this._values[ii]);
        }
    }

    @Override
    public void validateQueryType(Class<?> pClass) {
        super.validateQueryType(pClass);
        this.validateTypesMatch(pClass, this._pClass);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals(this._values, ((Key)obj)._values);
    }

    public int hashCode() {
        return Arrays.hashCode(this._values);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this._pClass.getSimpleName());
        builder.append("(");
        this.toShortString(builder);
        builder.append(")");
        return builder.toString();
    }

    protected static Comparable<?>[] toCanonicalOrder(Class<? extends PersistentRecord> pClass, ColumnExp<?>[] fields, Comparable<?>[] values) {
        Preconditions.checkArgument((fields.length == values.length ? 1 : 0) != 0, (Object)"Field and Value arrays must be of equal length.");
        ColumnExp<?>[] keyFields = DepotUtil.getKeyFields(pClass);
        if (fields.length == 1 && keyFields.length == 1 && keyFields[0].equals(fields[0])) {
            return new Comparable[]{values[0]};
        }
        HashMap map = Maps.newHashMap();
        for (int ii = 0; ii < fields.length; ++ii) {
            map.put(fields[ii], values[ii]);
        }
        Comparable[] cvalues = new Comparable[values.length];
        for (int ii = 0; ii < keyFields.length; ++ii) {
            Comparable value = (Comparable)map.remove(keyFields[ii]);
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)("Missing value for key field: " + keyFields[ii]));
            Preconditions.checkArgument((boolean)(value instanceof Serializable), (String)"Non-serializable argument [key=%s, value=%s]", (Object[])new Object[]{keyFields[ii], value});
            cvalues[ii] = value;
        }
        Preconditions.checkArgument((boolean)map.isEmpty(), (Object)("Non-key columns given: " + StringUtil.join((Object[])map.keySet().toArray())));
        return cvalues;
    }

    public static class Expression
    implements SQLExpression<Object> {
        protected Class<? extends PersistentRecord> _pClass;
        protected Comparable<?>[] _values;

        public Expression(Class<? extends PersistentRecord> pClass, Comparable<?>[] values) {
            this._pClass = pClass;
            this._values = values;
        }

        public Class<? extends PersistentRecord> getPersistentClass() {
            return this._pClass;
        }

        public Comparable<?>[] getValues() {
            return this._values;
        }

        @Override
        public Object accept(FragmentVisitor<?> builder) {
            return builder.visit(this);
        }

        @Override
        public void addClasses(Collection<Class<? extends PersistentRecord>> classSet) {
            classSet.add(this.getPersistentClass());
        }
    }
}

