/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.auditing.AuditingAudio;
import com.qcloud.cos.model.ciModel.auditing.AuditingCosOutput;
import com.qcloud.cos.model.ciModel.auditing.AuditingImage;
import com.qcloud.cos.model.ciModel.auditing.AuditingLiveOutput;
import com.qcloud.cos.model.ciModel.auditing.Conf;
import com.qcloud.cos.model.ciModel.auditing.Mask;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingResponse;
import com.qcloud.cos.utils.Jackson;
import java.util.List;

public class LiveAuditingJobDemo {
    public static void main(String[] args) throws InterruptedException {
        COSClient client = ClientUtils.getTestClient();
        LiveAuditingJobDemo.createLiveAuditingJob(client);
    }

    public static void createLiveAuditingJob(COSClient client) {
        VideoAuditingRequest request = new VideoAuditingRequest();
        request.setBucketName("demo-1234567890");
        request.getInput().setUrl("rtmp://play.demo.com/live/sdktest");
        request.setType("live_video");
        Conf conf = request.getConf();
        conf.setCallback("http://demohost:8001/livedemo");
        conf.setBizType("97ce1ce3b28609e92d441aa6166*****");
        Mask mask = conf.getMask();
        AuditingLiveOutput liveOutput = mask.getLiveOutput();
        liveOutput.setUrl("rtmp://demo.myqcloud.com/live/marktest");
        AuditingCosOutput cosOutput = mask.getCosOutput();
        cosOutput.setObject("demo/${JobId}.mp4</Object>");
        cosOutput.setRegion("ap-chongqing");
        cosOutput.setBucket("demo-1234567890");
        List<AuditingImage> images = mask.getImages();
        AuditingImage auditingImage = new AuditingImage();
        auditingImage.setLabel("Ads:QRCode");
        auditingImage.setType("Mask");
        auditingImage.setUrl("https://demo-1234567890.cos.ap-chongqign.myqcloud.com/guaziqrcode.png");
        images.add(auditingImage);
        auditingImage = new AuditingImage();
        auditingImage.setType("Mosaic");
        auditingImage.setLabel("default");
        images.add(auditingImage);
        List<AuditingAudio> audios = mask.getAudios();
        AuditingAudio audio = new AuditingAudio();
        audio.setLabel("default");
        audio.setType("Silence");
        audios.add(audio);
        VideoAuditingResponse response = client.createVideoAuditingJob(request);
        System.out.println(Jackson.toJsonString(response));
    }

    public static void describeLiveAuditingJob(COSClient client) throws InterruptedException {
        VideoAuditingRequest request = new VideoAuditingRequest();
        request.setBucketName("demo-1234567890");
        request.setJobId("avf8b813aa06a411ee80f45254004*****");
        VideoAuditingResponse response = client.describeAuditingJob(request);
        System.out.println(Jackson.toJsonString(response));
    }

    public static void cancelLiveAuditing(COSClient client) {
        VideoAuditingRequest request = new VideoAuditingRequest();
        request.setBucketName("demo-1234567890");
        request.setJobId("avf8b813aa06a411ee80f45254004*****");
        Boolean response = client.cancelLiveAuditing(request);
        System.out.println(response);
    }
}

