/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.ShortType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NegExpr;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.typing.fast.AugEvalFunction;
import soot.jimple.toolkits.typing.fast.AugHierarchy;
import soot.jimple.toolkits.typing.fast.BottomType;
import soot.jimple.toolkits.typing.fast.BytecodeHierarchy;
import soot.jimple.toolkits.typing.fast.IEvalFunction;
import soot.jimple.toolkits.typing.fast.IHierarchy;
import soot.jimple.toolkits.typing.fast.IUseVisitor;
import soot.jimple.toolkits.typing.fast.Integer127Type;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Integer32767Type;
import soot.jimple.toolkits.typing.fast.QueuedSet;
import soot.jimple.toolkits.typing.fast.Typing;
import soot.jimple.toolkits.typing.fast.UseChecker;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.SimpleLocalDefs;

public class TypeResolver {
    private JimpleBody jb;
    private List<DefinitionStmt> assignments;
    private HashMap<Local, List<DefinitionStmt>> depends;

    public TypeResolver(JimpleBody jb) {
        this.jb = jb;
        this.assignments = new LinkedList<DefinitionStmt>();
        this.depends = new HashMap();
        for (Local v : this.jb.getLocals()) {
            this.addLocal(v);
        }
        this.initAssignments();
    }

    private void initAssignments() {
        for (Unit stmt : this.jb.getUnits()) {
            if (!(stmt instanceof DefinitionStmt)) continue;
            this.initAssignment((DefinitionStmt)stmt);
        }
    }

    private void initAssignment(DefinitionStmt ds) {
        Value lhs = ds.getLeftOp();
        Value rhs = ds.getRightOp();
        if (lhs instanceof Local || lhs instanceof ArrayRef) {
            this.assignments.add(ds);
            if (rhs instanceof Local) {
                this.addDepend((Local)rhs, ds);
            } else if (rhs instanceof BinopExpr) {
                BinopExpr be = (BinopExpr)rhs;
                Value lop = be.getOp1();
                Value rop = be.getOp2();
                if (lop instanceof Local) {
                    this.addDepend((Local)lop, ds);
                }
                if (rop instanceof Local) {
                    this.addDepend((Local)rop, ds);
                }
            } else if (rhs instanceof NegExpr) {
                Value op = ((NegExpr)rhs).getOp();
                if (op instanceof Local) {
                    this.addDepend((Local)op, ds);
                }
            } else if (rhs instanceof ArrayRef) {
                this.addDepend((Local)((ArrayRef)rhs).getBase(), ds);
            }
        }
    }

    private void addLocal(Local v) {
        this.depends.put(v, new LinkedList());
    }

    private void addDepend(Local v, DefinitionStmt stmt) {
        this.depends.get(v).add(stmt);
    }

    public void inferTypes() {
        AugEvalFunction ef = new AugEvalFunction(this.jb);
        AugHierarchy ah = new AugHierarchy();
        BytecodeHierarchy bh = new BytecodeHierarchy();
        Collection<Typing> sigma = this.applyAssignmentConstraints(new Typing(this.jb.getLocals()), ef, bh);
        int[] castCount = new int[1];
        Typing tg = this.minCasts(sigma, bh, castCount);
        if (castCount[0] != 0) {
            this.split_new();
            sigma = this.applyAssignmentConstraints(new Typing(this.jb.getLocals()), ef, bh);
            tg = this.minCasts(sigma, bh, castCount);
        }
        this.insertCasts(tg, bh, false);
        for (Local v : this.jb.getLocals()) {
            Type t = tg.get(v);
            if (t instanceof IntegerType) {
                t = IntType.v();
                tg.set(v, BottomType.v());
            }
            v.setType(t);
        }
        if ((tg = this.typePromotion(tg)) == null) {
            soot.jimple.toolkits.typing.integer.TypeResolver.resolve(this.jb);
        } else {
            for (Local v : this.jb.getLocals()) {
                v.setType(tg.get(v));
            }
        }
    }

    private Typing typePromotion(Typing tg) {
        AugEvalFunction ef = new AugEvalFunction(this.jb);
        AugHierarchy h = new AugHierarchy();
        UseChecker uc = new UseChecker(this.jb);
        TypePromotionUseVisitor uv = new TypePromotionUseVisitor(this.jb, tg);
        do {
            Collection<Typing> sigma;
            if ((sigma = this.applyAssignmentConstraints(tg, ef, h)).isEmpty()) {
                return null;
            }
            tg = sigma.iterator().next();
            uv.typingChanged = false;
            uc.check(tg, uv);
            if (!uv.fail) continue;
            return null;
        } while (uv.typingChanged);
        for (Local v : this.jb.getLocals()) {
            Type t = tg.get(v);
            if (t instanceof Integer1Type) {
                tg.set(v, BooleanType.v());
                return this.typePromotion(tg);
            }
            if (t instanceof Integer127Type) {
                tg.set(v, ByteType.v());
                return this.typePromotion(tg);
            }
            if (!(t instanceof Integer32767Type)) continue;
            tg.set(v, ShortType.v());
            return this.typePromotion(tg);
        }
        return tg;
    }

    private int insertCasts(Typing tg, IHierarchy h, boolean countOnly) {
        UseChecker uc = new UseChecker(this.jb);
        CastInsertionUseVisitor uv = new CastInsertionUseVisitor(countOnly, this.jb, tg, h);
        uc.check(tg, uv);
        return uv.getCount();
    }

    private Typing minCasts(Collection<Typing> sigma, IHierarchy h, int[] count) {
        Typing r = null;
        count[0] = -1;
        boolean setR = false;
        for (Typing tg : sigma) {
            int n = this.insertCasts(tg, h, true);
            if (count[0] != -1 && n >= count[0]) continue;
            count[0] = n;
            r = tg;
            setR = true;
        }
        if (setR) {
            return r;
        }
        return null;
    }

    private Collection<Typing> applyAssignmentConstraints(Typing tg, IEvalFunction ef, IHierarchy h) {
        LinkedList<Typing> sigma = new LinkedList<Typing>();
        LinkedList<Typing> r = new LinkedList<Typing>();
        HashMap worklists = new HashMap();
        sigma.add(tg);
        QueuedSet<DefinitionStmt> wl = new QueuedSet<DefinitionStmt>(this.assignments);
        worklists.put(tg, wl);
        while (!sigma.isEmpty()) {
            tg = (Typing)sigma.element();
            wl = (QueuedSet<DefinitionStmt>)worklists.get(tg);
            if (wl.isEmpty()) {
                r.add(tg);
                sigma.remove();
                worklists.remove(tg);
                continue;
            }
            DefinitionStmt stmt = (DefinitionStmt)wl.removeFirst();
            Value lhs = stmt.getLeftOp();
            Value rhs = stmt.getRightOp();
            Local v = lhs instanceof Local ? (Local)lhs : (Local)((ArrayRef)lhs).getBase();
            Type told = tg.get(v);
            boolean keep = false;
            Collection<Type> eval = ef.eval(tg, rhs, stmt);
            for (Type t_ : eval) {
                if (lhs instanceof ArrayRef) {
                    if (!(t_ instanceof RefType) && !(t_ instanceof ArrayType)) {
                        keep = true;
                        continue;
                    }
                    t_ = t_.makeArrayType();
                }
                Collection<Type> lcas = h.lcas(told, t_);
                for (Type t : lcas) {
                    QueuedSet<DefinitionStmt> wl_;
                    Typing tg_;
                    if (TypeResolver.typesEqual(t, told)) {
                        keep = true;
                        continue;
                    }
                    if (eval.size() == 1 && lcas.size() == 1) {
                        tg_ = tg;
                        wl_ = wl;
                        keep = true;
                    } else {
                        tg_ = new Typing(tg);
                        wl_ = new QueuedSet<DefinitionStmt>(wl);
                        sigma.add(tg_);
                        worklists.put(tg_, wl_);
                    }
                    tg_.set(v, t);
                    wl_.addLast(this.depends.get(v));
                }
            }
            if (keep) continue;
            sigma.remove();
            worklists.remove(tg);
        }
        Typing.minimize(r, h);
        return r;
    }

    public static boolean typesEqual(Type a, Type b) {
        if (a instanceof ArrayType && b instanceof ArrayType) {
            ArrayType a_ = (ArrayType)a;
            ArrayType b_ = (ArrayType)b;
            return a_.numDimensions == b_.numDimensions && a_.baseType.equals(b_.baseType);
        }
        return a.equals(b);
    }

    private void split_new() {
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(this.jb);
        SimpleLocalDefs defs = new SimpleLocalDefs(graph);
        PatchingChain<Unit> units = this.jb.getUnits();
        Stmt[] stmts = new Stmt[units.size()];
        units.toArray(stmts);
        block0: for (Stmt stmt : stmts) {
            Stmt stmt2;
            SpecialInvokeExpr special;
            InvokeStmt invoke;
            if (!(stmt instanceof InvokeStmt) || !((invoke = (InvokeStmt)stmt).getInvokeExpr() instanceof SpecialInvokeExpr) || !(special = (SpecialInvokeExpr)invoke.getInvokeExpr()).getMethodRef().name().equals("<init>")) continue;
            List<Unit> deflist = defs.getDefsOfAt((Local)special.getBase(), invoke);
            while (deflist.size() == 1 && (stmt2 = (Stmt)deflist.get(0)) instanceof AssignStmt) {
                AssignStmt assign = (AssignStmt)stmt2;
                if (assign.getRightOp() instanceof Local) {
                    deflist = defs.getDefsOfAt((Local)assign.getRightOp(), assign);
                    continue;
                }
                if (!(assign.getRightOp() instanceof NewExpr)) continue block0;
                Local newlocal = Jimple.v().newLocal("tmp", null);
                newlocal.setName("tmp$" + System.identityHashCode(newlocal));
                this.jb.getLocals().add(newlocal);
                special.setBase(newlocal);
                AssignStmt assignStmt = Jimple.v().newAssignStmt(assign.getLeftOp(), newlocal);
                units.insertAfter(assignStmt, (Unit)assign);
                assign.setLeftOp(newlocal);
                this.addLocal(newlocal);
                this.initAssignment(assignStmt);
                continue block0;
            }
        }
    }

    private class TypePromotionUseVisitor
    implements IUseVisitor {
        private JimpleBody jb;
        private Typing tg;
        public boolean fail;
        public boolean typingChanged;

        public TypePromotionUseVisitor(JimpleBody jb, Typing tg) {
            this.jb = jb;
            this.tg = tg;
            this.fail = false;
            this.typingChanged = false;
        }

        private Type promote(Type tlow, Type thigh) {
            if (tlow instanceof Integer1Type) {
                if (thigh instanceof IntType) {
                    return Integer127Type.v();
                }
                if (thigh instanceof ShortType) {
                    return ByteType.v();
                }
                if (thigh instanceof BooleanType || thigh instanceof ByteType || thigh instanceof CharType || thigh instanceof Integer127Type || thigh instanceof Integer32767Type) {
                    return thigh;
                }
                throw new RuntimeException();
            }
            if (tlow instanceof Integer127Type) {
                if (thigh instanceof ShortType) {
                    return ByteType.v();
                }
                if (thigh instanceof IntType) {
                    return Integer127Type.v();
                }
                if (thigh instanceof ByteType || thigh instanceof CharType || thigh instanceof Integer32767Type) {
                    return thigh;
                }
                throw new RuntimeException();
            }
            if (tlow instanceof Integer32767Type) {
                if (thigh instanceof IntType) {
                    return Integer32767Type.v();
                }
                if (thigh instanceof ShortType || thigh instanceof CharType) {
                    return thigh;
                }
                throw new RuntimeException();
            }
            throw new RuntimeException();
        }

        @Override
        public Value visit(Value op, Type useType, Stmt stmt) {
            if (this.finish()) {
                return op;
            }
            Type t = AugEvalFunction.eval_(this.tg, op, stmt, this.jb);
            if (!AugHierarchy.ancestor_(useType, t)) {
                this.fail = true;
            } else if (op instanceof Local && (t instanceof Integer1Type || t instanceof Integer127Type || t instanceof Integer32767Type)) {
                Type t_;
                Local v = (Local)op;
                if (!TypeResolver.typesEqual(t, useType) && !TypeResolver.typesEqual(t, t_ = this.promote(t, useType))) {
                    this.tg.set(v, t_);
                    this.typingChanged = true;
                }
            }
            return op;
        }

        @Override
        public boolean finish() {
            return this.typingChanged || this.fail;
        }
    }

    private class CastInsertionUseVisitor
    implements IUseVisitor {
        private JimpleBody jb;
        private Typing tg;
        private IHierarchy h;
        private boolean countOnly;
        private int count;

        public CastInsertionUseVisitor(boolean countOnly, JimpleBody jb, Typing tg, IHierarchy h) {
            this.jb = jb;
            this.tg = tg;
            this.h = h;
            this.countOnly = countOnly;
            this.count = 0;
        }

        @Override
        public Value visit(Value op, Type useType, Stmt stmt) {
            Local vold;
            Type t = AugEvalFunction.eval_(this.tg, op, stmt, this.jb);
            if (this.h.ancestor(useType, t)) {
                return op;
            }
            ++this.count;
            if (this.countOnly) {
                return op;
            }
            if (!(op instanceof Local)) {
                vold = Jimple.v().newLocal("tmp", t);
                vold.setName("tmp$" + System.identityHashCode(vold));
                this.tg.set(vold, t);
                this.jb.getLocals().add(vold);
                this.jb.getUnits().insertBefore(Jimple.v().newAssignStmt(vold, op), (Unit)stmt);
            } else {
                vold = (Local)op;
            }
            Local vnew = Jimple.v().newLocal("tmp", useType);
            vnew.setName("tmp$" + System.identityHashCode(vnew));
            this.tg.set(vnew, useType);
            this.jb.getLocals().add(vnew);
            this.jb.getUnits().insertBefore(Jimple.v().newAssignStmt(vnew, Jimple.v().newCastExpr(vold, useType)), (Unit)stmt);
            return vnew;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public boolean finish() {
            return false;
        }
    }
}

