/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.infoflow.CallChain;
import soot.jimple.toolkits.infoflow.CallLocalityContext;
import soot.jimple.toolkits.infoflow.ClassLocalObjectsAnalysis;
import soot.jimple.toolkits.infoflow.InfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.SmartMethodLocalObjectsAnalysis;
import soot.jimple.toolkits.infoflow.UseFinder;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.scalar.Pair;

public class LocalObjectsAnalysis {
    public InfoFlowAnalysis dfa;
    UseFinder uf;
    CallGraph cg;
    Map<SootClass, ClassLocalObjectsAnalysis> classToClassLocalObjectsAnalysis;
    Map mergedContextsCache;
    Map<SootMethod, SmartMethodLocalObjectsAnalysis> mloaCache;
    Map<SootMethod, ReachableMethods> rmCache = new HashMap<SootMethod, ReachableMethods>();
    Map callChainsCache = new HashMap();

    public LocalObjectsAnalysis(InfoFlowAnalysis dfa) {
        this.dfa = dfa;
        this.uf = new UseFinder();
        this.cg = Scene.v().getCallGraph();
        this.classToClassLocalObjectsAnalysis = new HashMap<SootClass, ClassLocalObjectsAnalysis>();
        this.mergedContextsCache = new HashMap();
        this.mloaCache = new HashMap<SootMethod, SmartMethodLocalObjectsAnalysis>();
    }

    public ClassLocalObjectsAnalysis getClassLocalObjectsAnalysis(SootClass sc) {
        if (!this.classToClassLocalObjectsAnalysis.containsKey(sc)) {
            ClassLocalObjectsAnalysis cloa = this.newClassLocalObjectsAnalysis(this, this.dfa, this.uf, sc);
            this.classToClassLocalObjectsAnalysis.put(sc, cloa);
        }
        return this.classToClassLocalObjectsAnalysis.get(sc);
    }

    protected ClassLocalObjectsAnalysis newClassLocalObjectsAnalysis(LocalObjectsAnalysis loa, InfoFlowAnalysis dfa, UseFinder uf, SootClass sc) {
        return new ClassLocalObjectsAnalysis(loa, dfa, uf, sc);
    }

    public boolean isObjectLocalToParent(Value localOrRef, SootMethod sm) {
        if (localOrRef instanceof StaticFieldRef) {
            return false;
        }
        ClassLocalObjectsAnalysis cloa = this.getClassLocalObjectsAnalysis(sm.getDeclaringClass());
        return cloa.isObjectLocal(localOrRef, sm);
    }

    public boolean isFieldLocalToParent(SootField sf) {
        if (sf.isStatic()) {
            return false;
        }
        ClassLocalObjectsAnalysis cloa = this.getClassLocalObjectsAnalysis(sf.getDeclaringClass());
        return cloa.isFieldLocal(sf);
    }

    public boolean isObjectLocalToContext(Value localOrRef, SootMethod sm, SootMethod context) {
        if (sm == context) {
            boolean isLocal = this.isObjectLocalToParent(localOrRef, sm);
            if (this.dfa.printDebug()) {
                G.v().out.println("    " + (isLocal ? "LOCAL  (Directly Reachable from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")" : "SHARED (Directly Reachable from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")"));
            }
            return isLocal;
        }
        if (localOrRef instanceof StaticFieldRef) {
            if (this.dfa.printDebug()) {
                G.v().out.println("    SHARED (Static             from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")");
            }
            return false;
        }
        if (!sm.isConcrete()) {
            throw new RuntimeException("Attempted to check if a local variable in a non-concrete method is shared/local.");
        }
        Body b = sm.retrieveActiveBody();
        CallLocalityContext mergedContext = this.getClassLocalObjectsAnalysis(context.getDeclaringClass()).getMergedContext(sm);
        if (mergedContext == null) {
            if (this.dfa.printDebug()) {
                G.v().out.println("      ------ (Unreachable        from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")");
            }
            return true;
        }
        if (localOrRef instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)localOrRef;
            Local thisLocal = null;
            try {
                thisLocal = b.getThisLocal();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (ifr.getBase() == thisLocal) {
                boolean isLocal = mergedContext.isFieldLocal(InfoFlowAnalysis.getNodeForFieldRef(sm, ifr.getField()));
                if (this.dfa.printDebug()) {
                    if (isLocal) {
                        G.v().out.println("      LOCAL  (this  .localField  from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")");
                    } else {
                        G.v().out.println("      SHARED (this  .sharedField from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")");
                    }
                }
                return isLocal;
            }
            boolean isLocal = SmartMethodLocalObjectsAnalysis.isObjectLocal(this.dfa, sm, mergedContext, ifr.getBase());
            if (isLocal) {
                ClassLocalObjectsAnalysis cloa = this.getClassLocalObjectsAnalysis(context.getDeclaringClass());
                boolean bl = isLocal = !cloa.getInnerSharedFields().contains(ifr.getField());
                if (this.dfa.printDebug()) {
                    if (isLocal) {
                        G.v().out.println("      LOCAL  (local .localField  from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")");
                    } else {
                        G.v().out.println("      SHARED (local .sharedField from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")");
                    }
                }
                return isLocal;
            }
            if (this.dfa.printDebug()) {
                G.v().out.println("      SHARED (shared.someField   from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")");
            }
            return isLocal;
        }
        boolean isLocal = SmartMethodLocalObjectsAnalysis.isObjectLocal(this.dfa, sm, mergedContext, localOrRef);
        if (this.dfa.printDebug()) {
            if (isLocal) {
                G.v().out.println("      LOCAL  ( local             from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")");
            } else {
                G.v().out.println("      SHARED (shared             from " + context.getDeclaringClass().getShortName() + "." + context.getName() + ")");
            }
        }
        return isLocal;
    }

    public CallChain getNextCallChainBetween(SootMethod start, SootMethod goal, List previouslyFound) {
        ReachableMethods rm = null;
        if (this.rmCache.containsKey(start)) {
            rm = this.rmCache.get(start);
        } else {
            ArrayList<MethodOrMethodContext> entryPoints = new ArrayList<MethodOrMethodContext>();
            entryPoints.add(start);
            rm = new ReachableMethods(this.cg, entryPoints);
            rm.update();
            this.rmCache.put(start, rm);
        }
        if (rm.contains(goal)) {
            return this.getNextCallChainBetween(rm, start, goal, null, null, previouslyFound);
        }
        return null;
    }

    public CallChain getNextCallChainBetween(ReachableMethods rm, SootMethod start, SootMethod end, Edge endToPath, CallChain path, List previouslyFound) {
        Pair<SootMethod, SootMethod> cacheKey = new Pair<SootMethod, SootMethod>(start, end);
        if (this.callChainsCache.containsKey(cacheKey)) {
            return null;
        }
        path = new CallChain(endToPath, path);
        if (start == end) {
            return path;
        }
        if (!rm.contains(end)) {
            return null;
        }
        Iterator<Edge> edgeIt = this.cg.edgesInto(end);
        while (edgeIt.hasNext()) {
            CallChain newpath;
            Edge e = edgeIt.next();
            SootMethod node = e.src();
            if (path.containsMethod(node) || !e.isExplicit() || !e.srcStmt().containsInvokeExpr() || (newpath = this.getNextCallChainBetween(rm, start, node, e, path, previouslyFound)) == null || previouslyFound.contains(newpath)) continue;
            return newpath;
        }
        if (previouslyFound.size() == 0) {
            this.callChainsCache.put(cacheKey, null);
        }
        return null;
    }

    public List<SootMethod> getAllMethodsForClass(SootClass sootClass) {
        ReachableMethods rm = Scene.v().getReachableMethods();
        ArrayList<SootMethod> scopeMethods = new ArrayList<SootMethod>();
        Iterator<SootMethod> scopeMethodsIt = sootClass.methodIterator();
        while (scopeMethodsIt.hasNext()) {
            SootMethod scopeMethod = scopeMethodsIt.next();
            if (!rm.contains(scopeMethod)) continue;
            scopeMethods.add(scopeMethod);
        }
        SootClass superclass = sootClass;
        if (superclass.hasSuperclass()) {
            superclass = sootClass.getSuperclass();
        }
        while (superclass.hasSuperclass()) {
            Iterator<SootMethod> scMethodsIt = superclass.methodIterator();
            while (scMethodsIt.hasNext()) {
                SootMethod scMethod = scMethodsIt.next();
                if (!rm.contains(scMethod)) continue;
                scopeMethods.add(scMethod);
            }
            superclass = superclass.getSuperclass();
        }
        return scopeMethods;
    }

    public boolean hasNonLocalEffects(SootMethod containingMethod, InvokeExpr ie, SootMethod context) {
        block6: {
            HashMutableDirectedGraph dataFlowGraph;
            block5: {
                SootMethod target = ie.getMethodRef().resolve();
                dataFlowGraph = this.dfa.getMethodInfoFlowSummary(target);
                if (!(ie instanceof StaticInvokeExpr)) break block5;
                for (EquivalentValue nodeEqVal : dataFlowGraph) {
                    ParameterRef pr;
                    Ref node = (Ref)nodeEqVal.getValue();
                    if (!(node instanceof FieldRef ? dataFlowGraph.getPredsOf(nodeEqVal).size() > 0 || dataFlowGraph.getSuccsOf(nodeEqVal).size() > 0 : node instanceof ParameterRef && (dataFlowGraph.getPredsOf(nodeEqVal).size() > 0 || dataFlowGraph.getSuccsOf(nodeEqVal).size() > 0) && (pr = (ParameterRef)node).getIndex() != -1 && !this.isObjectLocalToContext(ie.getArg(pr.getIndex()), containingMethod, context))) continue;
                    return true;
                }
                break block6;
            }
            if (!(ie instanceof InstanceInvokeExpr)) break block6;
            InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
            if (this.isObjectLocalToContext(iie.getBase(), containingMethod, context)) {
                for (EquivalentValue nodeEqVal : dataFlowGraph) {
                    ParameterRef pr;
                    Ref node = (Ref)nodeEqVal.getValue();
                    if (!(node instanceof StaticFieldRef ? dataFlowGraph.getPredsOf(nodeEqVal).size() > 0 || dataFlowGraph.getSuccsOf(nodeEqVal).size() > 0 : node instanceof ParameterRef && (dataFlowGraph.getPredsOf(nodeEqVal).size() > 0 || dataFlowGraph.getSuccsOf(nodeEqVal).size() > 0) && (pr = (ParameterRef)node).getIndex() != -1 && !this.isObjectLocalToContext(ie.getArg(pr.getIndex()), containingMethod, context))) continue;
                    return true;
                }
            } else {
                for (EquivalentValue nodeEqVal : dataFlowGraph) {
                    ParameterRef pr;
                    Ref node = (Ref)nodeEqVal.getValue();
                    if (!(node instanceof FieldRef ? dataFlowGraph.getPredsOf(nodeEqVal).size() > 0 || dataFlowGraph.getSuccsOf(nodeEqVal).size() > 0 : node instanceof ParameterRef && (dataFlowGraph.getPredsOf(nodeEqVal).size() > 0 || dataFlowGraph.getSuccsOf(nodeEqVal).size() > 0) && (pr = (ParameterRef)node).getIndex() != -1 && !this.isObjectLocalToContext(ie.getArg(pr.getIndex()), containingMethod, context))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

