/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.List;
import soot.Local;
import soot.UnitBoxOwner;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.StmtSwitch;
import soot.jimple.internal.AbstractDefinitionStmt;
import soot.jimple.internal.RValueBox;
import soot.jimple.internal.VariableBox;
import soot.util.SingletonList;
import soot.util.Switch;

public class JAssignStmt
extends AbstractDefinitionStmt
implements AssignStmt {
    public JAssignStmt(Value variable, Value rvalue) {
        this.leftBox = new LinkedVariableBox(variable);
        this.rightBox = new LinkedRValueBox(rvalue);
        ((LinkedVariableBox)this.leftBox).setOtherBox(this.rightBox);
        ((LinkedRValueBox)this.rightBox).setOtherBox(this.leftBox);
        if (!this.leftBox.canContainValue(variable) || !this.rightBox.canContainValue(rvalue)) {
            throw new RuntimeException("Illegal assignment statement.  Make sure that either left side or right hand side has a local or constant.");
        }
        this.defBoxes = new SingletonList(this.leftBox);
    }

    protected JAssignStmt(ValueBox variableBox, ValueBox rvalueBox) {
        this.leftBox = variableBox;
        this.rightBox = rvalueBox;
        this.defBoxes = new SingletonList(this.leftBox);
    }

    @Override
    public boolean containsInvokeExpr() {
        return this.rightBox.getValue() instanceof InvokeExpr;
    }

    @Override
    public InvokeExpr getInvokeExpr() {
        if (!this.containsInvokeExpr()) {
            throw new RuntimeException("getInvokeExpr() called with no invokeExpr present!");
        }
        return (InvokeExpr)this.rightBox.getValue();
    }

    @Override
    public ValueBox getInvokeExprBox() {
        if (!this.containsInvokeExpr()) {
            throw new RuntimeException("getInvokeExpr() called with no invokeExpr present!");
        }
        return this.rightBox;
    }

    @Override
    public boolean containsArrayRef() {
        return this.leftBox.getValue() instanceof ArrayRef || this.rightBox.getValue() instanceof ArrayRef;
    }

    @Override
    public ArrayRef getArrayRef() {
        if (!this.containsArrayRef()) {
            throw new RuntimeException("getArrayRef() called with no ArrayRef present!");
        }
        if (this.leftBox.getValue() instanceof ArrayRef) {
            return (ArrayRef)this.leftBox.getValue();
        }
        return (ArrayRef)this.rightBox.getValue();
    }

    @Override
    public ValueBox getArrayRefBox() {
        if (!this.containsArrayRef()) {
            throw new RuntimeException("getArrayRefBox() called with no ArrayRef present!");
        }
        if (this.leftBox.getValue() instanceof ArrayRef) {
            return this.leftBox;
        }
        return this.rightBox;
    }

    @Override
    public boolean containsFieldRef() {
        return this.leftBox.getValue() instanceof FieldRef || this.rightBox.getValue() instanceof FieldRef;
    }

    @Override
    public FieldRef getFieldRef() {
        if (!this.containsFieldRef()) {
            throw new RuntimeException("getFieldRef() called with no FieldRef present!");
        }
        if (this.leftBox.getValue() instanceof FieldRef) {
            return (FieldRef)this.leftBox.getValue();
        }
        return (FieldRef)this.rightBox.getValue();
    }

    @Override
    public ValueBox getFieldRefBox() {
        if (!this.containsFieldRef()) {
            throw new RuntimeException("getFieldRefBox() called with no FieldRef present!");
        }
        if (this.leftBox.getValue() instanceof FieldRef) {
            return this.leftBox;
        }
        return this.rightBox;
    }

    @Override
    public List getUnitBoxes() {
        Value rValue = this.rightBox.getValue();
        if (rValue instanceof UnitBoxOwner) {
            return ((UnitBoxOwner)((Object)rValue)).getUnitBoxes();
        }
        return super.getUnitBoxes();
    }

    public String toString() {
        return this.leftBox.getValue().toString() + " = " + this.rightBox.getValue().toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        this.leftBox.toString(up);
        up.literal(" = ");
        this.rightBox.toString(up);
    }

    @Override
    public Object clone() {
        return new JAssignStmt(Jimple.cloneIfNecessary(this.getLeftOp()), Jimple.cloneIfNecessary(this.getRightOp()));
    }

    @Override
    public void setLeftOp(Value variable) {
        this.leftBox.setValue(variable);
    }

    @Override
    public void setRightOp(Value rvalue) {
        this.rightBox.setValue(rvalue);
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseAssignStmt(this);
    }

    private class LinkedVariableBox
    extends VariableBox {
        ValueBox otherBox;

        private LinkedVariableBox(Value v) {
            super(v);
            this.otherBox = null;
        }

        public void setOtherBox(ValueBox otherBox) {
            this.otherBox = otherBox;
        }

        @Override
        public boolean canContainValue(Value v) {
            if (this.otherBox == null) {
                return super.canContainValue(v);
            }
            Value other = this.otherBox.getValue();
            return super.canContainValue(v) && (v instanceof Local || v instanceof Constant || other instanceof Local || other instanceof Constant);
        }
    }

    private class LinkedRValueBox
    extends RValueBox {
        ValueBox otherBox;

        private LinkedRValueBox(Value v) {
            super(v);
            this.otherBox = null;
        }

        public void setOtherBox(ValueBox otherBox) {
            this.otherBox = otherBox;
        }

        @Override
        public boolean canContainValue(Value v) {
            if (this.otherBox == null) {
                return super.canContainValue(v);
            }
            Value other = this.otherBox.getValue();
            return super.canContainValue(v) && (v instanceof Local || v instanceof Constant || other instanceof Local || other instanceof Constant);
        }
    }
}

