/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import soot.CompilationDeathException;
import soot.G;
import soot.PhaseOptions;
import soot.ScenePack;
import soot.Transform;

public class RadioScenePack
extends ScenePack {
    public RadioScenePack(String name) {
        super(name);
    }

    @Override
    protected void internalApply() {
        LinkedList<Transform> enableds = new LinkedList<Transform>();
        Iterator tIt = this.iterator();
        while (tIt.hasNext()) {
            Transform t = (Transform)tIt.next();
            Map opts = PhaseOptions.v().getPhaseOptions(t);
            if (!PhaseOptions.getBoolean(opts, "enabled")) continue;
            enableds.add(t);
        }
        if (enableds.size() == 0) {
            G.v().out.println("Exactly one phase in the pack " + this.getPhaseName() + " must be enabled. Currently, none of them are.");
            throw new CompilationDeathException(0);
        }
        if (enableds.size() > 1) {
            G.v().out.println("Only one phase in the pack " + this.getPhaseName() + " may be enabled. The following are enabled currently: ");
            for (Transform t : enableds) {
                G.v().out.println("  " + t.getPhaseName());
            }
            throw new CompilationDeathException(0);
        }
        for (Transform t : enableds) {
            t.apply();
        }
    }

    @Override
    public void add(Transform t) {
        super.add(t);
        this.checkEnabled(t);
    }

    @Override
    public void insertAfter(Transform t, String phaseName) {
        super.insertAfter(t, phaseName);
        this.checkEnabled(t);
    }

    @Override
    public void insertBefore(Transform t, String phaseName) {
        super.insertBefore(t, phaseName);
        this.checkEnabled(t);
    }

    private void checkEnabled(Transform t) {
        Map options = PhaseOptions.v().getPhaseOptions(t);
        if (PhaseOptions.getBoolean(options, "enabled")) {
            PhaseOptions.v().setPhaseOption(t, "enabled:true");
        }
    }
}

