/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice.util;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.robovm.libimobiledevice.AfcClient;
import org.robovm.libimobiledevice.DebugServerClient;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.InstallationProxyClient;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.LockdowndClient;
import org.robovm.libimobiledevice.LockdowndServiceDescriptor;
import org.robovm.libimobiledevice.MobileImageMounterClient;
import org.robovm.libimobiledevice.binding.LockdowndError;
import org.robovm.libimobiledevice.binding.MobileImageMounterError;
import org.robovm.libimobiledevice.util.AppLauncherCallback;
import org.robovm.libimobiledevice.util.DeveloperImageResolver;
import org.robovm.libimobiledevice.util.Lambdas;
import org.robovm.libimobiledevice.util.Version;

public class AppLauncher {
    public static final int DEFAULT_FORWARD_PORT = 17777;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final int RECEIVE_TIMEOUT = 5000;
    private static final byte[] BREAK = new byte[]{3};
    private byte[] buffer = new byte[4096];
    private StringBuilder bufferedResponses = new StringBuilder(4096);
    private final String deviceUdid;
    private IDevice resolvedDevice;
    private final String appId;
    private final File localAppPath;
    private boolean installed = false;
    private List<String> args = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private OutputStream stdout = System.out;
    private boolean closeOutOnExit = false;
    private boolean debug = false;
    private int localPort = -1;
    private AppLauncherCallback appLauncherCallback = null;
    private volatile boolean killed = false;
    private InstallationProxyClient.StatusCallback installStatusCallback;
    private AfcClient.UploadProgressCallback uploadProgressCallback;
    private String xcodePath;
    private int launchOnLockedRetries = 20;
    private int secondsBetweenLaunchOnLockedRetries = 1;

    public AppLauncher(String deviceUdid, String appId) {
        this(deviceUdid, appId, null);
    }

    public AppLauncher(String deviceUdid, File localAppPath) throws IOException {
        this(deviceUdid, AppLauncher.getAppId(localAppPath), localAppPath);
    }

    private AppLauncher(String deviceUdid, String appId, File localAppPath) {
        if (appId == null) {
            throw new NullPointerException("appId");
        }
        this.deviceUdid = deviceUdid != null && !deviceUdid.isEmpty() ? deviceUdid : null;
        this.appId = appId;
        this.localAppPath = localAppPath;
    }

    private IDevice waitForDevice(String deviceUdid) throws Exception {
        String message;
        int retries;
        int retriesLeft = retries = this.launchOnLockedRetries;
        int secondsBetweenRetries = this.secondsBetweenLaunchOnLockedRetries;
        while (true) {
            String[] udids;
            if ((udids = IDevice.listUdids()).length == 1 && (deviceUdid == null || deviceUdid.equals(udids[0]))) {
                return new IDevice(udids[0]);
            }
            message = udids.length == 0 ? "No devices connected" : (deviceUdid != null ? String.format("Required %s is not connected (%s)", deviceUdid, Arrays.asList(udids)) : String.format("More than 1 device connected (%s)", Arrays.asList(udids)));
            if (retriesLeft <= 0) break;
            this.log("Waiting for device: %s. (retry %d of %d)...", message, retries - --retriesLeft, retries);
            Thread.sleep((long)secondsBetweenRetries * 1000L);
        }
        throw new LibIMobileDeviceException(message);
    }

    private IDevice findDevice() throws Exception {
        if (this.resolvedDevice == null) {
            this.resolvedDevice = this.waitForDevice(this.deviceUdid);
        }
        return this.resolvedDevice;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getAppId(File f) throws IOException {
        File infoPlistFile;
        if (f == null) {
            throw new NullPointerException("localAppPath");
        }
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        NSDictionary infoPlistDict = null;
        if (f.getName().toLowerCase().endsWith(".ipa")) {
            try (ZipFile zipFile = new ZipFile(f);){
                for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
                    if (!zipEntry.getName().matches("Payload/[^/]+\\.app/Info\\.plist")) continue;
                    try (InputStream is = zipFile.getInputStream(zipEntry);){
                        try {
                            infoPlistDict = (NSDictionary)PropertyListParser.parse((InputStream)is);
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    }
                }
            }
        } else if (f.isDirectory() && (infoPlistFile = new File(f, "Info.plist")).exists()) {
            try {
                infoPlistDict = (NSDictionary)PropertyListParser.parse((File)infoPlistFile);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (infoPlistDict == null) {
            throw new IllegalArgumentException("Path " + f + " is neither a .ipa file nor an iOS app bundle directory.");
        }
        NSString appId = (NSString)infoPlistDict.objectForKey("CFBundleIdentifier");
        if (appId == null) {
            throw new IllegalArgumentException("No CFBundleIdentifier found in the Info.plist file in " + f);
        }
        return appId.toString();
    }

    public AppLauncher uploadProgressCallback(AfcClient.UploadProgressCallback callback) {
        this.uploadProgressCallback = callback;
        return this;
    }

    public AppLauncher installStatusCallback(InstallationProxyClient.StatusCallback callback) {
        this.installStatusCallback = callback;
        return this;
    }

    public AppLauncher args(String ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public AppLauncher stdout(OutputStream stdout) {
        if (stdout == null) {
            throw new NullPointerException("stdout");
        }
        this.stdout = stdout;
        return this;
    }

    public AppLauncher closeOutOnExit(boolean closeOutOnExit) {
        this.closeOutOnExit = closeOutOnExit;
        return this;
    }

    public AppLauncher env(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.env.put(name, value);
        return this;
    }

    public AppLauncher env(Map<String, String> env) {
        if (env == null) {
            throw new NullPointerException("env");
        }
        this.env.putAll(env);
        return this;
    }

    public AppLauncher debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public AppLauncher forward(int localPort) {
        this.localPort = localPort;
        return this;
    }

    public AppLauncher appLauncherCallback(AppLauncherCallback callback) {
        this.appLauncherCallback = callback;
        return this;
    }

    public AppLauncher xcodePath(String xcodePath) {
        this.xcodePath = xcodePath;
        return this;
    }

    public AppLauncher launchOnLockedRetries(int launchOnLockedRetries) {
        this.launchOnLockedRetries = launchOnLockedRetries;
        return this;
    }

    public AppLauncher secondsBetweenLaunchOnLockedRetries(int secondsBetweenLaunchOnLockedRetries) {
        this.secondsBetweenLaunchOnLockedRetries = secondsBetweenLaunchOnLockedRetries;
        return this;
    }

    public void kill() {
        this.killed = true;
    }

    private static String toHex(String s) {
        StringBuilder sb = new StringBuilder(s.length() * 2);
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            sb.append(HEX_CHARS[c >> 4]);
            sb.append(HEX_CHARS[c & 0xF]);
        }
        return sb.toString();
    }

    private static byte fromHex(char c1, char c2) {
        int d = 0;
        d = c1 <= '9' ? c1 - 48 : c1 - 97 + 10;
        d <<= 4;
        d = c2 <= '9' ? (d |= c2 - 48) : (d |= c2 - 97 + 10);
        return (byte)d;
    }

    private static byte[] fromHex(String s) {
        int length = s.length();
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length >> 1; ++i) {
            data[i] = AppLauncher.fromHex(s.charAt(i * 2), s.charAt(i * 2 + 1));
        }
        return data;
    }

    private static byte[] fromHex(byte[] buffer, int offset, int length) {
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length >> 1; ++i) {
            data[i] = AppLauncher.fromHex((char)buffer[offset + i * 2], (char)buffer[offset + i * 2 + 1]);
        }
        return data;
    }

    private String encode(String cmd) {
        int checksum = 0;
        for (int i = 0; i < cmd.length(); ++i) {
            checksum += cmd.charAt(i);
        }
        return String.format("$%s#%02x", cmd, checksum & 0xFF);
    }

    private String decode(String packet) {
        int start = 1;
        if (packet.charAt(0) == '+' || packet.charAt(0) == '-') {
            start = 2;
        }
        int end = packet.lastIndexOf(35);
        return packet.substring(start, end);
    }

    private void debugGdb(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    protected void log(String s, Object ... args) {
        System.out.format(s, args);
        System.out.println();
    }

    private void sendGdbPacket(DebugServerClient client, String packet) throws IOException {
        int sentBytes;
        this.debugGdb("Sending packet: " + packet);
        byte[] data = packet.getBytes(StandardCharsets.US_ASCII);
        while ((sentBytes = client.send(data, 0, data.length)) != data.length) {
            data = Arrays.copyOfRange(data, sentBytes, data.length);
        }
    }

    private String receiveGdbPacket(DebugServerClient client) throws IOException, TimeoutException {
        return this.receiveGdbPacket(client, Integer.MAX_VALUE);
    }

    private String receiveGdbPacket(DebugServerClient client, long timeout) throws IOException, TimeoutException {
        int packetEnd = this.bufferedResponses.indexOf("#");
        if (packetEnd != -1 && this.bufferedResponses.length() - packetEnd > 2) {
            String packet = this.bufferedResponses.substring(0, packetEnd + 3);
            this.bufferedResponses.delete(0, packetEnd + 3);
            this.debugGdb("Received packet: " + packet);
            return packet;
        }
        long deadline = System.currentTimeMillis() + timeout;
        do {
            if (this.killed || Thread.currentThread().isInterrupted()) {
                this.killed = true;
                throw new InterruptedIOException();
            }
            int receivedBytes = client.receive(this.buffer, 0, this.buffer.length, 10);
            if (receivedBytes <= 0) continue;
            this.bufferedResponses.append(new String(this.buffer, 0, receivedBytes, StandardCharsets.US_ASCII));
            packetEnd = this.bufferedResponses.indexOf("#");
            if (packetEnd == -1 || this.bufferedResponses.length() - packetEnd <= 2) continue;
            String packet = this.bufferedResponses.substring(0, packetEnd + 3);
            this.bufferedResponses.delete(0, packetEnd + 3);
            this.debugGdb("Received packet: " + packet);
            return packet;
        } while (System.currentTimeMillis() <= deadline);
        throw new TimeoutException();
    }

    private boolean receiveGdbAck(DebugServerClient client) throws IOException {
        if (this.bufferedResponses.length() > 0) {
            char c = this.bufferedResponses.charAt(0);
            this.bufferedResponses.delete(0, 1);
            return c == '+';
        }
        byte[] buffer = new byte[1];
        client.receive(buffer, 0, buffer.length, 5000);
        this.debugGdb("Received ack: " + (char)buffer[0]);
        return buffer[0] == 43;
    }

    private void sendReceivePacket(DebugServerClient client, String packet, String expectedResponse, boolean ackMode) throws IOException, TimeoutException {
        String response;
        this.sendGdbPacket(client, packet);
        if (ackMode) {
            this.receiveGdbAck(client);
        }
        if (!expectedResponse.equals(response = this.decode(this.receiveGdbPacket(client, 5000L)))) {
            if (response.startsWith("E")) {
                throw new RuntimeException("Launch failed: " + response.substring(1));
            }
            throw new RuntimeException("Launch failed: Unexpected response '" + response + "' to command '" + this.decode(packet) + "'");
        }
    }

    private void kill(DebugServerClient client) throws IOException, TimeoutException {
        this.killed = false;
        Thread.interrupted();
        this.debugGdb("Sending break");
        client.send(BREAK, 0, BREAK.length);
        this.receiveGdbPacket(client, 5000L);
        this.sendGdbPacket(client, this.encode("k"));
    }

    private String encodeArgs(String appPath) {
        StringBuilder sb = new StringBuilder();
        String hex = AppLauncher.toHex(appPath);
        sb.append(String.format("%d,0,%s", hex.length(), hex));
        for (int i = 0; i < this.args.size(); ++i) {
            hex = AppLauncher.toHex(this.args.get(i));
            sb.append(String.format(",%d,%d,%s", hex.length(), i + 1, hex));
        }
        return sb.toString();
    }

    private String getAppPath(LockdowndClient lockdowndClient, String appId) throws IOException {
        LockdowndServiceDescriptor instService = lockdowndClient.startService("com.apple.mobile.installation_proxy");
        try (InstallationProxyClient instClient = new InstallationProxyClient(lockdowndClient.getDevice(), instService);){
            NSArray apps = instClient.browse();
            for (int i = 0; i < apps.count(); ++i) {
                NSDictionary appInfo = (NSDictionary)apps.objectAtIndex(i);
                NSString bundleId = (NSString)appInfo.objectForKey("CFBundleIdentifier");
                if (bundleId == null || !appId.equals(bundleId.toString())) continue;
                NSString path = (NSString)appInfo.objectForKey("Path");
                NSDictionary entitlements = (NSDictionary)appInfo.objectForKey("Entitlements");
                if (entitlements == null || entitlements.objectForKey("get-task-allow") == null || !entitlements.objectForKey("get-task-allow").equals(new NSNumber(true))) {
                    throw new RuntimeException("App with id '" + appId + "' does not have the 'get-task-allow' entitlement and cannot be debugged");
                }
                if (path == null) {
                    throw new RuntimeException("Path for app with id '" + appId + "' not found");
                }
                String string = path.toString();
                return string;
            }
            throw new RuntimeException("No app with id '" + appId + "' found on device");
        }
    }

    public void install() throws IOException {
        if (!this.installed) {
            Retrying<LockdowndClient> lockdownRetrying = new Retrying<LockdowndClient>(() -> new LockdowndClient(this.findDevice(), this.getClass().getSimpleName(), true));
            try (Retrying<LockdowndClient> retrying = lockdownRetrying;){
                LockdowndClient lockdowndClient = (LockdowndClient)((Retrying)lockdownRetrying).perform(client -> client);
                this.install(lockdowndClient);
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    private void install(LockdowndClient lockdowndClient) throws Exception {
        if (!this.installed) {
            this.uploadInternal(lockdowndClient);
            if (this.uploadProgressCallback == null) {
                this.log("[ 50%%] Upload done. Installing app...", new Object[0]);
            }
            this.installInternal(lockdowndClient);
            this.installed = true;
        }
    }

    private Version mountDeveloperImageIfRequired(LockdowndClient lockdowndClient, Version deviceVersion) throws Exception {
        Retrying<MobileImageMounterClient> retrying;
        try (Retrying<MobileImageMounterClient> retrying2 = retrying = new Retrying<MobileImageMounterClient>(() -> {
            LockdowndServiceDescriptor mimService = lockdowndClient.startService("com.apple.mobile.mobile_image_mounter");
            return new MobileImageMounterClient(lockdowndClient.getDevice(), mimService);
        });){
            this.log("Checking if developer disk image requires to be mounted.", new Object[0]);
            NSDictionary result = (NSDictionary)((Retrying)retrying).perform(mimClient -> mimClient.lookupImage(null));
            NSArray imageSignature = (NSArray)result.objectForKey("ImageSignature");
            if (imageSignature != null && imageSignature.count() > 0) {
                this.log("Developer disk image is already mounted.", new Object[0]);
                Version version = null;
                return version;
            }
            File deviceSupport = DeveloperImageResolver.getDeviceSupportPath();
            this.log("Looking up developer disk image for iOS version %s in %s", deviceVersion, deviceSupport);
            DeveloperImageResolver.Response devImageResp = DeveloperImageResolver.findDeveloperImage(deviceSupport, deviceVersion);
            byte[] devImageSigBytes = Files.readAllBytes(devImageResp.signature.toPath());
            this.log("Copying developer disk image %s to device", devImageResp.dmg);
            ((Retrying)retrying).perform(mimClient -> mimClient.uploadImage(devImageResp.dmg, null, devImageSigBytes));
            this.log("Mounting developer disk image", new Object[0]);
            result = (NSDictionary)((Retrying)retrying).perform(mimClient -> mimClient.mountImage("/PublicStaging/staging.dimage", devImageSigBytes, null));
            NSString status = (NSString)result.objectForKey("Status");
            if (status == null || !"Complete".equals(status.toString())) {
                throw new IOException("Failed to mount " + devImageResp.dmg.getAbsolutePath() + " on the device.");
            }
            Thread.sleep(1000L);
            result = (NSDictionary)((Retrying)retrying).perform(mimClient -> mimClient.lookupImage(null));
            if (result.objectForKey("ImageSignature") == null) {
                throw new LibIMobileDeviceException("Developer disk image mounting failed: status not mounted!");
            }
            Version version = devImageResp.version;
            return version;
        }
    }

    private int launchInternal() throws Exception {
        Retrying<LockdowndClient> lockdownRetrying;
        String appPath = null;
        try (Retrying<LockdowndClient> retrying = lockdownRetrying = new Retrying<LockdowndClient>(() -> new LockdowndClient(this.findDevice(), this.getClass().getSimpleName(), true));){
            DebugServerClient client2;
            block24: {
                NSNumber developerModeStatus;
                LockdowndClient lockdowndClient = (LockdowndClient)((Retrying)lockdownRetrying).perform(client -> client);
                this.install(lockdowndClient);
                appPath = this.getAppPath(lockdowndClient, this.appId);
                String productVersion = lockdowndClient.getValue(null, "ProductVersion").toString();
                String buildVersion = lockdowndClient.getValue(null, "BuildVersion").toString();
                Version deviceVersion = Version.parse(productVersion);
                if (deviceVersion.getMajor() >= 16 && !(developerModeStatus = (NSNumber)lockdowndClient.getValue("com.apple.security.mac.amfi", "DeveloperModeStatus")).boolValue()) {
                    String msg = "You have to enable Developer Mode on the given device!";
                    this.log(msg, new Object[0]);
                    throw new RuntimeException(msg);
                }
                Version mountedDevImage = this.mountDeveloperImageIfRequired(lockdowndClient, deviceVersion);
                this.log("Starting DebugServerService.", new Object[0]);
                try (Retrying<AutoCloseable> retrying2 = new Retrying<AutoCloseable>(() -> null);){
                    ((Retrying)retrying2).perform(ignored -> {
                        NSNumber status = (NSNumber)lockdowndClient.getValue(null, "PasswordProtected");
                        if (status != null && status.boolValue()) {
                            throw new LibIMobileDeviceException(LockdowndError.LOCKDOWN_E_PASSWORD_PROTECTED.swigValue(), LockdowndError.LOCKDOWN_E_PASSWORD_PROTECTED.name());
                        }
                    });
                }
                String serviceName = deviceVersion.getMajor() >= 14 || mountedDevImage != null && mountedDevImage.compareTo(new Version(13, 6)) >= 0 ? "com.apple.debugserver.DVTSecureSocketProxy" : "com.apple.debugserver";
                LockdowndServiceDescriptor debugServerServiceDescriptor = lockdowndClient.startService(serviceName);
                if (this.appLauncherCallback != null) {
                    this.appLauncherCallback.setAppLaunchInfo(new AppLauncherCallback.AppLauncherInfo(lockdowndClient.getDevice(), appPath, productVersion, buildVersion));
                }
                client2 = new DebugServerClient(lockdowndClient.getDevice(), debugServerServiceDescriptor);
                try {
                    this.log("Debug server port: " + debugServerServiceDescriptor.getPort(), new Object[0]);
                    if (this.localPort != -1) {
                        String exe = ((NSDictionary)PropertyListParser.parse((File)new File(this.localAppPath, "Info.plist"))).objectForKey("CFBundleExecutable").toString();
                        this.log("launchios \"" + new File(this.localAppPath, exe).getAbsolutePath() + "\" \"" + appPath + "\" " + this.localPort, new Object[0]);
                        StringBuilder argsString = new StringBuilder();
                        for (String arg : this.args) {
                            if (argsString.length() > 0) {
                                argsString.append(' ');
                            }
                            argsString.append(arg);
                        }
                        this.log("process launch -- " + argsString, new Object[0]);
                    }
                    this.log("Remote app path: " + appPath, new Object[0]);
                    this.log("Launching app...", new Object[0]);
                    if (this.localPort != -1) break block24;
                    int n = this.pipeStdOut(client2, appPath);
                    client2.close();
                    return n;
                }
                catch (Throwable throwable) {
                    try {
                        client2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            int n = this.forward(client2, appPath);
            client2.close();
            return n;
        }
    }

    /*
     * Exception decompiling
     */
    private int pipeStdOut(DebugServerClient client, String appPath) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int forward(DebugServerClient client, String appPath) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK], 3[TRYBLOCK]], but top level block is 24[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void debugForward(OutputStream fileOut, String prefix, List<byte[]> messages) throws IOException {
        if (!this.debug) {
            return;
        }
        for (byte[] message : messages) {
            Object msgStr = null;
            msgStr = message.length > 256 ? "(" + message.length + ") " + new String(message, 0, 256, StandardCharsets.US_ASCII) : new String(message, StandardCharsets.US_ASCII);
            String msg = prefix + (String)msgStr;
            fileOut.write(msg.getBytes(StandardCharsets.US_ASCII));
            fileOut.write(10);
            System.out.println(msg);
        }
    }

    private void installInternal(LockdowndClient lockdowndClient) throws Exception {
        Retrying<InstallationProxyClient> retrying;
        final LibIMobileDeviceException[] ex = new LibIMobileDeviceException[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        try (Retrying<InstallationProxyClient> retrying2 = retrying = new Retrying<InstallationProxyClient>(() -> {
            LockdowndServiceDescriptor instproxyService = lockdowndClient.startService("com.apple.mobile.installation_proxy");
            return new InstallationProxyClient(lockdowndClient.getDevice(), instproxyService);
        });){
            ((Retrying)retrying).perform(instClient -> {
                instClient.upgrade("/PublicStaging/" + this.localAppPath.getName(), new InstallationProxyClient.Options().packageType(this.localAppPath.isDirectory() ? InstallationProxyClient.Options.PackageType.Developer : null), new InstallationProxyClient.StatusCallback(){

                    @Override
                    public void progress(String status, int percentComplete) {
                        if (AppLauncher.this.installStatusCallback != null) {
                            AppLauncher.this.installStatusCallback.progress(status, percentComplete);
                        } else {
                            AppLauncher.this.log("[%3d%%] %s", 50 + percentComplete / 2, status);
                        }
                    }

                    @Override
                    public void success() {
                        try {
                            if (AppLauncher.this.installStatusCallback != null) {
                                AppLauncher.this.installStatusCallback.success();
                            } else {
                                AppLauncher.this.log("[100%%] Installation complete", new Object[0]);
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }

                    @Override
                    public void error(String message) {
                        try {
                            ex[0] = new LibIMobileDeviceException(message);
                            if (AppLauncher.this.installStatusCallback != null) {
                                AppLauncher.this.installStatusCallback.error(message);
                            } else {
                                AppLauncher.this.log("Error: %s", message);
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                });
                countDownLatch.await();
            });
        }
        if (ex[0] != null) {
            throw ex[0];
        }
    }

    private void uploadInternal(LockdowndClient lockdowndClient) throws Exception {
        Retrying<AfcClient> retrying;
        try (Retrying<AfcClient> retrying2 = retrying = new Retrying<AfcClient>(() -> {
            LockdowndServiceDescriptor afcService = lockdowndClient.startService("com.apple.afc");
            return new AfcClient(lockdowndClient.getDevice(), afcService);
        });){
            ((Retrying)retrying).perform(afcClient -> afcClient.upload(this.localAppPath, "/PublicStaging", new AfcClient.UploadProgressCallback(){

                @Override
                public void progress(File path, int percentComplete) {
                    if (AppLauncher.this.uploadProgressCallback != null) {
                        AppLauncher.this.uploadProgressCallback.progress(path, percentComplete);
                    } else {
                        AppLauncher.this.log("[%3d%%] Uploading %s", percentComplete / 2, path);
                    }
                }

                @Override
                public void success() {
                    if (AppLauncher.this.uploadProgressCallback != null) {
                        AppLauncher.this.uploadProgressCallback.success();
                    }
                }

                @Override
                public void error(String message) {
                    if (AppLauncher.this.uploadProgressCallback != null) {
                        AppLauncher.this.uploadProgressCallback.error(message);
                    } else {
                        AppLauncher.this.log("Error: %s", message);
                    }
                }
            }));
        }
    }

    public int launch() throws IOException {
        try {
            int n = this.launchInternal();
            return n;
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.closeOutOnExit) {
                try {
                    this.stdout.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static void printUsageAndExit() {
        System.err.println(AppLauncher.class.getName() + " ...");
        System.err.println("  -appid    the id (CFBundleIdentifier) of the app to launch.");
        System.err.println("  -b path   to app bundle directory or IPA containing the app to launch.");
        System.err.println("  -udid     id of the device to launch on. If not specified the first device will be used.");
        System.err.println("  -debug    enable debug output.");
        System.err.println("  -f port   forwards the debug server connection to the local port after the app has launched");
        System.err.println("  -env name=value\n            adds an environment variable with the specified name and value.");
        System.err.println("  -args ... the rest of the command line will be passed on as args to the app.");
        System.exit(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) throws Exception {
        String appId = null;
        File localAppPath = null;
        String[] arguments = new String[]{};
        HashMap<String, String> env = new HashMap<String, String>();
        boolean debug = false;
        String deviceId = null;
        int forwardPort = -1;
        int i = 0;
        block21: while (i < args.length) {
            switch (args[i++]) {
                case "-h": 
                case "-help": {
                    AppLauncher.printUsageAndExit();
                    break;
                }
                case "-appid": {
                    appId = args[i++];
                    break;
                }
                case "-b": {
                    localAppPath = new File(args[i++]);
                    break;
                }
                case "-f": {
                    forwardPort = Integer.parseInt(args[i++]);
                    break;
                }
                case "-udid": {
                    deviceId = args[i++];
                    break;
                }
                case "-env": {
                    String[] parts = args[i++].split("=", 2);
                    env.put(parts[0], parts[1]);
                    break;
                }
                case "-debug": {
                    debug = true;
                    break;
                }
                case "-args": {
                    arguments = Arrays.copyOfRange(args, i, args.length);
                    break block21;
                }
            }
        }
        if (appId == null && localAppPath == null) {
            AppLauncher.printUsageAndExit();
        }
        AppLauncher launcher = localAppPath != null ? new AppLauncher(deviceId, localAppPath) : new AppLauncher(deviceId, appId);
        System.exit(launcher.args(arguments).env(env).debug(debug).forward(forwardPort).launch());
    }

    private class Retrying<Client extends AutoCloseable>
    implements AutoCloseable {
        private final int retries;
        private final int secondsBetweenRetries;
        private int retriesLeft;
        private Client client;
        private final Lambdas.CheckedSupplier<Client> clientConstructor;

        public Retrying(int retries, int secondsBetweenRetries, Lambdas.CheckedSupplier<Client> clientConstructor) {
            this.retries = retries;
            this.secondsBetweenRetries = secondsBetweenRetries;
            this.retriesLeft = retries;
            this.clientConstructor = clientConstructor;
        }

        public Retrying(Lambdas.CheckedSupplier<Client> clientConstructor) {
            this(appLauncher.launchOnLockedRetries, appLauncher.secondsBetweenLaunchOnLockedRetries, clientConstructor);
        }

        private void perform(Lambdas.CheckedConsumer<Client> action) throws Exception {
            this.perform((Client client) -> {
                action.accept(client);
                return null;
            });
        }

        private <R> R perform(Lambdas.CheckedFunction<Client, R> action) throws Exception {
            while (true) {
                try {
                    if (this.client == null) {
                        this.client = (AutoCloseable)this.clientConstructor.get();
                    }
                    R r = action.apply(this.client);
                    this.retriesLeft = this.retries;
                    return r;
                }
                catch (LibIMobileDeviceException e) {
                    if (this.client != null) {
                        try {
                            this.client.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.client = null;
                    }
                    String message = null;
                    boolean fatal = true;
                    if (this.retriesLeft > 0) {
                        --this.retriesLeft;
                        if (e.getErrorCode() == LockdowndError.LOCKDOWN_E_USER_DENIED_PAIRING.swigValue()) {
                            message = "Device is not paired with your computer, unlock it and choose to trust this computer when prompted.";
                        } else if (e.getErrorCode() == LockdowndError.LOCKDOWN_E_PAIRING_DIALOG_RESPONSE_PENDING.swigValue()) {
                            message = "Pairing in progress. Please choose to trust this computer.";
                            fatal = false;
                        } else if (e.getErrorCode() == LockdowndError.LOCKDOWN_E_PASSWORD_PROTECTED.swigValue() || e.getErrorCode() == MobileImageMounterError.MOBILE_IMAGE_MOUNTER_E_DEVICE_LOCKED.swigValue()) {
                            message = "Device is locked. Please unlock to proceed.";
                            fatal = false;
                        }
                    }
                    if (message != null) {
                        if (!fatal) {
                            AppLauncher.this.log(message + " (retry %d of %d)...", this.retries - this.retriesLeft, this.retries);
                        } else {
                            AppLauncher.this.log(message, new Object[0]);
                        }
                    }
                    if (fatal) {
                        throw e;
                    }
                    Thread.sleep((long)this.secondsBetweenRetries * 1000L);
                    continue;
                }
                break;
            }
        }

        @Override
        public void close() throws Exception {
            if (this.client != null) {
                this.client.close();
            }
        }
    }
}

