/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.hickory.testing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import net.java.dev.hickory.testing.LocationAndKind;
import net.java.dev.hickory.testing.MemClassLoader;
import net.java.dev.hickory.testing.MemJavaFileObject;
import net.java.dev.hickory.testing.MemSourceFileObject;
import net.java.dev.hickory.testing.internal.ramfilesystem.RAMFileSystemRegistry;

class MemFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    final Map<LocationAndKind, Map<String, JavaFileObject>> ramFileSystem = new HashMap<LocationAndKind, Map<String, JavaFileObject>>();
    private final ClassLoader ldr;
    private String urlPrefix;

    public MemFileManager(StandardJavaFileManager sjfm) {
        super(sjfm);
        HashMap classLoaderContent = new HashMap();
        this.ramFileSystem.put(new LocationAndKind(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.CLASS), classLoaderContent);
        this.ldr = new MemClassLoader(this.ramFileSystem, this);
        this.urlPrefix = RAMFileSystemRegistry.getInstance().getUrlPrefix(this);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        JavaFileObject jfo;
        String name = null;
        name = "".equals(packageName) ? relativeName : packageName.replace('.', '/') + "/" + relativeName;
        LocationAndKind key = new LocationAndKind(location, JavaFileObject.Kind.OTHER);
        if (this.ramFileSystem.containsKey(key) && (jfo = this.ramFileSystem.get(key).get(name)) != null) {
            return jfo;
        }
        jfo = new MemJavaFileObject(this.urlPrefix, name, JavaFileObject.Kind.OTHER);
        this.register(key, jfo);
        return jfo;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaFileObject jfo = null;
        LocationAndKind key = new LocationAndKind(location, kind);
        if (this.ramFileSystem.containsKey(key) && (jfo = this.ramFileSystem.get(key).get(name)) != null) {
            return jfo;
        }
        jfo = kind == JavaFileObject.Kind.SOURCE ? new MemSourceFileObject(name) : new MemJavaFileObject(this.urlPrefix, name, kind);
        this.register(key, jfo);
        return jfo;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void register(LocationAndKind key, JavaFileObject jfo) {
        if (!this.ramFileSystem.containsKey(key)) {
            this.ramFileSystem.put(key, new HashMap());
        }
        this.ramFileSystem.get(key).put(jfo.getName(), jfo);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.ldr;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject jfo) {
        String result = loc == StandardLocation.CLASS_PATH && jfo instanceof MemJavaFileObject ? jfo.getName() : super.inferBinaryName(loc, jfo);
        return result;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location loc, String pkg, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        for (JavaFileObject f : super.list(loc, pkg, kinds, recurse)) {
            result.add(f);
        }
        if (loc == StandardLocation.CLASS_PATH) {
            loc = StandardLocation.CLASS_OUTPUT;
        }
        for (JavaFileObject.Kind kind : kinds) {
            LocationAndKind key = new LocationAndKind(loc, kind);
            if (!this.ramFileSystem.containsKey(key)) continue;
            Map<String, JavaFileObject> locatedFiles = this.ramFileSystem.get(key);
            for (String name : locatedFiles.keySet()) {
                JavaFileObject candidate;
                String packageName = name.substring(0, name.lastIndexOf("."));
                if (!(recurse ? packageName.startsWith(pkg) : packageName.equals(pkg)) || !kinds.contains((Object)(candidate = locatedFiles.get(name)).getKind())) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a == b;
    }
}

