/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * hufu-api
 * 场景相关接口
 *
 * OpenAPI spec version: v1
 * Contact: 
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

package com.jdcloud.sdk.service.hufu.model;

import java.util.List;
import java.util.ArrayList;
import com.jdcloud.sdk.service.common.model.Filter;
import com.jdcloud.sdk.annotation.Required;
import com.jdcloud.sdk.service.JdcloudRequest;

/**
 * 查询api列表
 */
public class QueryApisRequest extends JdcloudRequest implements java.io.Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 页码, 默认为1, 取值范围：[1,∞)
     */
    private Integer pageNumber;

    /**
     * 分页大小，默认为20，取值范围：[10,100]
     */
    private Integer pageSize;

    /**
     * apiName - API名称，模糊匹配，支持单个
action - 动作，精确匹配，支持多个
backServiceType- 后端服务类型，精确匹配，支持多个
path - 路径，模糊匹配，支持单个
description - 描述，模糊匹配，支持单个

     */
    private List<Filter> filters;

    /**
     * 场景id
     * Required:true
     */
    @Required
    private Integer sceneId;

    /**
     * 版本号
     * Required:true
     */
    @Required
    private String revision;


    /**
     * get 页码, 默认为1, 取值范围：[1,∞)
     *
     * @return
     */
    public Integer getPageNumber() {
        return pageNumber;
    }

    /**
     * set 页码, 默认为1, 取值范围：[1,∞)
     *
     * @param pageNumber
     */
    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    /**
     * get 分页大小，默认为20，取值范围：[10,100]
     *
     * @return
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * set 分页大小，默认为20，取值范围：[10,100]
     *
     * @param pageSize
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * get apiName - API名称，模糊匹配，支持单个
action - 动作，精确匹配，支持多个
backServiceType- 后端服务类型，精确匹配，支持多个
path - 路径，模糊匹配，支持单个
description - 描述，模糊匹配，支持单个

     *
     * @return
     */
    public List<Filter> getFilters() {
        return filters;
    }

    /**
     * set apiName - API名称，模糊匹配，支持单个
action - 动作，精确匹配，支持多个
backServiceType- 后端服务类型，精确匹配，支持多个
path - 路径，模糊匹配，支持单个
description - 描述，模糊匹配，支持单个

     *
     * @param filters
     */
    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    /**
     * get 场景id
     *
     * @return
     */
    public Integer getSceneId() {
        return sceneId;
    }

    /**
     * set 场景id
     *
     * @param sceneId
     */
    public void setSceneId(Integer sceneId) {
        this.sceneId = sceneId;
    }

    /**
     * get 版本号
     *
     * @return
     */
    public String getRevision() {
        return revision;
    }

    /**
     * set 版本号
     *
     * @param revision
     */
    public void setRevision(String revision) {
        this.revision = revision;
    }


    /**
     * set 页码, 默认为1, 取值范围：[1,∞)
     *
     * @param pageNumber
     */
    public QueryApisRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    /**
     * set 分页大小，默认为20，取值范围：[10,100]
     *
     * @param pageSize
     */
    public QueryApisRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    /**
     * set apiName - API名称，模糊匹配，支持单个
action - 动作，精确匹配，支持多个
backServiceType- 后端服务类型，精确匹配，支持多个
path - 路径，模糊匹配，支持单个
description - 描述，模糊匹配，支持单个

     *
     * @param filters
     */
    public QueryApisRequest filters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    /**
     * set 场景id
     *
     * @param sceneId
     */
    public QueryApisRequest sceneId(Integer sceneId) {
        this.sceneId = sceneId;
        return this;
    }

    /**
     * set 版本号
     *
     * @param revision
     */
    public QueryApisRequest revision(String revision) {
        this.revision = revision;
        return this;
    }


    /**
     * add item to apiName - API名称，模糊匹配，支持单个
action - 动作，精确匹配，支持多个
backServiceType- 后端服务类型，精确匹配，支持多个
path - 路径，模糊匹配，支持单个
description - 描述，模糊匹配，支持单个

     *
     * @param filter
     */
    public void addFilter(Filter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<>();
        }
        this.filters.add(filter);
    }

}