/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.service.disk.client;

import com.jdcloud.sdk.JdcloudSdkException;
import com.jdcloud.sdk.auth.CredentialsProvider;
import com.jdcloud.sdk.client.Environment;
import com.jdcloud.sdk.client.Jdcloud;
import com.jdcloud.sdk.client.JdcloudClient;
import com.jdcloud.sdk.client.JdcloudValidateException;
import com.jdcloud.sdk.http.HttpRequestConfig;
import com.jdcloud.sdk.service.JdcloudRequest;
import com.jdcloud.sdk.service.disk.client.CreateSnapshotExecutor;
import com.jdcloud.sdk.service.disk.client.DescribeDiskExecutor;
import com.jdcloud.sdk.service.disk.client.DescribeDisksExecutor;
import com.jdcloud.sdk.service.disk.client.DescribeSnapshotExecutor;
import com.jdcloud.sdk.service.disk.client.DescribeSnapshotsExecutor;
import com.jdcloud.sdk.service.disk.client.RestoreDiskExecutor;
import com.jdcloud.sdk.service.disk.model.CreateSnapshotRequest;
import com.jdcloud.sdk.service.disk.model.CreateSnapshotResponse;
import com.jdcloud.sdk.service.disk.model.DescribeDiskRequest;
import com.jdcloud.sdk.service.disk.model.DescribeDiskResponse;
import com.jdcloud.sdk.service.disk.model.DescribeDisksRequest;
import com.jdcloud.sdk.service.disk.model.DescribeDisksResponse;
import com.jdcloud.sdk.service.disk.model.DescribeSnapshotRequest;
import com.jdcloud.sdk.service.disk.model.DescribeSnapshotResponse;
import com.jdcloud.sdk.service.disk.model.DescribeSnapshotsRequest;
import com.jdcloud.sdk.service.disk.model.DescribeSnapshotsResponse;
import com.jdcloud.sdk.service.disk.model.RestoreDiskRequest;
import com.jdcloud.sdk.service.disk.model.RestoreDiskResponse;

public class DiskClient
extends JdcloudClient {
    public static final String ApiVersion = "v1";
    private static final String UserAgentPrefix = "JdcloudSdkJava";
    public static final String ClientVersion = "1.0.0";
    public static final String DefaultEndpoint = "disk.jdcloud-api.com";
    public static final String ServiceName = "disk";
    public static final String UserAgent = "JdcloudSdkJava/1.0.0 disk/v1";
    CredentialsProvider credentialsProvider;
    HttpRequestConfig httpRequestConfig;
    Environment environment = new Environment.Builder().endpoint("disk.jdcloud-api.com").build();

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public HttpRequestConfig getHttpRequestConfig() {
        return this.httpRequestConfig;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getUserAgent() {
        return UserAgent;
    }

    public String getServiceName() {
        return ServiceName;
    }

    public String getVersion() {
        return ApiVersion;
    }

    private DiskClient() {
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest request) throws JdcloudSdkException {
        return (CreateSnapshotResponse)new CreateSnapshotExecutor().client(this).execute((JdcloudRequest)request);
    }

    public RestoreDiskResponse restoreDisk(RestoreDiskRequest request) throws JdcloudSdkException {
        return (RestoreDiskResponse)new RestoreDiskExecutor().client(this).execute((JdcloudRequest)request);
    }

    public DescribeDisksResponse describeDisks(DescribeDisksRequest request) throws JdcloudSdkException {
        return (DescribeDisksResponse)new DescribeDisksExecutor().client(this).execute((JdcloudRequest)request);
    }

    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest request) throws JdcloudSdkException {
        return (DescribeSnapshotsResponse)new DescribeSnapshotsExecutor().client(this).execute((JdcloudRequest)request);
    }

    public DescribeDiskResponse describeDisk(DescribeDiskRequest request) throws JdcloudSdkException {
        return (DescribeDiskResponse)new DescribeDiskExecutor().client(this).execute((JdcloudRequest)request);
    }

    public DescribeSnapshotResponse describeSnapshot(DescribeSnapshotRequest request) throws JdcloudSdkException {
        return (DescribeSnapshotResponse)new DescribeSnapshotExecutor().client(this).execute((JdcloudRequest)request);
    }

    private static class DefaultBuilder
    implements Builder {
        private DiskClient diskClient = new DiskClient();

        @Override
        public DefaultBuilder credentialsProvider(CredentialsProvider provider) {
            this.diskClient.credentialsProvider = provider;
            return this;
        }

        @Override
        public DefaultBuilder httpRequestConfig(HttpRequestConfig config) {
            this.diskClient.httpRequestConfig = config;
            return this;
        }

        @Override
        public DiskClient build() throws JdcloudSdkException {
            if (this.diskClient.credentialsProvider == null) {
                this.diskClient.credentialsProvider = Jdcloud.defaultInstance().getCredentialsProvider();
                if (this.diskClient.credentialsProvider == null) {
                    throw new JdcloudValidateException("DiskClient build error: jdcloud credentials provider not set");
                }
            }
            if (this.diskClient.httpRequestConfig == null) {
                this.diskClient.httpRequestConfig = Jdcloud.defaultInstance().getHttpRequestConfig();
                if (this.diskClient.httpRequestConfig == null) {
                    throw new JdcloudValidateException("DiskClient build error: http request config not set");
                }
            }
            return this.diskClient;
        }

        @Override
        public Builder environment(Environment environment) {
            this.diskClient.environment = environment;
            return this;
        }
    }

    public static interface Builder {
        public Builder credentialsProvider(CredentialsProvider var1);

        public Builder environment(Environment var1);

        public Builder httpRequestConfig(HttpRequestConfig var1);

        public DiskClient build() throws JdcloudSdkException;
    }
}

