/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase09package;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.AndroidSigner;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.Sign;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ApkMojo
extends AbstractAndroidMojo {
    private Sign sign;
    private String signDebug;
    private File nativeLibrariesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.generateApk) {
            return;
        }
        this.generateIntermediateAp_();
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File outputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".apk");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(outputFile.getAbsolutePath());
        if (!this.getAndroidSigner().isSignWithDebugKeyStore()) {
            commands.add("-u");
        }
        commands.add("-z");
        commands.add(new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_").getAbsolutePath());
        commands.add("-f");
        commands.add(new File(this.project.getBuild().getDirectory(), "classes.dex").getAbsolutePath());
        commands.add("-rf");
        commands.add(new File(this.project.getBuild().getDirectory(), "classes").getAbsolutePath());
        if (this.nativeLibrariesDirectory != null && this.nativeLibrariesDirectory.exists()) {
            commands.add("-nf");
            commands.add(this.nativeLibrariesDirectory.getAbsolutePath());
        }
        for (Artifact artifact : this.getRelevantCompileArtifacts()) {
            commands.add("-rj");
            commands.add(artifact.getFile().getAbsolutePath());
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("apkbuilder") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("apkbuilder"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        this.project.getArtifact().setFile(outputFile);
    }

    private void generateIntermediateAp_() throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File[] overlayDirectories = this.resourceOverlayDirectories == null || this.resourceOverlayDirectories.length == 0 ? new File[]{this.resourceOverlayDirectory} : this.resourceOverlayDirectories;
        if (!this.combinedRes.exists() && !this.combinedRes.mkdirs()) {
            throw new MojoExecutionException("Could not create directory for combined resources at " + this.combinedRes.getAbsolutePath());
        }
        if (this.extractedDependenciesRes.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying dependency resource files to combined resource directory.");
                FileUtils.copyDirectory((File)this.extractedDependenciesRes, (File)this.combinedRes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        if (this.resourceDirectory.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying local resource files to combined resource directory.");
                FileUtils.copyDirectory((File)this.resourceDirectory, (File)this.combinedRes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        File androidJar = this.getAndroidSdk().getAndroidJar();
        File outputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-f");
        commands.add("-M");
        commands.add(this.androidManifestFile.getAbsolutePath());
        for (File resOverlayDir : overlayDirectories) {
            if (resOverlayDir == null || !resOverlayDir.exists()) continue;
            commands.add("-S");
            commands.add(resOverlayDir.getAbsolutePath());
        }
        if (this.combinedRes.exists()) {
            commands.add("-S");
            commands.add(this.combinedRes.getAbsolutePath());
        }
        if (this.assetsDirectory.exists()) {
            commands.add("-A");
            commands.add(this.assetsDirectory.getAbsolutePath());
        }
        if (this.extractedDependenciesAssets.exists()) {
            commands.add("-A");
            commands.add(this.extractedDependenciesAssets.getAbsolutePath());
        }
        commands.add("-I");
        commands.add(androidJar.getAbsolutePath());
        commands.add("-F");
        commands.add(outputFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("aapt") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("aapt"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    protected AndroidSigner getAndroidSigner() {
        if (this.sign == null) {
            return new AndroidSigner(this.signDebug);
        }
        return new AndroidSigner(this.sign.getDebug());
    }
}

