/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.common.AndroidExtension;
import com.jayway.maven.plugins.android.configuration.Manifest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManifestUpdateMojo
extends AbstractAndroidMojo {
    private static final String ATTR_VERSION_NAME = "android:versionName";
    private static final String ATTR_VERSION_CODE = "android:versionCode";
    private static final String ATTR_SHARED_USER_ID = "android:sharedUserId";
    private static final String ATTR_DEBUGGABLE = "android:debuggable";
    private static final String ELEM_APPLICATION = "application";
    private Manifest manifest;
    protected String manifestVersionName;
    protected Integer manifestVersionCode;
    private boolean manifestVersionCodeAutoIncrement = false;
    protected Boolean manifestVersionCodeUpdateFromVersion = false;
    protected String manifestSharedUserId;
    protected Boolean manifestDebuggable;
    private String parsedVersionName;
    private Integer parsedVersionCode;
    private boolean parsedVersionCodeAutoIncrement;
    private Boolean parsedVersionCodeUpdateFromVersion;
    private String parsedSharedUserId;
    private Boolean parsedDebuggable;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!AndroidExtension.isAndroidPackaging(this.project.getPackaging())) {
            return;
        }
        if (this.androidManifestFile == null) {
            return;
        }
        this.parseConfiguration();
        this.getLog().info((CharSequence)("Attempting to update manifest " + this.androidManifestFile));
        this.getLog().debug((CharSequence)("    versionName=" + this.parsedVersionName));
        this.getLog().debug((CharSequence)("    versionCode=" + this.parsedVersionCode));
        this.getLog().debug((CharSequence)("    versionCodeAutoIncrement=" + this.parsedVersionCodeAutoIncrement));
        this.getLog().debug((CharSequence)("    versionCodeUpdateFromVersion=" + this.parsedVersionCodeUpdateFromVersion));
        this.getLog().debug((CharSequence)("    sharedUserId=" + this.parsedSharedUserId));
        this.getLog().debug((CharSequence)("    debuggable=" + this.parsedDebuggable));
        if (!this.androidManifestFile.exists()) {
            return;
        }
        try {
            this.updateManifest(this.androidManifestFile);
        }
        catch (IOException e) {
            throw new MojoFailureException("XML I/O error: " + this.androidManifestFile, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoFailureException("Unable to prepare XML parser", (Throwable)e);
        }
        catch (SAXException e) {
            throw new MojoFailureException("Unable to parse XML: " + this.androidManifestFile, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new MojoFailureException("Unable write XML: " + this.androidManifestFile, (Throwable)e);
        }
    }

    private void parseConfiguration() {
        if (this.manifest != null) {
            this.parsedVersionName = this.manifest.getVersionName();
            this.parsedVersionCode = this.manifest.getVersionCode();
            this.parsedVersionCodeAutoIncrement = this.manifest.isVersionCodeAutoIncrement();
            this.parsedVersionCodeUpdateFromVersion = this.manifest.getVersionCodeUpdateFromVersion();
            this.parsedSharedUserId = this.manifest.getSharedUserId();
            this.parsedDebuggable = this.manifest.getDebuggable();
        } else {
            this.parsedVersionName = this.manifestVersionName;
            this.parsedVersionCode = this.manifestVersionCode;
            this.parsedVersionCodeAutoIncrement = this.manifestVersionCodeAutoIncrement;
            this.parsedVersionCodeUpdateFromVersion = this.manifestVersionCodeUpdateFromVersion;
            this.parsedSharedUserId = this.manifestSharedUserId;
            this.parsedDebuggable = this.manifestDebuggable;
        }
    }

    private Document readManifest(File manifestFile) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(manifestFile);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeManifest(File manifestFile, Document doc) throws IOException, TransformerException {
        TransformerFactory xfactory = TransformerFactory.newInstance();
        Transformer xformer = xfactory.newTransformer();
        xformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(doc);
        FileWriter writer = null;
        try {
            writer = new FileWriter(manifestFile, false);
            String xmldecl = String.format("<?xml version=\"%s\" encoding=\"%s\"?>%n", doc.getXmlVersion(), doc.getXmlEncoding());
            writer.write(xmldecl);
            StreamResult result = new StreamResult(writer);
            xformer.transform(source, result);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void updateManifest(File manifestFile) throws IOException, ParserConfigurationException, SAXException, TransformerException, MojoFailureException {
        Attr sharedUserIdAttrib;
        Attr versionNameAttrib;
        Document doc = this.readManifest(manifestFile);
        Element manifestElement = doc.getDocumentElement();
        boolean dirty = false;
        if (StringUtils.isEmpty((String)this.parsedVersionName)) {
            this.parsedVersionName = this.project.getVersion();
        }
        if ((versionNameAttrib = manifestElement.getAttributeNode(ATTR_VERSION_NAME)) == null || !StringUtils.equals((String)this.parsedVersionName, (String)versionNameAttrib.getValue())) {
            this.getLog().info((CharSequence)("Setting android:versionName to " + this.parsedVersionName));
            manifestElement.setAttribute(ATTR_VERSION_NAME, this.parsedVersionName);
            dirty = true;
        }
        if (this.parsedVersionCodeAutoIncrement && this.parsedVersionCode != null || this.parsedVersionCodeUpdateFromVersion != false && this.parsedVersionCode != null || this.parsedVersionCodeAutoIncrement && this.parsedVersionCodeUpdateFromVersion.booleanValue()) {
            throw new MojoFailureException("versionCodeAutoIncrement, versionCodeUpdateFromVersion and versionCode are mutual exclusive. They cannot be specified at the same time. Please specify either versionCodeAutoIncrement, versionCodeUpdateFromVersion or versionCode!");
        }
        if (this.parsedVersionCodeAutoIncrement) {
            Attr versionCode = manifestElement.getAttributeNode(ATTR_VERSION_CODE);
            int currentVersionCode = 0;
            if (versionCode != null) {
                currentVersionCode = NumberUtils.toInt((String)versionCode.getValue(), (int)0);
            }
            manifestElement.setAttribute(ATTR_VERSION_CODE, String.valueOf(++currentVersionCode));
            dirty = true;
        }
        if (this.parsedVersionCodeUpdateFromVersion.booleanValue()) {
            String verString = this.project.getVersion();
            this.getLog().debug((CharSequence)("Generating versionCode for " + verString));
            DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(verString);
            String verCode = Integer.toString(artifactVersion.getMajorVersion()) + Integer.toString(artifactVersion.getMinorVersion()) + Integer.toString(artifactVersion.getIncrementalVersion());
            this.getLog().info((CharSequence)("Setting android:versionCode to " + verCode));
            manifestElement.setAttribute(ATTR_VERSION_CODE, verCode);
            dirty = true;
        }
        if (this.parsedVersionCode != null) {
            Attr versionCodeAttr = manifestElement.getAttributeNode(ATTR_VERSION_CODE);
            int currentVersionCode = 0;
            if (versionCodeAttr != null) {
                currentVersionCode = NumberUtils.toInt((String)versionCodeAttr.getValue(), (int)0);
            }
            if (currentVersionCode != this.parsedVersionCode) {
                this.getLog().info((CharSequence)("Setting android:versionCode to " + this.parsedVersionCode));
                manifestElement.setAttribute(ATTR_VERSION_CODE, String.valueOf(this.parsedVersionCode));
                dirty = true;
            }
        }
        if (!(StringUtils.isEmpty((String)this.parsedSharedUserId) || (sharedUserIdAttrib = manifestElement.getAttributeNode(ATTR_SHARED_USER_ID)) != null && StringUtils.equals((String)this.parsedSharedUserId, (String)sharedUserIdAttrib.getValue()))) {
            this.getLog().info((CharSequence)("Setting android:sharedUserId to " + this.parsedSharedUserId));
            manifestElement.setAttribute(ATTR_SHARED_USER_ID, this.parsedSharedUserId);
            dirty = true;
        }
        if (this.parsedDebuggable != null) {
            NodeList appElems = manifestElement.getElementsByTagName(ELEM_APPLICATION);
            for (int i = 0; i < appElems.getLength(); ++i) {
                Element element;
                Attr debuggableAttrib;
                Node node = appElems.item(i);
                this.getLog().info((CharSequence)("Testing if node " + node.getNodeName() + " is application"));
                if (node.getNodeType() != 1 || (debuggableAttrib = (element = (Element)node).getAttributeNode(ATTR_DEBUGGABLE)) != null && this.parsedDebuggable == BooleanUtils.toBoolean((String)debuggableAttrib.getValue())) continue;
                this.getLog().info((CharSequence)("Setting android:debuggable to " + this.parsedDebuggable));
                element.setAttribute(ATTR_DEBUGGABLE, String.valueOf(this.parsedDebuggable));
                dirty = true;
            }
        }
        if (dirty) {
            if (!manifestFile.delete()) {
                this.getLog().warn((CharSequence)("Could not remove old " + manifestFile));
            }
            this.getLog().info((CharSequence)("Made changes to manifest file, updating " + manifestFile));
            this.writeManifest(manifestFile, doc);
        } else {
            this.getLog().info((CharSequence)"No changes found to write to manifest file");
        }
    }
}

