/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.dao.engine.impl;

import com.ibatis.dao.client.Dao;
import com.ibatis.dao.client.DaoException;
import com.ibatis.dao.client.DaoTransaction;
import com.ibatis.dao.engine.impl.DaoImpl;
import com.ibatis.dao.engine.impl.DaoTransactionState;
import com.ibatis.dao.engine.impl.StandardDaoManager;
import com.ibatis.dao.engine.transaction.DaoTransactionManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DaoContext {
    private String id;
    private StandardDaoManager daoManager;
    private DaoTransactionManager transactionManager;
    private ThreadLocal transaction = new ThreadLocal();
    private ThreadLocal state = new ThreadLocal();
    private Map typeDaoImplMap = new HashMap();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public StandardDaoManager getDaoManager() {
        return this.daoManager;
    }

    public void setDaoManager(StandardDaoManager daoManager) {
        this.daoManager = daoManager;
    }

    public DaoTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(DaoTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void addDao(DaoImpl daoImpl) {
        if (this.typeDaoImplMap.containsKey(daoImpl.getDaoInterface())) {
            throw new DaoException("More than one implementation for '" + daoImpl.getDaoInterface() + "' was configured.  " + "Only one implementation per context is allowed.");
        }
        this.typeDaoImplMap.put(daoImpl.getDaoInterface(), daoImpl);
    }

    public Dao getDao(Class iface) {
        DaoImpl impl = (DaoImpl)this.typeDaoImplMap.get(iface);
        if (impl == null) {
            throw new DaoException("There is no DAO implementation found for " + iface + " in this context.");
        }
        return impl.getProxy();
    }

    public Iterator getDaoImpls() {
        return this.typeDaoImplMap.values().iterator();
    }

    public DaoTransaction getTransaction() {
        this.startTransaction();
        return (DaoTransaction)this.transaction.get();
    }

    public void startTransaction() {
        if (this.state.get() != DaoTransactionState.ACTIVE) {
            DaoTransaction trans = this.transactionManager.startTransaction();
            this.transaction.set(trans);
            this.state.set(DaoTransactionState.ACTIVE);
            this.daoManager.addContextInTransaction(this);
        }
    }

    public void commitTransaction() {
        DaoTransaction trans = (DaoTransaction)this.transaction.get();
        if (this.state.get() == DaoTransactionState.ACTIVE) {
            this.transactionManager.commitTransaction(trans);
            this.state.set(DaoTransactionState.COMMITTED);
        } else {
            this.state.set(DaoTransactionState.INACTIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        DaoTransaction trans = (DaoTransaction)this.transaction.get();
        if (this.state.get() == DaoTransactionState.ACTIVE) {
            try {
                this.transactionManager.rollbackTransaction(trans);
                Object var3_2 = null;
                this.state.set(DaoTransactionState.ROLLEDBACK);
                this.transaction.set(null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.state.set(DaoTransactionState.ROLLEDBACK);
                this.transaction.set(null);
                throw throwable;
            }
        } else {
            this.state.set(DaoTransactionState.INACTIVE);
            this.transaction.set(null);
        }
    }
}

