/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.immutables.utils;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@JsonDeserialize(using=Deserializer.class)
public final class WireSafeEnum<T extends Enum<T>> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Map<Class<?>, Map<?, WireSafeEnum<?>>> ENUM_LOOKUP_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, WireSafeEnum<?>>> JSON_LOOKUP_CACHE = new ConcurrentHashMap();
    private final Class<T> enumType;
    private final String jsonValue;
    private final Optional<T> enumValue;

    private WireSafeEnum(Class<T> enumType, String jsonValue, T enumValue) {
        this.enumType = WireSafeEnum.checkNotNull(enumType, "enumType");
        this.jsonValue = WireSafeEnum.checkNotNull(jsonValue, "jsonValue");
        this.enumValue = Optional.of((Enum)WireSafeEnum.checkNotNull(enumValue, "enumValue"));
    }

    private WireSafeEnum(Class<T> enumType, String jsonValue) {
        this.enumType = WireSafeEnum.checkNotNull(enumType, "enumType");
        this.jsonValue = WireSafeEnum.checkNotNull(jsonValue, "jsonValue");
        this.enumValue = Optional.empty();
    }

    @Nonnull
    public static <T extends Enum<T>> WireSafeEnum<T> of(@Nonnull T value) {
        WireSafeEnum.checkNotNull(value, "value");
        Class<?> enumType = WireSafeEnum.getRealEnumType(value.getClass());
        WireSafeEnum.ensureEnumCacheInitialized(enumType);
        return ENUM_LOOKUP_CACHE.get(enumType).get(value);
    }

    @Nonnull
    public static <T extends Enum<T>> WireSafeEnum<T> fromJson(@Nonnull Class<T> enumType, @Nonnull String jsonValue) {
        return WireSafeEnum.fromJson(enumType, jsonValue, WireSafeEnum::new);
    }

    @Nonnull
    private static <T extends Enum<T>> WireSafeEnum<T> fromJson(@Nonnull Class<T> enumType, @Nonnull String jsonValue, @Nonnull BiFunction<Class<T>, String, WireSafeEnum<T>> fallback) {
        WireSafeEnum.checkNotNull(enumType, "enumType");
        WireSafeEnum.checkNotNull(jsonValue, "jsonValue");
        WireSafeEnum.checkNotNull(fallback, "fallback");
        enumType = WireSafeEnum.getRealEnumType(enumType);
        WireSafeEnum.ensureJsonCacheInitialized(enumType);
        WireSafeEnum<?> cached = JSON_LOOKUP_CACHE.get(enumType).get(jsonValue);
        if (cached == null) {
            return fallback.apply(enumType, jsonValue);
        }
        return cached;
    }

    @Nonnull
    public Class<T> enumType() {
        return this.enumType;
    }

    @Nonnull
    @JsonValue
    public String asString() {
        return this.jsonValue;
    }

    @Nonnull
    public Optional<T> asEnum() {
        return this.enumValue;
    }

    @Nonnull
    @Deprecated
    public <X extends Throwable> T asEnumOrThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return (T)((Enum)this.asEnum().orElseThrow(exceptionSupplier));
    }

    @Nonnull
    @Deprecated
    public T asEnumOrThrow() {
        return this.asEnumOrThrow(this::getInvalidValueException);
    }

    private IllegalStateException getInvalidValueException() {
        Collection<WireSafeEnum<?>> wiresafeEnumTypes = JSON_LOOKUP_CACHE.get(this.enumType).values();
        String validMembers = Arrays.toString(wiresafeEnumTypes.stream().map(WireSafeEnum::asString).distinct().sorted().toArray());
        String message = String.format("Value '%s' is not valid for enum of type '%s'. Valid values are: %s", this.jsonValue, this.enumType.getSimpleName(), validMembers);
        return new IllegalStateException(message);
    }

    public boolean contains(@Nonnull T value) {
        WireSafeEnum.checkNotNull(value, "value");
        return this.enumValue.isPresent() && this.enumValue.get() == value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WireSafeEnum that = (WireSafeEnum)o;
        return Objects.equals(this.enumType, that.enumType) && Objects.equals(this.jsonValue, that.jsonValue) && Objects.equals(this.enumValue, that.enumValue);
    }

    public int hashCode() {
        return Objects.hash(this.enumType, this.jsonValue, this.enumValue);
    }

    public String toString() {
        return new StringJoiner(", ", "WireSafeEnum[", "]").add("enumType=" + this.enumType).add("jsonValue='" + this.jsonValue + "'").add("enumValue=" + this.enumValue).toString();
    }

    private static <T> T checkNotNull(T o, String name) {
        return Objects.requireNonNull(o, name + " must not be null");
    }

    private static <T extends Enum<T>> void ensureEnumCacheInitialized(Class<T> enumType) {
        if (!ENUM_LOOKUP_CACHE.containsKey(enumType)) {
            WireSafeEnum.initializeCache(enumType);
        }
    }

    private static <T extends Enum<T>> void ensureJsonCacheInitialized(Class<T> enumType) {
        if (!JSON_LOOKUP_CACHE.containsKey(enumType)) {
            WireSafeEnum.initializeCache(enumType);
        }
    }

    private static <T extends Enum<T>> void initializeCache(Class<T> enumType) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        ArrayNode stringArray = (ArrayNode)MAPPER.valueToTree((Object)enumConstants);
        Enum[] deserializedConstants = (Enum[])MAPPER.convertValue((Object)stringArray, (JavaType)MAPPER.getTypeFactory().constructArrayType(enumType));
        EnumMap<T, WireSafeEnum<Enum>> enumMap = new EnumMap<T, WireSafeEnum<Enum>>(enumType);
        HashMap<String, WireSafeEnum<Enum>> jsonMap = new HashMap<String, WireSafeEnum<Enum>>(WireSafeEnum.mapCapacity(enumConstants.length));
        for (int i = 0; i < enumConstants.length; ++i) {
            Enum enumValue = enumConstants[i];
            JsonNode jsonNode = stringArray.get(i);
            Enum deserializedValue = deserializedConstants[i];
            if (!jsonNode.isTextual()) {
                String message = "Invalid JSON value in enum type: " + enumType.getTypeName() + "\n" + ("Constant " + enumValue.name() + " serialized as: " + jsonNode + "\n") + "Enums wrapped in WireSafeEnum must serialize to JSON as a non-null string";
                throw new IllegalStateException(message);
            }
            String jsonValue = jsonNode.textValue();
            WireSafeEnum<Enum> wireSafeEnum = new WireSafeEnum<Enum>(enumType, jsonValue, enumValue);
            enumMap.put(enumValue, wireSafeEnum);
            if (enumValue != deserializedValue) continue;
            jsonMap.put(jsonValue, wireSafeEnum);
        }
        ENUM_LOOKUP_CACHE.put(enumType, enumMap);
        JSON_LOOKUP_CACHE.put(enumType, jsonMap);
    }

    private static <T extends Enum<T>> Class<T> getRealEnumType(Class<T> enumType) {
        Class<T> superType = enumType.getSuperclass();
        if (Enum.class.equals(superType)) {
            return enumType;
        }
        if (superType == null || !Enum.class.equals(superType.getSuperclass()) || !superType.equals(enumType.getEnclosingClass())) {
            throw new IllegalArgumentException("Provided type is not an enum or a direct subclass of an enum");
        }
        Class<T> widenedType = superType;
        return widenedType;
    }

    private static int mapCapacity(int elements) {
        if (elements < 3) {
            return elements + 1;
        }
        return (int)((float)elements / 0.75f + 1.0f);
    }

    /* synthetic */ WireSafeEnum(Class x0, String x1, Enum x2, 1 x3) {
        this(x0, x1, x2);
    }

    public static class Deserializer
    extends JsonDeserializer<WireSafeEnum<?>>
    implements ContextualDeserializer {
        private static final Map<JavaType, JsonDeserializer<WireSafeEnum<?>>> DESERIALIZER_CACHE = new ConcurrentHashMap();

        public WireSafeEnum<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            throw ctxt.mappingException("Expected createContextual to be called");
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JavaType contextualType = ctxt.getContextualType();
            if (contextualType == null || !contextualType.hasRawClass(WireSafeEnum.class)) {
                throw ctxt.mappingException("Can not handle contextualType: " + contextualType);
            }
            JavaType[] typeParameters = contextualType.findTypeParameters(WireSafeEnum.class);
            if (typeParameters.length != 1) {
                throw ctxt.mappingException("Can not discover enum type for: " + contextualType);
            }
            if (!typeParameters[0].isEnumType()) {
                throw ctxt.mappingException("Can not handle non-enum type: " + typeParameters[0].getRawClass());
            }
            return Deserializer.deserializerFor(typeParameters[0]);
        }

        private static JsonDeserializer<?> deserializerFor(JavaType javaType) {
            return DESERIALIZER_CACHE.computeIfAbsent(javaType, Deserializer::newDeserializer);
        }

        private static <T extends Enum<T>> JsonDeserializer<WireSafeEnum<?>> newDeserializer(final JavaType enumType) {
            return new JsonDeserializer<WireSafeEnum<?>>(){

                public WireSafeEnum<T> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                    if (p.getCurrentToken() == JsonToken.VALUE_NULL) {
                        return null;
                    }
                    if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                        Class rawType = enumType.getRawClass();
                        return WireSafeEnum.fromJson(rawType, p.getText(), (klass, value) -> this.create((Class)klass, (String)value, p, ctxt));
                    }
                    throw ctxt.wrongTokenException(p, JsonToken.VALUE_STRING, null);
                }

                private WireSafeEnum<T> create(Class<T> rawClass, String jsonValue, JsonParser parser, DeserializationContext ctxt) {
                    return this.deserializeValue(parser, ctxt).map(v -> new WireSafeEnum(rawClass, jsonValue, (Enum)v, null)).orElseGet(() -> new WireSafeEnum(rawClass, jsonValue));
                }

                private Optional<T> deserializeValue(JsonParser p, DeserializationContext ctxt) {
                    try {
                        JsonDeserializer deserializer = ctxt.findNonContextualValueDeserializer(enumType);
                        if (deserializer == null) {
                            return Optional.empty();
                        }
                        return Optional.ofNullable((Enum)deserializer.deserialize(p, ctxt));
                    }
                    catch (Exception e) {
                        return Optional.empty();
                    }
                }
            };
        }
    }
}

