/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.impl.ItemListenerManager;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.ClusterOperation;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionClientProxy<E>
extends AbstractCollection<E> {
    protected final ProxyHelper proxyHelper;
    protected final String name;

    public CollectionClientProxy(HazelcastClient hazelcastClient, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, hazelcastClient);
    }

    public CollectionClientProxy(ProxyHelper proxyHelper, String name) {
        this.name = name;
        this.proxyHelper = proxyHelper;
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.name;
    }

    @Override
    public Iterator<E> iterator() {
        final Collection<E> collection = this.getTheCollection();
        final CollectionClientProxy proxy = this;
        return new Iterator<E>(){
            Iterator<E> iterator;
            volatile E lastRecord;
            {
                this.iterator = collection.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                this.lastRecord = this.iterator.next();
                return this.lastRecord;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                proxy.remove(this.lastRecord);
            }
        };
    }

    protected abstract Collection<E> getTheCollection();

    @Override
    public String toString() {
        return "CollectionClientProxy{name='" + this.name + '\'' + '}';
    }

    public synchronized void addItemListener(ItemListener<E> listener, boolean includeValue) {
        ProxyHelper.check(listener);
        Call c = this.itemListenerManager().createNewAddListenerCall(this.proxyHelper, includeValue);
        this.itemListenerManager().registerListener(this.name, listener);
        this.proxyHelper.doCall(c);
    }

    public synchronized void removeItemListener(ItemListener<E> listener) {
        ProxyHelper.check(listener);
        this.itemListenerManager().removeListener(this.name, listener);
        Packet request = this.proxyHelper.createRequestPacket(ClusterOperation.REMOVE_LISTENER, null, null);
        Call c = this.proxyHelper.createCall(request);
        this.proxyHelper.doCall(c);
    }

    private ItemListenerManager itemListenerManager() {
        return this.proxyHelper.getHazelcastClient().getListenerManager().getItemListenerManager();
    }

    @Override
    public int size() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_SIZE, null, null);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }
}

