/*
 * Decompiled with CFR 0.152.
 */
package apparat.embedding.maven;

import apparat.embedding.maven.MavenLogAdapter;
import apparat.log.Log;
import apparat.log.LogLevel;
import apparat.log.LogOutput;
import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

abstract class AbstractApparatMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File overrideArtifact;
    protected boolean failIfOverrideIsMissing;

    AbstractApparatMojo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block11: {
            MavenLogAdapter logAdapter = new MavenLogAdapter(this.getLog());
            try {
                Log.setLevel((LogLevel)logAdapter.getLevel());
                Log.addOutput((LogOutput)logAdapter);
                if (null == this.overrideArtifact) {
                    if (null != this.project) {
                        this.processArtifact(this.project.getArtifact());
                        for (Artifact artifact : this.project.getAttachedArtifacts()) {
                            this.processArtifact(artifact);
                        }
                    }
                    break block11;
                }
                if (!this.overrideArtifact.exists()) {
                    if (this.failIfOverrideIsMissing) {
                        throw new MojoFailureException("File " + this.overrideArtifact + " does not exist.");
                    }
                    this.getLog().warn((CharSequence)("Override " + this.overrideArtifact + " is missing."));
                    return;
                }
                try {
                    this.processFile(this.overrideArtifact);
                }
                catch (Throwable cause) {
                    throw new MojoExecutionException("Apparat execution failed.", cause);
                }
            }
            finally {
                Log.removeOutput((LogOutput)logAdapter);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processArtifact(Artifact artifact) throws MojoExecutionException, MojoFailureException {
        if (null == artifact) {
            return;
        }
        String artifactType = artifact.getType();
        if (artifactType.equals("swc") || artifactType.equals("swf")) {
            try {
                if (null == artifact.getFile()) return;
                this.processFile(artifact.getFile());
                return;
            }
            catch (Throwable cause) {
                throw new MojoExecutionException("Apparat execution failed.", cause);
            }
        } else {
            this.getLog().debug((CharSequence)("Skipped artifact since its type is " + artifactType + "."));
        }
    }

    protected abstract void processFile(File var1) throws MojoExecutionException, MojoFailureException;
}

