/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ApiStreamObserver;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ClientCallFactory;
import com.google.common.base.Preconditions;
import io.grpc.ClientCall;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;

class DirectStreamingCallable<RequestT, ResponseT> {
    private final ClientCallFactory<RequestT, ResponseT> factory;

    DirectStreamingCallable(ClientCallFactory<RequestT, ResponseT> factory) {
        Preconditions.checkNotNull(factory);
        this.factory = factory;
    }

    void serverStreamingCall(RequestT request, ApiStreamObserver<ResponseT> responseObserver, CallContext context) {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(responseObserver);
        ClientCall<RequestT, ResponseT> call = this.factory.newCall(context.getChannel(), context.getCallOptions());
        ClientCalls.asyncServerStreamingCall(call, request, new RpcStreamObserverDelegate<ResponseT>(responseObserver));
    }

    Iterator<ResponseT> blockingServerStreamingCall(RequestT request, CallContext context) {
        Preconditions.checkNotNull(request);
        ClientCall<RequestT, ResponseT> call = this.factory.newCall(context.getChannel(), context.getCallOptions());
        return ClientCalls.blockingServerStreamingCall(call, request);
    }

    ApiStreamObserver<RequestT> bidiStreamingCall(ApiStreamObserver<ResponseT> responseObserver, CallContext context) {
        Preconditions.checkNotNull(responseObserver);
        ClientCall<RequestT, ResponseT> call = this.factory.newCall(context.getChannel(), context.getCallOptions());
        return new StreamObserverDelegate(ClientCalls.asyncBidiStreamingCall(call, new RpcStreamObserverDelegate<ResponseT>(responseObserver)));
    }

    ApiStreamObserver<RequestT> clientStreamingCall(ApiStreamObserver<ResponseT> responseObserver, CallContext context) {
        Preconditions.checkNotNull(responseObserver);
        ClientCall<RequestT, ResponseT> call = this.factory.newCall(context.getChannel(), context.getCallOptions());
        return new StreamObserverDelegate(ClientCalls.asyncClientStreamingCall(call, new RpcStreamObserverDelegate<ResponseT>(responseObserver)));
    }

    private static class StreamObserverDelegate<V>
    implements ApiStreamObserver<V> {
        private final StreamObserver<V> delegate;

        public StreamObserverDelegate(StreamObserver<V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onNext(V v) {
            this.delegate.onNext(v);
        }

        @Override
        public void onError(Throwable throwable) {
            this.delegate.onError(throwable);
        }

        @Override
        public void onCompleted() {
            this.delegate.onCompleted();
        }
    }

    private static class RpcStreamObserverDelegate<V>
    implements StreamObserver<V> {
        private final ApiStreamObserver<V> delegate;

        public RpcStreamObserverDelegate(ApiStreamObserver<V> delegate) {
            this.delegate = delegate;
        }

        public void onNext(V v) {
            this.delegate.onNext(v);
        }

        public void onError(Throwable throwable) {
            this.delegate.onError(throwable);
        }

        public void onCompleted() {
            this.delegate.onCompleted();
        }
    }
}

