/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db.domain;

import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DatabaseFilter {
    public static final int DEFAULT_LIMIT = 100;
    private final int limit;
    private String startingAfterDbId;
    private final Include include;
    private final CloudProviderType provider;

    public DatabaseFilter() {
        DatabaseFilter f = DatabaseFilter.builder().build();
        f.getStartingAfterDbId().ifPresent(dbId -> {
            this.startingAfterDbId = dbId;
        });
        this.limit = f.getLimit();
        this.include = f.getInclude();
        this.provider = f.getProvider();
    }

    public DatabaseFilter(int limit, Include i, CloudProviderType p, String startingAfter) {
        this.startingAfterDbId = startingAfter;
        this.limit = limit;
        this.include = i;
        this.provider = p;
    }

    public String urlParams() {
        StringBuilder sbURL = new StringBuilder("?").append("include=" + this.getInclude().name().toLowerCase()).append("&provider=" + this.getProvider().name().toLowerCase()).append("&limit=" + this.getLimit());
        if (this.startingAfterDbId != null) {
            sbURL.append("&starting_after=" + this.startingAfterDbId);
        }
        return sbURL.toString();
    }

    public static DatabaseFilterBuilder builder() {
        return new DatabaseFilterBuilder();
    }

    public int getLimit() {
        return this.limit;
    }

    public Optional<String> getStartingAfterDbId() {
        return Optional.ofNullable(this.startingAfterDbId);
    }

    public Include getInclude() {
        return this.include;
    }

    public CloudProviderType getProvider() {
        return this.provider;
    }

    public static class DatabaseFilterBuilder {
        private int limit = 100;
        private String startingAfterDbId = null;
        private CloudProviderType provider = CloudProviderType.ALL;
        private Include include = Include.NON_TERMINATED;

        public DatabaseFilterBuilder limit(int l) {
            this.limit = l;
            return this;
        }

        public DatabaseFilterBuilder startingAfterDbId(String dbId) {
            this.startingAfterDbId = dbId;
            return this;
        }

        public DatabaseFilterBuilder provider(CloudProviderType p) {
            this.provider = p;
            return this;
        }

        public DatabaseFilterBuilder include(Include i) {
            this.include = i;
            return this;
        }

        public DatabaseFilter build() {
            return new DatabaseFilter(this.limit, this.include, this.provider, this.startingAfterDbId);
        }
    }

    public static enum Include {
        NON_TERMINATED,
        ALL,
        ACTIVE,
        PENDING,
        PREPARING,
        PREPARED,
        INITIALIZING,
        PARKING,
        PARKED,
        UNPARKING,
        TERMINATING,
        TERMINATED,
        RESIZING,
        ERROR,
        MAINTENANCE,
        HIBERNATING,
        HIBERNATED;

    }
}

