/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor;

import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExecutorExceptionHandler.class);
    private static final ThreadLocal<Boolean> IS_EXCEPTION_THROWN = new ThreadLocal();

    public static void setExceptionThrown(boolean isExceptionThrown) {
        IS_EXCEPTION_THROWN.set(isExceptionThrown);
    }

    public static boolean isExceptionThrown() {
        return null == IS_EXCEPTION_THROWN.get() ? true : IS_EXCEPTION_THROWN.get();
    }

    public static void handleException(Exception ex) {
        if (ExecutorExceptionHandler.isExceptionThrown()) {
            throw new ShardingJdbcException(ex);
        }
        log.error("exception occur: ", (Throwable)ex);
    }

    private ExecutorExceptionHandler() {
    }
}

