/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.jmx;

import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;

public final class ApolloClientJmxMBeanRegister {
    private static final Logger logger = DeferredLoggerFactory.getLogger(ApolloClientJmxMBeanRegister.class);
    private static MBeanServer mbeanServer;
    private static ObjectName ERROR_OBJECT_NAME;

    public static synchronized void setMBeanServer(MBeanServer mbeanServer) {
        ApolloClientJmxMBeanRegister.mbeanServer = mbeanServer;
    }

    public static synchronized ObjectName register(String name, Object mbean) {
        try {
            ObjectName objectName = new ObjectName(name);
            if (mbeanServer == null) {
                mbeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            if (mbeanServer.isRegistered(objectName)) {
                mbeanServer.unregisterMBean(objectName);
            }
            mbeanServer.registerMBean(mbean, objectName);
            return objectName;
        }
        catch (JMException e) {
            logger.error("Register JMX MBean failed.", (Throwable)e);
            return ERROR_OBJECT_NAME;
        }
    }

    public static synchronized void unregister(String name) {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            mbeanServer.unregisterMBean(new ObjectName(name));
        }
        catch (JMException e) {
            logger.error("Unregister JMX MBean failed.", (Throwable)e);
        }
    }

    static {
        try {
            ERROR_OBJECT_NAME = new ObjectName("apollo.client.monitor:type=error");
        }
        catch (MalformedObjectNameException e) {
            logger.warn("MalformedObjectNameException during static initialization.", (Throwable)e);
        }
    }
}

