/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.enums.ConfigSourceType;
import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.internals.AbstractConfigRepository;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.internals.RepositoryChangeListener;
import com.ctrip.framework.apollo.kubernetes.KubernetesManager;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.ctrip.framework.apollo.util.escape.EscapeUtil;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public class K8sConfigMapConfigRepository
extends AbstractConfigRepository
implements RepositoryChangeListener {
    private static final Logger logger = DeferredLoggerFactory.getLogger(K8sConfigMapConfigRepository.class);
    private final String appId;
    private final String namespace;
    private String configMapName;
    private String configMapKey;
    private final String k8sNamespace;
    private final ConfigUtil configUtil;
    private final KubernetesManager kubernetesManager;
    private volatile Properties configMapProperties;
    private volatile ConfigRepository upstream;
    private volatile ConfigSourceType sourceType = ConfigSourceType.CONFIGMAP;
    private static final Gson GSON = new Gson();

    public K8sConfigMapConfigRepository(String appId, String namespace, ConfigRepository upstream) {
        this.appId = appId;
        this.namespace = namespace;
        this.configUtil = ApolloInjector.getInstance(ConfigUtil.class);
        this.kubernetesManager = ApolloInjector.getInstance(KubernetesManager.class);
        this.k8sNamespace = this.configUtil.getK8sNamespace();
        this.setConfigMapKey(this.configUtil.getCluster(), namespace);
        this.setConfigMapName(this.configUtil.getAppId(), false);
        this.setUpstreamRepository(upstream);
    }

    private void setConfigMapKey(String cluster, String namespace) {
        if (StringUtils.isBlank((String)cluster)) {
            this.configMapKey = EscapeUtil.createConfigMapKey("default", namespace);
            return;
        }
        this.configMapKey = EscapeUtil.createConfigMapKey(cluster, namespace);
    }

    private void setConfigMapName(String appId, boolean syncImmediately) {
        Preconditions.checkNotNull((Object)appId, (Object)"AppId cannot be null");
        this.configMapName = "apollo-configcache-" + appId;
        this.checkConfigMapName(this.configMapName);
        if (syncImmediately) {
            this.sync();
        }
    }

    private void checkConfigMapName(String configMapName) {
        if (StringUtils.isBlank((String)configMapName)) {
            throw new IllegalArgumentException("ConfigMap name cannot be null");
        }
        if (this.kubernetesManager.checkConfigMapExist(this.k8sNamespace, configMapName)) {
            return;
        }
        Transaction transaction = Tracer.newTransaction((String)"Apollo.ConfigService", (String)"createK8sConfigMap");
        transaction.addData("configMapName", (Object)configMapName);
        try {
            this.kubernetesManager.createConfigMap(this.k8sNamespace, configMapName, null);
            transaction.setStatus("0");
        }
        catch (Throwable ex) {
            Tracer.logEvent((String)"ApolloConfigException", (String)ExceptionUtil.getDetailMessage(ex));
            transaction.setStatus(ex);
            throw new ApolloConfigException("Create configmap failed!", ex);
        }
        finally {
            transaction.complete();
        }
    }

    @Override
    public Properties getConfig() {
        if (this.configMapProperties == null) {
            this.sync();
        }
        Properties result = this.propertiesFactory.getPropertiesInstance();
        result.putAll((Map<?, ?>)this.configMapProperties);
        return result;
    }

    @Override
    public void setUpstreamRepository(ConfigRepository upstreamConfigRepository) {
        if (upstreamConfigRepository == null) {
            return;
        }
        if (this.upstream != null) {
            this.upstream.removeChangeListener(this);
        }
        this.upstream = upstreamConfigRepository;
        upstreamConfigRepository.addChangeListener(this);
    }

    @Override
    public ConfigSourceType getSourceType() {
        return this.sourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sync() {
        boolean syncFromUpstreamResultSuccess = this.trySyncFromUpstream();
        if (syncFromUpstreamResultSuccess) {
            return;
        }
        Transaction transaction = Tracer.newTransaction((String)"Apollo.ConfigService", (String)"syncK8sConfigMap");
        Throwable exception = null;
        try {
            this.configMapProperties = this.loadFromK8sConfigMap();
            this.sourceType = ConfigSourceType.CONFIGMAP;
            transaction.setStatus("0");
        }
        catch (Throwable ex) {
            Tracer.logEvent((String)"ApolloConfigException", (String)ExceptionUtil.getDetailMessage(ex));
            transaction.setStatus(ex);
            exception = ex;
        }
        finally {
            transaction.complete();
        }
        if (this.configMapProperties == null) {
            this.sourceType = ConfigSourceType.NONE;
            throw new ApolloConfigException("Load config from Kubernetes ConfigMap failed!", exception);
        }
    }

    Properties loadFromK8sConfigMap() {
        Preconditions.checkNotNull((Object)this.configMapName, (Object)"ConfigMap name cannot be null");
        try {
            String jsonConfig = this.kubernetesManager.getValueFromConfigMap(this.k8sNamespace, this.configMapName, this.configMapKey);
            Properties properties = this.propertiesFactory.getPropertiesInstance();
            if (jsonConfig != null && !jsonConfig.isEmpty()) {
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map configMap = (Map)GSON.fromJson(jsonConfig, type);
                configMap.forEach(properties::setProperty);
            }
            return properties;
        }
        catch (Exception ex) {
            Tracer.logError((Throwable)ex);
            throw new ApolloConfigException(String.format("Load config from Kubernetes ConfigMap %s failed!", this.configMapName), ex);
        }
    }

    private boolean trySyncFromUpstream() {
        if (this.upstream == null) {
            return false;
        }
        try {
            this.updateConfigMapProperties(this.upstream.getConfig(), this.upstream.getSourceType());
            return true;
        }
        catch (Throwable ex) {
            Tracer.logError((Throwable)ex);
            logger.warn("Sync config from upstream repository {} failed, reason: {}", this.upstream.getClass(), (Object)ExceptionUtil.getDetailMessage(ex));
            return false;
        }
    }

    private synchronized void updateConfigMapProperties(Properties newProperties, ConfigSourceType sourceType) {
        this.sourceType = sourceType;
        if (newProperties == null || newProperties.equals(this.configMapProperties)) {
            return;
        }
        this.configMapProperties = newProperties;
        this.persistConfigMap(this.configMapProperties);
    }

    @Override
    public void onRepositoryChange(String namespace, Properties newProperties) {
        this.onRepositoryChange(this.appId, namespace, newProperties);
    }

    @Override
    public void onRepositoryChange(String appId, String namespace, Properties newProperties) {
        if (newProperties == null || newProperties.equals(this.configMapProperties)) {
            return;
        }
        Properties newFileProperties = this.propertiesFactory.getPropertiesInstance();
        newFileProperties.putAll((Map<?, ?>)newProperties);
        this.updateConfigMapProperties(newFileProperties, this.upstream.getSourceType());
        this.fireRepositoryChange(appId, namespace, newProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistConfigMap(Properties properties) {
        Transaction transaction = Tracer.newTransaction((String)"Apollo.ConfigService", (String)"persistK8sConfigMap");
        transaction.addData("configMapName", (Object)this.configMapName);
        transaction.addData("k8sNamespace", (Object)this.k8sNamespace);
        try {
            String jsonConfig = GSON.toJson((Object)properties);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(this.configMapKey, jsonConfig);
            this.kubernetesManager.updateConfigMap(this.k8sNamespace, this.configMapName, data);
            transaction.setStatus("0");
        }
        catch (Exception ex) {
            ApolloConfigException exception = new ApolloConfigException(String.format("Persist config to Kubernetes ConfigMap %s failed!", this.configMapName), ex);
            Tracer.logError((Throwable)exception);
            transaction.setStatus((Throwable)exception);
            logger.error("Persist config to Kubernetes ConfigMap failed!", (Throwable)exception);
        }
        finally {
            transaction.complete();
        }
    }
}

