/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.ByteVector;
import com.vectorsearch.faiss.swig.IOReader;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class VectorIOReader
extends IOReader {
    private transient long swigCPtr;

    protected VectorIOReader(long cPtr, boolean cMemoryOwn) {
        super(swigfaissJNI.VectorIOReader_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(VectorIOReader obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_VectorIOReader(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setData(ByteVector value) {
        swigfaissJNI.VectorIOReader_data_set(this.swigCPtr, this, ByteVector.getCPtr(value), value);
    }

    public ByteVector getData() {
        long cPtr = swigfaissJNI.VectorIOReader_data_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new ByteVector(cPtr, false);
    }

    public void setRp(long value) {
        swigfaissJNI.VectorIOReader_rp_set(this.swigCPtr, this, value);
    }

    public long getRp() {
        return swigfaissJNI.VectorIOReader_rp_get(this.swigCPtr, this);
    }

    public VectorIOReader() {
        this(swigfaissJNI.new_VectorIOReader(), true);
    }
}

