/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.FloatVector;
import com.vectorsearch.faiss.swig.LinearTransform;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_float;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class PCAMatrix
extends LinearTransform {
    private transient long swigCPtr;

    protected PCAMatrix(long cPtr, boolean cMemoryOwn) {
        super(swigfaissJNI.PCAMatrix_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(PCAMatrix obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_PCAMatrix(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setEigen_power(float value) {
        swigfaissJNI.PCAMatrix_eigen_power_set(this.swigCPtr, this, value);
    }

    public float getEigen_power() {
        return swigfaissJNI.PCAMatrix_eigen_power_get(this.swigCPtr, this);
    }

    public void setRandom_rotation(boolean value) {
        swigfaissJNI.PCAMatrix_random_rotation_set(this.swigCPtr, this, value);
    }

    public boolean getRandom_rotation() {
        return swigfaissJNI.PCAMatrix_random_rotation_get(this.swigCPtr, this);
    }

    public void setMax_points_per_d(long value) {
        swigfaissJNI.PCAMatrix_max_points_per_d_set(this.swigCPtr, this, value);
    }

    public long getMax_points_per_d() {
        return swigfaissJNI.PCAMatrix_max_points_per_d_get(this.swigCPtr, this);
    }

    public void setBalanced_bins(int value) {
        swigfaissJNI.PCAMatrix_balanced_bins_set(this.swigCPtr, this, value);
    }

    public int getBalanced_bins() {
        return swigfaissJNI.PCAMatrix_balanced_bins_get(this.swigCPtr, this);
    }

    public void setMean(FloatVector value) {
        swigfaissJNI.PCAMatrix_mean_set(this.swigCPtr, this, FloatVector.getCPtr(value), value);
    }

    public FloatVector getMean() {
        long cPtr = swigfaissJNI.PCAMatrix_mean_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new FloatVector(cPtr, false);
    }

    public void setEigenvalues(FloatVector value) {
        swigfaissJNI.PCAMatrix_eigenvalues_set(this.swigCPtr, this, FloatVector.getCPtr(value), value);
    }

    public FloatVector getEigenvalues() {
        long cPtr = swigfaissJNI.PCAMatrix_eigenvalues_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new FloatVector(cPtr, false);
    }

    public void setPCAMat(FloatVector value) {
        swigfaissJNI.PCAMatrix_PCAMat_set(this.swigCPtr, this, FloatVector.getCPtr(value), value);
    }

    public FloatVector getPCAMat() {
        long cPtr = swigfaissJNI.PCAMatrix_PCAMat_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new FloatVector(cPtr, false);
    }

    public PCAMatrix(int d_in, int d_out, float eigen_power, boolean random_rotation) {
        this(swigfaissJNI.new_PCAMatrix__SWIG_0(d_in, d_out, eigen_power, random_rotation), true);
    }

    public PCAMatrix(int d_in, int d_out, float eigen_power) {
        this(swigfaissJNI.new_PCAMatrix__SWIG_1(d_in, d_out, eigen_power), true);
    }

    public PCAMatrix(int d_in, int d_out) {
        this(swigfaissJNI.new_PCAMatrix__SWIG_2(d_in, d_out), true);
    }

    public PCAMatrix(int d_in) {
        this(swigfaissJNI.new_PCAMatrix__SWIG_3(d_in), true);
    }

    public PCAMatrix() {
        this(swigfaissJNI.new_PCAMatrix__SWIG_4(), true);
    }

    @Override
    public void train(long n, SWIGTYPE_p_float x) {
        swigfaissJNI.PCAMatrix_train(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x));
    }

    public void copy_from(PCAMatrix other) {
        swigfaissJNI.PCAMatrix_copy_from(this.swigCPtr, this, PCAMatrix.getCPtr(other), other);
    }

    public void prepare_Ab() {
        swigfaissJNI.PCAMatrix_prepare_Ab(this.swigCPtr, this);
    }
}

