/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.DistanceComputer;
import com.vectorsearch.faiss.swig.IDSelector;
import com.vectorsearch.faiss.swig.MetricType;
import com.vectorsearch.faiss.swig.RangeSearchResult;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_float;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_long;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_unsigned_char;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class Index {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Index(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Index obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_Index(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setD(int value) {
        swigfaissJNI.Index_d_set(this.swigCPtr, this, value);
    }

    public int getD() {
        return swigfaissJNI.Index_d_get(this.swigCPtr, this);
    }

    public void setNtotal(long value) {
        swigfaissJNI.Index_ntotal_set(this.swigCPtr, this, value);
    }

    public long getNtotal() {
        return swigfaissJNI.Index_ntotal_get(this.swigCPtr, this);
    }

    public void setVerbose(boolean value) {
        swigfaissJNI.Index_verbose_set(this.swigCPtr, this, value);
    }

    public boolean getVerbose() {
        return swigfaissJNI.Index_verbose_get(this.swigCPtr, this);
    }

    public void setIs_trained(boolean value) {
        swigfaissJNI.Index_is_trained_set(this.swigCPtr, this, value);
    }

    public boolean getIs_trained() {
        return swigfaissJNI.Index_is_trained_get(this.swigCPtr, this);
    }

    public void setMetric_type(MetricType value) {
        swigfaissJNI.Index_metric_type_set(this.swigCPtr, this, value.swigValue());
    }

    public MetricType getMetric_type() {
        return MetricType.swigToEnum(swigfaissJNI.Index_metric_type_get(this.swigCPtr, this));
    }

    public void setMetric_arg(float value) {
        swigfaissJNI.Index_metric_arg_set(this.swigCPtr, this, value);
    }

    public float getMetric_arg() {
        return swigfaissJNI.Index_metric_arg_get(this.swigCPtr, this);
    }

    public void train(long n, SWIGTYPE_p_float x) {
        swigfaissJNI.Index_train(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x));
    }

    public void add(long n, SWIGTYPE_p_float x) {
        swigfaissJNI.Index_add(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x));
    }

    public void add_with_ids(long n, SWIGTYPE_p_float x, SWIGTYPE_p_long xids) {
        swigfaissJNI.Index_add_with_ids(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_long.getCPtr(xids));
    }

    public void search(long n, SWIGTYPE_p_float x, long k, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels) {
        swigfaissJNI.Index_search(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels));
    }

    public void range_search(long n, SWIGTYPE_p_float x, float radius, RangeSearchResult result) {
        swigfaissJNI.Index_range_search(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), radius, RangeSearchResult.getCPtr(result), result);
    }

    public void assign(long n, SWIGTYPE_p_float x, SWIGTYPE_p_long labels, long k) {
        swigfaissJNI.Index_assign__SWIG_0(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_long.getCPtr(labels), k);
    }

    public void assign(long n, SWIGTYPE_p_float x, SWIGTYPE_p_long labels) {
        swigfaissJNI.Index_assign__SWIG_1(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_long.getCPtr(labels));
    }

    public void reset() {
        swigfaissJNI.Index_reset(this.swigCPtr, this);
    }

    public long remove_ids(IDSelector sel) {
        return swigfaissJNI.Index_remove_ids(this.swigCPtr, this, IDSelector.getCPtr(sel), sel);
    }

    public void reconstruct(long key, SWIGTYPE_p_float recons) {
        swigfaissJNI.Index_reconstruct(this.swigCPtr, this, key, SWIGTYPE_p_float.getCPtr(recons));
    }

    public void reconstruct_n(long i0, long ni, SWIGTYPE_p_float recons) {
        swigfaissJNI.Index_reconstruct_n(this.swigCPtr, this, i0, ni, SWIGTYPE_p_float.getCPtr(recons));
    }

    public void search_and_reconstruct(long n, SWIGTYPE_p_float x, long k, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels, SWIGTYPE_p_float recons) {
        swigfaissJNI.Index_search_and_reconstruct(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels), SWIGTYPE_p_float.getCPtr(recons));
    }

    public void compute_residual(SWIGTYPE_p_float x, SWIGTYPE_p_float residual, long key) {
        swigfaissJNI.Index_compute_residual(this.swigCPtr, this, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_float.getCPtr(residual), key);
    }

    public void compute_residual_n(long n, SWIGTYPE_p_float xs, SWIGTYPE_p_float residuals, SWIGTYPE_p_long keys) {
        swigfaissJNI.Index_compute_residual_n(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(xs), SWIGTYPE_p_float.getCPtr(residuals), SWIGTYPE_p_long.getCPtr(keys));
    }

    public DistanceComputer get_distance_computer() {
        long cPtr = swigfaissJNI.Index_get_distance_computer(this.swigCPtr, this);
        return cPtr == 0L ? null : new DistanceComputer(cPtr, true);
    }

    public long sa_code_size() {
        return swigfaissJNI.Index_sa_code_size(this.swigCPtr, this);
    }

    public void sa_encode(long n, SWIGTYPE_p_float x, SWIGTYPE_p_unsigned_char bytes) {
        swigfaissJNI.Index_sa_encode(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_unsigned_char.getCPtr(bytes));
    }

    public void sa_decode(long n, SWIGTYPE_p_unsigned_char bytes, SWIGTYPE_p_float x) {
        swigfaissJNI.Index_sa_decode(this.swigCPtr, this, n, SWIGTYPE_p_unsigned_char.getCPtr(bytes), SWIGTYPE_p_float.getCPtr(x));
    }
}

