/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.ClusteringIterationStatsVector;
import com.vectorsearch.faiss.swig.ClusteringParameters;
import com.vectorsearch.faiss.swig.FloatVector;
import com.vectorsearch.faiss.swig.Index;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_float;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_unsigned_char;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class Clustering
extends ClusteringParameters {
    private transient long swigCPtr;

    protected Clustering(long cPtr, boolean cMemoryOwn) {
        super(swigfaissJNI.Clustering_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Clustering obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_Clustering(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setD(long value) {
        swigfaissJNI.Clustering_d_set(this.swigCPtr, this, value);
    }

    public long getD() {
        return swigfaissJNI.Clustering_d_get(this.swigCPtr, this);
    }

    public void setK(long value) {
        swigfaissJNI.Clustering_k_set(this.swigCPtr, this, value);
    }

    public long getK() {
        return swigfaissJNI.Clustering_k_get(this.swigCPtr, this);
    }

    public void setCentroids(FloatVector value) {
        swigfaissJNI.Clustering_centroids_set(this.swigCPtr, this, FloatVector.getCPtr(value), value);
    }

    public FloatVector getCentroids() {
        long cPtr = swigfaissJNI.Clustering_centroids_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new FloatVector(cPtr, false);
    }

    public void setIteration_stats(ClusteringIterationStatsVector value) {
        swigfaissJNI.Clustering_iteration_stats_set(this.swigCPtr, this, ClusteringIterationStatsVector.getCPtr(value), value);
    }

    public ClusteringIterationStatsVector getIteration_stats() {
        long cPtr = swigfaissJNI.Clustering_iteration_stats_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new ClusteringIterationStatsVector(cPtr, false);
    }

    public Clustering(int d, int k) {
        this(swigfaissJNI.new_Clustering__SWIG_0(d, k), true);
    }

    public Clustering(int d, int k, ClusteringParameters cp) {
        this(swigfaissJNI.new_Clustering__SWIG_1(d, k, ClusteringParameters.getCPtr(cp), cp), true);
    }

    public void train(long n, SWIGTYPE_p_float x, Index index, SWIGTYPE_p_float x_weights) {
        swigfaissJNI.Clustering_train__SWIG_0(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), Index.getCPtr(index), index, SWIGTYPE_p_float.getCPtr(x_weights));
    }

    public void train(long n, SWIGTYPE_p_float x, Index index) {
        swigfaissJNI.Clustering_train__SWIG_1(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), Index.getCPtr(index), index);
    }

    public void train_encoded(long nx, SWIGTYPE_p_unsigned_char x_in, Index codec, Index index, SWIGTYPE_p_float weights) {
        swigfaissJNI.Clustering_train_encoded__SWIG_0(this.swigCPtr, this, nx, SWIGTYPE_p_unsigned_char.getCPtr(x_in), Index.getCPtr(codec), codec, Index.getCPtr(index), index, SWIGTYPE_p_float.getCPtr(weights));
    }

    public void train_encoded(long nx, SWIGTYPE_p_unsigned_char x_in, Index codec, Index index) {
        swigfaissJNI.Clustering_train_encoded__SWIG_1(this.swigCPtr, this, nx, SWIGTYPE_p_unsigned_char.getCPtr(x_in), Index.getCPtr(codec), codec, Index.getCPtr(index), index);
    }

    public void post_process_centroids() {
        swigfaissJNI.Clustering_post_process_centroids(this.swigCPtr, this);
    }
}

